/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZGroup;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.component.ZShape;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import edu.umd.cs.jazz.util.ZRenderContext;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.IOException;

public class ZClipGroup
extends ZGroup {
    protected ZShape clip = null;
    protected boolean isClipVisible = true;
    protected boolean isClipPickable = true;

    public ZClipGroup() {
    }

    public ZClipGroup(ZNode child) {
        super(child);
    }

    public boolean isClipVisible() {
        return this.isClipVisible;
    }

    public void setClipVisible(boolean aBoolean) {
        this.isClipVisible = aBoolean;
        this.repaint();
    }

    public boolean isClipPickable() {
        return this.isClipPickable;
    }

    public void setClipPickable(boolean aBoolean) {
        this.isClipPickable = aBoolean;
    }

    protected void computeBounds() {
        if (this.clip != null) {
            this.bounds.setFrame(this.clip.getBounds());
        } else {
            super.computeBounds();
        }
    }

    public ZShape getClip() {
        return this.clip;
    }

    protected Object duplicateObject() {
        ZClipGroup newObject = (ZClipGroup)super.duplicateObject();
        if (this.clip != null) {
            newObject.clip = (ZShape)this.clip.clone();
        }
        return newObject;
    }

    public boolean pick(Rectangle2D rect, ZSceneGraphPath path) {
        if (this.clip != null && !this.clip.getShape().intersects(rect)) {
            return false;
        }
        if (!super.pick(rect, path)) {
            if (this.isClipPickable && this.clip != null && this.clip.pick(rect, path)) {
                path.push(this);
                path.setObject(this);
                return true;
            }
            return false;
        }
        return true;
    }

    public void render(ZRenderContext renderContext) {
        Graphics2D g2 = renderContext.getGraphics2D();
        if (this.clip != null) {
            Shape currentClip = g2.getClip();
            g2.clip(this.clip.getShape());
            if (this.isClipVisible) {
                this.clip.render(renderContext);
            }
            super.render(renderContext);
            g2.setClip(currentClip);
        } else {
            super.render(renderContext);
        }
    }

    public void setClip(ZShape aClip) {
        if (this.clip != null) {
            this.clip.removeParent(this);
        }
        this.clip = aClip;
        if (this.clip != null) {
            this.clip.addParent(this);
        }
        this.reshape();
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        super.setState(fieldType, fieldName, fieldValue);
        if (fieldName.compareTo("clip") == 0) {
            this.setClip((ZShape)fieldValue);
        }
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        super.writeObject(out);
        if (this.clip != null) {
            out.writeState("ZShape", "clip", this.clip);
        }
    }

    public void writeObjectRecurse(ZObjectOutputStream out) throws IOException {
        super.writeObjectRecurse(out);
        if (this.clip != null) {
            out.addObject(this.clip);
        }
    }
}

