/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZGroup;
import edu.umd.cs.jazz.ZHandle;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.event.ZHandleEventHandler;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.util.ZRenderContext;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class ZHandleGroup
extends ZGroup {
    private static ZHandleEventHandler DEFAULT_EVENT_HANDLER = new ZHandleEventHandler(null);
    private transient ArrayList fHandles;
    private transient ZHandleEventHandler fHandleInteractor;

    public static void setDefaultEventHandler(ZHandleEventHandler aEventHandler) {
        DEFAULT_EVENT_HANDLER = aEventHandler;
    }

    public ZHandleGroup() {
    }

    public ZHandleGroup(ZNode child) {
        super(child);
    }

    public void setEventHandler(ZHandleEventHandler aEventHandler) {
        this.fHandleInteractor = aEventHandler;
    }

    public ZHandleEventHandler getEventHandler() {
        if (this.fHandleInteractor == null) {
            this.fHandleInteractor = DEFAULT_EVENT_HANDLER;
        }
        return this.fHandleInteractor;
    }

    protected void addHandle(ZHandle aHandle) {
        this.getHandles().add(aHandle);
        aHandle.setHandleGroup(this);
        aHandle.computeBounds();
    }

    public void clearHandles() {
        Iterator i = this.getHandles().iterator();
        while (i.hasNext()) {
            ZHandle zHandle = (ZHandle)i.next();
        }
        this.getHandles().clear();
    }

    public void computeBounds() {
        super.computeBounds();
        Iterator i = this.getHandles().iterator();
        while (i.hasNext()) {
            ZHandle each = (ZHandle)i.next();
            this.bounds.add(each.getBoundsReference());
        }
    }

    public Collection getHandles() {
        if (this.fHandles == null) {
            this.fHandles = new ArrayList(0);
        }
        return this.fHandles;
    }

    public boolean pick(Rectangle2D rect, ZSceneGraphPath aPath) {
        aPath.push(this);
        Iterator i = this.getHandles().iterator();
        while (i.hasNext()) {
            ZHandle each = (ZHandle)i.next();
            if (!rect.intersects(each.getBoundsReference())) continue;
            aPath.setObject(each);
            return true;
        }
        aPath.pop(this);
        return super.pick(rect, aPath);
    }

    public void relocateHandles() {
        Iterator i = this.getHandles().iterator();
        while (i.hasNext()) {
            ((ZHandle)i.next()).computeBounds();
        }
        this.reshape();
    }

    public void refreshHandles() {
        this.clearHandles();
        Iterator i = this.editor().getNode().getHandles().iterator();
        while (i.hasNext()) {
            this.addHandle((ZHandle)i.next());
        }
        this.reshape();
    }

    protected void removeHandle(ZHandle aHandle) {
        this.getHandles().remove(aHandle);
        aHandle.setHandleGroup(null);
    }

    public void render(ZRenderContext aRenderContext) {
        super.render(aRenderContext);
        Iterator i = this.getHandles().iterator();
        while (i.hasNext()) {
            ZHandle each = (ZHandle)i.next();
            each.render(aRenderContext);
        }
    }

    public void processMouseEvent(ZMouseEvent e) {
        e.dispatchTo(this.getEventHandler().getFilteredEventDispatcher());
        super.processMouseEvent(e);
    }
}

