/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZGroup;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZVisualComponent;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import edu.umd.cs.jazz.io.ZSerializable;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZDebug;
import edu.umd.cs.jazz.util.ZRenderContext;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Serializable;

public class ZVisualGroup
extends ZGroup
implements ZSerializable,
Serializable {
    public static final boolean visualComponentPickable_DEFAULT = true;
    private ZVisualComponent frontVisualComponent = null;
    private ZVisualComponent backVisualComponent = null;
    private boolean frontVisualComponentPickable = true;
    private boolean backVisualComponentPickable = true;

    public ZVisualGroup() {
    }

    public ZVisualGroup(ZNode child) {
        super(child);
    }

    public ZVisualGroup(ZVisualComponent newFrontVisualComponent, ZVisualComponent newBackVisualComponent) {
        this.setFrontVisualComponent(newFrontVisualComponent);
        this.setBackVisualComponent(newBackVisualComponent);
    }

    public ZVisualGroup(ZNode child, ZVisualComponent newFrontVisualComponent, ZVisualComponent newBackVisualComponent) {
        super(child);
        this.setFrontVisualComponent(newFrontVisualComponent);
        this.setBackVisualComponent(newBackVisualComponent);
    }

    protected Object duplicateObject() {
        ZVisualGroup newGroup = (ZVisualGroup)super.duplicateObject();
        if (this.frontVisualComponent != null) {
            newGroup.frontVisualComponent = (ZVisualComponent)this.frontVisualComponent.clone();
        }
        if (this.backVisualComponent != null) {
            newGroup.backVisualComponent = (ZVisualComponent)this.backVisualComponent.clone();
        }
        return newGroup;
    }

    public void setFrontVisualComponent(ZVisualComponent newFrontVisualComponent) {
        if (this.frontVisualComponent != null) {
            this.repaint();
            this.frontVisualComponent.removeParent(this);
        }
        this.frontVisualComponent = newFrontVisualComponent;
        if (this.frontVisualComponent != null) {
            this.frontVisualComponent.addParent(this);
        }
        this.updateVolatility();
        this.reshape();
    }

    public final ZVisualComponent getFrontVisualComponent() {
        return this.frontVisualComponent;
    }

    public void setBackVisualComponent(ZVisualComponent newBackVisualComponent) {
        if (this.backVisualComponent != null) {
            this.repaint();
            this.backVisualComponent.removeParent(this);
        }
        this.backVisualComponent = newBackVisualComponent;
        if (this.backVisualComponent != null) {
            this.backVisualComponent.addParent(this);
        }
        this.updateVolatility();
        this.reshape();
    }

    public final ZVisualComponent getBackVisualComponent() {
        return this.backVisualComponent;
    }

    protected void computeVolatileBounds() {
        super.computeVolatileBounds();
        if (!this.childrenVolatileBoundsCache) {
            if (this.frontVisualComponent != null) {
                this.childrenVolatileBoundsCache = this.frontVisualComponent.getVolatileBounds();
            }
            if (!this.childrenVolatileBoundsCache && this.backVisualComponent != null) {
                this.childrenVolatileBoundsCache = this.backVisualComponent.getVolatileBounds();
            }
        }
    }

    public void setFrontVisualComponentPickable(boolean frontVisualComponentPickable) {
        this.frontVisualComponentPickable = frontVisualComponentPickable;
    }

    public final boolean isFrontVisualComponentPickable() {
        return this.frontVisualComponentPickable;
    }

    public void setBackVisualComponentPickable(boolean backVisualComponentPickable) {
        this.backVisualComponentPickable = backVisualComponentPickable;
    }

    public final boolean isBackVisualComponentPickable() {
        return this.backVisualComponentPickable;
    }

    public void render(ZRenderContext renderContext) {
        if (this.backVisualComponent != null) {
            this.backVisualComponent.render(renderContext);
        }
        super.render(renderContext);
        if (this.frontVisualComponent != null) {
            this.frontVisualComponent.render(renderContext);
        }
        if (this.frontVisualComponent != null) {
            ZDebug.incPaintCount();
        }
        if (this.backVisualComponent != null) {
            ZDebug.incPaintCount();
        }
        if (ZDebug.showBounds) {
            Graphics2D g2 = renderContext.getGraphics2D();
            g2.setColor(new Color(60, 60, 60));
            g2.setStroke(new BasicStroke((float)(1.0 / renderContext.getCompositeMagnification()), 0, 0));
            if (this.frontVisualComponent != null) {
                g2.draw(this.frontVisualComponent.getBoundsReference());
            }
            if (this.backVisualComponent != null) {
                g2.draw(this.backVisualComponent.getBoundsReference());
            }
        }
    }

    protected void computeBounds() {
        super.computeBounds();
        if (this.frontVisualComponent != null) {
            this.bounds.add(this.frontVisualComponent.getBoundsReference());
        }
        if (this.backVisualComponent != null) {
            this.bounds.add(this.backVisualComponent.getBoundsReference());
        }
    }

    protected void markInTransaction() {
        super.markInTransaction();
        if (this.frontVisualComponent != null) {
            this.frontVisualComponent.markInTransaction();
        }
        if (this.backVisualComponent != null) {
            this.backVisualComponent.markInTransaction();
        }
    }

    protected void markNotInTransaction() {
        super.markNotInTransaction();
        if (this.frontVisualComponent != null) {
            this.frontVisualComponent.markNotInTransaction();
        }
        if (this.backVisualComponent != null) {
            this.backVisualComponent.markNotInTransaction();
        }
    }

    public boolean pick(Rectangle2D rect, ZSceneGraphPath path) {
        if (this.isFrontVisualComponentPickable() && this.frontVisualComponent != null) {
            path.push(this);
            if (this.frontVisualComponent.pick(rect, path)) {
                if (!(this.frontVisualComponent instanceof ZCamera)) {
                    path.setObject(this.frontVisualComponent);
                }
                return true;
            }
            path.pop(this);
        }
        if (super.pick(rect, path)) {
            return true;
        }
        if (this.isBackVisualComponentPickable() && this.backVisualComponent != null) {
            path.push(this);
            if (this.backVisualComponent.pick(rect, path)) {
                if (!(this.backVisualComponent instanceof ZCamera)) {
                    path.setObject(this.backVisualComponent);
                }
                return true;
            }
            path.pop(this);
        }
        return false;
    }

    public ZBounds getFrontVisualComponentBounds() {
        ZBounds bounds = null;
        if (this.frontVisualComponent != null) {
            bounds = this.frontVisualComponent.getBounds();
        }
        return bounds;
    }

    public ZBounds getFrontVisualComponentGlobalBounds() {
        ZBounds globalBounds = null;
        if (this.frontVisualComponent != null) {
            globalBounds = this.frontVisualComponent.getBounds();
            AffineTransform at = this.getLocalToGlobalTransform();
            globalBounds.transform(at);
        }
        return globalBounds;
    }

    public ZBounds getBackVisualComponentBounds() {
        ZBounds bounds = null;
        if (this.backVisualComponent != null) {
            bounds = this.backVisualComponent.getBounds();
        }
        return bounds;
    }

    public ZBounds getBackVisualComponentGlobalBounds() {
        ZBounds globalBounds = null;
        if (this.backVisualComponent != null) {
            globalBounds = this.backVisualComponent.getBounds();
            AffineTransform at = this.getLocalToGlobalTransform();
            globalBounds.transform(at);
        }
        return globalBounds;
    }

    public ZBounds getShallowBounds() {
        ZBounds frontVisualComponentBounds;
        ZBounds result = super.getShallowBounds();
        ZBounds backVisualComponentBounds = this.getBackVisualComponentBounds();
        if (backVisualComponentBounds != null) {
            result.add(backVisualComponentBounds);
        }
        if ((frontVisualComponentBounds = this.getFrontVisualComponentBounds()) != null) {
            result.add(frontVisualComponentBounds);
        }
        return result;
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        super.writeObject(out);
        if (this.frontVisualComponent != null) {
            out.writeState("ZVisualComponent", "frontVisualComponent", this.frontVisualComponent);
        }
        if (!this.frontVisualComponentPickable) {
            out.writeState("boolean", "frontVisualComponentPickable", this.frontVisualComponentPickable);
        }
        if (this.backVisualComponent != null) {
            out.writeState("ZVisualComponent", "backVisualComponent", this.backVisualComponent);
        }
        if (!this.backVisualComponentPickable) {
            out.writeState("boolean", "backVisualComponentPickable", this.backVisualComponentPickable);
        }
    }

    public void writeObjectRecurse(ZObjectOutputStream out) throws IOException {
        super.writeObjectRecurse(out);
        if (this.frontVisualComponent != null) {
            out.addObject(this.frontVisualComponent);
        }
        if (this.backVisualComponent != null) {
            out.addObject(this.backVisualComponent);
        }
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        super.setState(fieldType, fieldName, fieldValue);
        if (fieldName.compareTo("frontVisualComponent") == 0) {
            this.setFrontVisualComponent((ZVisualComponent)fieldValue);
        } else if (fieldName.compareTo("frontVisualComponentPickable") == 0) {
            this.setFrontVisualComponentPickable((Boolean)fieldValue);
        } else if (fieldName.compareTo("backVisualComponent") == 0) {
            this.setBackVisualComponent((ZVisualComponent)fieldValue);
        } else if (fieldName.compareTo("backVisualComponentPickable") == 0) {
            this.setBackVisualComponentPickable((Boolean)fieldValue);
        }
    }

    static {
        visualComponentPickable_DEFAULT = true;
    }
}

