/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.animation;

import edu.umd.cs.jazz.animation.ZAlpha;
import edu.umd.cs.jazz.animation.ZAnimationScheduler;
import edu.umd.cs.jazz.animation.ZNextFrameCondition;
import edu.umd.cs.jazz.animation.ZNextFrameOnElapsedFrames;
import edu.umd.cs.jazz.animation.ZNextFrameOnElapsedTime;

public abstract class ZAnimation {
    private static final int ANIMATION_RATE_BY_NEXT_FRAME = 0;
    private static final int ANIMATION_RATE_BY_ELAPSED_TIME = 1;
    private static final int ANIMATION_RATE_BY_ELAPSED_FRAMES = 2;
    private ZAlpha fAlpha;
    private boolean isStopped = true;
    private boolean hasSeenFirstFrameOfPlaySequence = false;
    private int fAnimationRateMode = 0;
    private long fAnimationRateValue = 0L;

    public ZAnimation() {
    }

    public ZAnimation(ZAlpha aAlpha) {
    }

    public ZAlpha getAlpha() {
        return this.fAlpha;
    }

    public void setAlpha(ZAlpha aAlpha) {
        this.fAlpha = aAlpha;
    }

    public void play() {
        if (this.isStopped()) {
            this.isStopped = false;
            this.hasSeenFirstFrameOfPlaySequence = false;
            this.scheduleNextFrame();
        }
    }

    public void stop() {
        if (!this.isStopped()) {
            this.isStopped = true;
            this.animationStopped();
        }
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void animationRateByElapsedTime(long aElapsedTime) {
        this.fAnimationRateMode = 1;
        this.fAnimationRateValue = aElapsedTime;
    }

    public void animationRateByElapsedFrames(long aFramesCount) {
        this.fAnimationRateMode = 2;
        this.fAnimationRateValue = aFramesCount;
    }

    public void animationRateByNextFrame() {
        this.fAnimationRateMode = 0;
    }

    protected void animateFrameForTime(long aTime) {
        if (!this.hasSeenFirstFrameOfPlaySequence) {
            this.animationStarted();
            this.hasSeenFirstFrameOfPlaySequence = true;
        }
        if (this.getAlpha() != null && this.getAlpha().isFinished(aTime)) {
            this.stop();
            return;
        }
        this.scheduleNextFrame();
    }

    protected void animationStarted() {
    }

    protected void animationStopped() {
    }

    protected void scheduleNextFrame() {
        ZNextFrameCondition aCondition = null;
        switch (this.fAnimationRateMode) {
            case 0: {
                aCondition = new ZNextFrameOnElapsedTime(this.fAlpha, 0L);
                break;
            }
            case 1: {
                aCondition = new ZNextFrameOnElapsedTime(this.fAlpha, this.fAnimationRateValue);
                break;
            }
            case 2: {
                aCondition = new ZNextFrameOnElapsedFrames(this.fAlpha, this.fAnimationRateValue);
            }
        }
        this.scheduleNextFrame(aCondition);
    }

    protected void scheduleNextFrame(ZNextFrameCondition aCondition) {
        ZAnimationScheduler.instance().scheduleAnimation(this, aCondition);
    }

    static {
        ANIMATION_RATE_BY_NEXT_FRAME = 0;
        ANIMATION_RATE_BY_ELAPSED_TIME = 1;
        ANIMATION_RATE_BY_ELAPSED_FRAMES = 2;
    }
}

