/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.component;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import edu.umd.cs.jazz.ZVisualComponent;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import edu.umd.cs.jazz.util.ZRenderContext;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class ZImage
extends ZVisualComponent
implements Serializable {
    public static final boolean writeEmbeddedImage_DEFAULT = true;
    protected static final Frame staticFrame;
    protected int width;
    protected int height;
    protected transient Image image = null;
    protected ZImageObserver observer = new ZImageObserver();
    protected boolean writeEmbeddedImage = true;
    protected transient String fileName = null;
    protected URL url = null;
    private static JComponent sComponent;
    private static MediaTracker sTracker;
    private static AffineTransform identityTransform;
    private static int sID;
    protected double translateX = 0.0;
    protected double translateY = 0.0;

    public ZImage() {
        if (sComponent == null) {
            JWindow window = new JWindow();
            window.setBounds(0, 0, 1, 1);
            sComponent = new JPanel();
            sComponent.setBounds(0, 0, 1, 1);
            window.getContentPane().add(sComponent);
            window.setVisible(true);
            window.setVisible(false);
            sTracker = new MediaTracker(sComponent);
        }
    }

    public ZImage(Image i) {
        this();
        this.loadImage(i);
        this.setImage(i);
    }

    public ZImage(String aFileName) {
        this();
        this.setImage(aFileName);
    }

    public ZImage(URL aUrl) {
        this();
        this.url = aUrl;
        this.setImage(aUrl);
    }

    public ZImage(byte[] bytes) {
        this();
        this.setImage(bytes);
    }

    protected Object duplicateObject() {
        ZImage newImage = (ZImage)super.duplicateObject();
        newImage.observer = new ZImageObserver();
        return newImage;
    }

    public String getAbsolutePath(String path) {
        char ps = File.separatorChar;
        if (path.length() > 2 && path.substring(0, 3).equals(ps + "..")) {
            System.out.println("illegal path: " + path);
            return null;
        }
        int c = 0;
        while (c < path.length()) {
            if (path.length() > c + 5 && path.substring(c, c + 3).equals(".." + ps)) {
                int pps = path.lastIndexOf(ps, c - 2);
                path = this.getAbsolutePath(path.substring(0, pps + 1) + path.substring(c + 3));
                return path;
            }
            ++c;
        }
        return path;
    }

    public String getRelativePath(String fileName, String basePath) {
        if (fileName.charAt(1) == ':' && basePath.charAt(1) == ':' && fileName.charAt(0) != basePath.charAt(0)) {
            return fileName;
        }
        boolean ignoreCase = !File.separator.equals("/");
        char sc = File.separatorChar;
        while (fileName.indexOf(sc) != fileName.lastIndexOf(sc) && basePath.indexOf(sc) != basePath.lastIndexOf(sc)) {
            int subDir = basePath.indexOf(File.separator, 1);
            if (!basePath.regionMatches(ignoreCase, 0, fileName, 0, subDir)) break;
            basePath = basePath.substring(subDir);
            fileName = fileName.substring(subDir);
        }
        int sepCnt = 0;
        String upDirs1 = "";
        int i = 0;
        while (i < basePath.length()) {
            if (basePath.charAt(i) == sc && ++sepCnt != 1) {
                upDirs1 = upDirs1 + ".." + File.separator;
            }
            ++i;
        }
        if (fileName.length() > 1 && fileName.charAt(0) == sc) {
            fileName = fileName.substring(1);
        }
        return upDirs1 + fileName;
    }

    public void setTranslateX(double x) {
        this.setTranslation(x, this.translateY);
    }

    public double getTranslateX() {
        return this.translateX;
    }

    public void setTranslateY(double y) {
        this.setTranslation(this.translateX, y);
    }

    public double getTranslateY() {
        return this.translateY;
    }

    public void setTranslation(double x, double y) {
        this.translateX = x;
        this.translateY = y;
        this.reshape();
    }

    public void setTranslation(Point2D p) {
        this.setTranslation(p.getX(), p.getY());
    }

    public Point2D getTranslation() {
        Point2D.Double p = new Point2D.Double(this.translateX, this.translateY);
        return p;
    }

    public boolean setImage(Image im) {
        this.width = -1;
        this.height = -1;
        this.image = im;
        if (this.image == null) {
            this.setDimension(0, 0);
        } else {
            this.setDimension(this.getWidth(), this.getHeight());
            this.createOptimizedImage();
        }
        return this.isLoaded();
    }

    public boolean setImage(byte[] bytes) {
        Image im = Toolkit.getDefaultToolkit().createImage(bytes);
        this.loadImage(im);
        boolean success = this.setImage(im);
        im.flush();
        return success;
    }

    public boolean setImage(String aFileName) {
        this.fileName = aFileName;
        Image im = Toolkit.getDefaultToolkit().createImage(this.fileName);
        this.loadImage(im);
        boolean success = this.setImage(im);
        im.flush();
        return success;
    }

    public boolean setImage(URL aUrl) {
        this.url = aUrl;
        Image im = Toolkit.getDefaultToolkit().createImage(this.url);
        this.loadImage(im);
        boolean success = this.setImage(im);
        im.flush();
        return success;
    }

    protected void createOptimizedImage() {
        String version = System.getProperties().getProperty("java.version");
        if (version.substring(0, 3).equals("1.3")) {
            BufferedImage i = new BufferedImage(this.width, this.height, 2);
            ((Image)i).getGraphics().drawImage(this.image, 0, 0, sComponent);
            this.image = i;
        }
    }

    protected void loadImage(Image im) {
        MediaTracker tracker = new MediaTracker(staticFrame);
        tracker.addImage(im, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException exception) {
            System.out.println("Couldn't load image: " + this.fileName);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setFileName(String aFileName) {
        this.fileName = aFileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setUrl(URL aUrl) {
        this.url = aUrl;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setWriteEmbeddedImage(boolean value) {
        this.writeEmbeddedImage = value;
    }

    public boolean getWriteEmbeddedImage() {
        return this.writeEmbeddedImage;
    }

    protected void computeBounds() {
        this.bounds.setRect(this.translateX, this.translateY, this.getWidth(), this.getHeight());
    }

    public void render(ZRenderContext renderContext) {
        if (this.image != null) {
            Graphics2D g2 = renderContext.getGraphics2D();
            boolean translated = false;
            AffineTransform origat = null;
            if (this.translateX != 0.0 || this.translateY != 0.0) {
                origat = g2.getTransform();
                g2.translate(this.translateX, this.translateY);
                translated = true;
            }
            g2.drawImage(this.image, 0, 0, null);
            if (translated) {
                g2.setTransform(origat);
            }
        }
    }

    public int getWidth() {
        int w;
        if (this.width == -1 && this.image != null && (w = this.image.getWidth(this.observer)) != -1) {
            this.width = w;
        }
        return this.width;
    }

    public int getHeight() {
        int h;
        if (this.height == -1 && this.image != null && (h = this.image.getHeight(this.observer)) != -1) {
            this.height = h;
        }
        return this.height;
    }

    public boolean isLoaded() {
        boolean loaded = this.width != -1 && this.height != -1;
        return loaded;
    }

    protected void setLoaded(boolean l) {
        this.repaint();
    }

    void setDimension(int w, int h) {
        this.width = w;
        this.height = h;
        this.reshape();
    }

    public String dump() {
        String str = super.dump();
        if (this.fileName != null) {
            str = str + "\n FileName = '" + this.fileName + "'";
        }
        if (this.url != null) {
            str = str + "\n URL = '" + this.url + "'";
        }
        return str;
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        super.writeObject(out);
        if (this.fileName != null) {
            String cwd = System.getProperty("user.dir") + File.separator;
            String relFileName = this.getRelativePath(this.fileName, cwd);
            out.writeState("String", "fileName", relFileName);
        } else if (this.url != null) {
            out.writeState("URL", "url", this.url);
        }
        if (!this.writeEmbeddedImage) {
            out.writeState("boolean", "writeEmbeddedImage", this.writeEmbeddedImage);
        }
        if (this.image != null && this.writeEmbeddedImage) {
            out.writeState("BINARYDATAFOLLOWS", "image", this.image);
        }
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        super.setState(fieldType, fieldName, fieldValue);
        if (fieldName.compareTo("image") == 0) {
            byte[] data = (byte[])fieldValue;
            this.setImage(data);
        } else if (fieldName.compareTo("fileName") == 0) {
            String fn = (String)fieldValue;
            if (fn.length() > 3 && fn.substring(0, 4).equals("jar:")) {
                String jarFileName = fn.substring(4, fn.indexOf(47));
                String entryName = fn.substring(fn.indexOf(47) + 1);
                String resourceFileName = "resources/" + jarFileName;
                URL resourceURL = this.getClass().getClassLoader().getResource(resourceFileName);
                if (resourceURL == null) {
                    System.out.println("ZImage resource " + resourceFileName + " not found.");
                    return;
                }
                String jarResourceName = resourceURL.toString();
                if (jarResourceName.length() > 3 && !jarResourceName.substring(0, 4).equals("jar:")) {
                    jarResourceName = "jar:" + jarResourceName + "!/";
                }
                jarResourceName = jarResourceName + entryName;
                System.out.println("jarResourceName: " + jarResourceName);
                URL jarResourceURL = null;
                try {
                    jarResourceURL = new URL(jarResourceName);
                }
                catch (MalformedURLException e) {
                    System.out.println("MalformedURLException: " + jarResourceName);
                    return;
                }
                this.setImage(jarResourceURL);
            } else {
                fn = File.separator.equals("/") ? fn.replace('\\', '/') : fn.replace('/', '\\');
                if (fn.charAt(1) != ':') {
                    String cwd = System.getProperty("user.dir");
                    this.fileName = this.getAbsolutePath(cwd + File.separator + fn);
                } else {
                    this.fileName = fn;
                }
                this.setImage(this.fileName);
            }
        } else if (fieldName.compareTo("url") == 0) {
            this.setImage((URL)fieldValue);
        } else if (fieldName.compareTo("writeEmbeddedImage") == 0) {
            this.writeEmbeddedImage = (Boolean)fieldValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForImage(Image image) {
        int id;
        JComponent jComponent = sComponent;
        synchronized (jComponent) {
            id = sID++;
        }
        sTracker.addImage(image, id);
        try {
            sTracker.waitForID(id);
        }
        catch (InterruptedException ie) {
            return false;
        }
        return !sTracker.isErrorID(id);
    }

    public static BufferedImage makeBufferedImage(Image image) {
        if (!ZImage.waitForImage(image)) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g2 = (Graphics2D)bufferedImage.getGraphics();
        g2.drawImage(image, null, null);
        return bufferedImage;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.fileName == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            String cwd = System.getProperty("user.dir") + File.separator;
            String relFileName = this.getRelativePath(this.fileName, cwd);
            out.writeObject(relFileName);
            if (this.writeEmbeddedImage) {
                out.writeBoolean(true);
                JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
                encoder.encode(ZImage.makeBufferedImage(this.image));
            } else {
                out.writeBoolean(false);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (in.readBoolean()) {
            this.fileName = (String)in.readObject();
            if (in.readBoolean()) {
                JPEGImageDecoder decoder = JPEGCodec.createJPEGDecoder((InputStream)in);
                this.image = decoder.decodeAsBufferedImage();
                BufferedImage bi = new BufferedImage(this.width, this.height, 2);
                bi.getGraphics().drawImage(this.image, 0, 0, sComponent);
                this.image.flush();
                this.image = bi;
            } else {
                this.fileName = File.separator.equals("/") ? this.fileName.replace('\\', '/') : this.fileName.replace('/', '\\');
                if (this.fileName.charAt(1) != ':') {
                    String cwd = System.getProperty("user.dir");
                    this.fileName = this.getAbsolutePath(cwd + File.separator + this.fileName);
                }
                this.image = Toolkit.getDefaultToolkit().createImage(this.fileName);
                MediaTracker tracker = new MediaTracker(staticFrame);
                tracker.addImage(this.image, 0);
                try {
                    tracker.waitForID(0);
                }
                catch (InterruptedException exception) {
                    System.out.println("Couldn't load image: " + this.fileName);
                }
                if (!(this.image instanceof BufferedImage) || ((BufferedImage)this.image).getType() != 2) {
                    BufferedImage bi = new BufferedImage(this.width, this.height, 2);
                    bi.getGraphics().drawImage(this.image, 0, 0, sComponent);
                    this.image.flush();
                    this.image = bi;
                }
            }
            this.width = this.getWidth();
            this.height = this.getHeight();
        }
    }

    static {
        writeEmbeddedImage_DEFAULT = true;
        staticFrame = new Frame();
        staticFrame.addNotify();
        sComponent = null;
        sTracker = null;
        identityTransform = new AffineTransform();
        sID = 0;
    }

    class ZImageObserver
    implements ImageObserver,
    Serializable {
        ZImageObserver() {
        }

        public boolean imageUpdate(Image i, int infoflags, int x, int y, int width, int height) {
            if ((infoflags & 1) != 0 || (infoflags & 2) != 0) {
                ZImage.this.setDimension(width, height);
                ZImage.this.setLoaded(true);
            }
            return false;
        }
    }
}

