/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.event;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZHandle;
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.event.ZDragSequenceEventHandler;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.event.ZMouseFilter;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;

public class ZHandleEventHandler
extends ZDragSequenceEventHandler {
    private ZHandle fCurrentHandle;
    private ZHandle fCurrentHighlightedHandle;

    public ZHandleEventHandler(ZSceneGraphObject aEventSource) {
        super(aEventSource);
    }

    public ZHandle getCurrentHandle() {
        return this.fCurrentHandle;
    }

    public ZHandle getCurrentHighlightedHandle() {
        return this.fCurrentHighlightedHandle;
    }

    public ZMouseFilter getMouseFilter() {
        if (this.fMouseFilter == null) {
            this.fMouseFilter = new ZMouseFilter(16);
        }
        return this.fMouseFilter;
    }

    public void filteredMouseEntered(ZMouseEvent e) {
        ZCamera aCamera = e.getPath().getCamera();
        ZSceneGraphPath aPath = e.getPath();
        if (aPath.getObject() instanceof ZHandle) {
            this.fCurrentHighlightedHandle = (ZHandle)aPath.getObject();
            this.fCurrentHighlightedHandle.setIsHighlighted(true);
        }
    }

    public void filteredMouseExited(ZMouseEvent e) {
        if (this.fCurrentHighlightedHandle != null) {
            this.fCurrentHighlightedHandle.setIsHighlighted(false);
            this.fCurrentHighlightedHandle = null;
        }
    }

    protected void startDrag(ZMouseEvent e) {
        super.startDrag(e);
        this.fCurrentHandle = (ZHandle)e.getPath().getObject();
        Point2D localPoint = e.getLocalPoint();
        this.fCurrentHandle.handleStartDrag(localPoint.getX(), localPoint.getY());
        this.fCurrentHandle.handleStartDrag(localPoint.getX(), localPoint.getY(), e);
        e.consume();
    }

    protected void dragInScreenCoords(ZMouseEvent e, Dimension2D aScreenDelta) {
        e.getPath().screenToLocal(aScreenDelta);
        this.fCurrentHandle.handleDragged(aScreenDelta.getWidth(), aScreenDelta.getHeight());
        this.fCurrentHandle.handleDragged(aScreenDelta.getWidth(), aScreenDelta.getHeight(), e);
        e.consume();
    }

    protected void endDrag(ZMouseEvent e) {
        super.endDrag(e);
        Point2D localPoint = e.getLocalPoint();
        this.fCurrentHandle.handleEndDrag(localPoint.getX(), localPoint.getY());
        this.fCurrentHandle.handleEndDrag(localPoint.getX(), localPoint.getY(), e);
        this.fCurrentHandle = null;
        e.consume();
    }

    protected boolean shouldStartDragInteraction(ZMouseEvent e) {
        return e.getPath().getObject() instanceof ZHandle;
    }
}

