/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.event;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZSelectionGroup;
import edu.umd.cs.jazz.ZSelectionManager;
import edu.umd.cs.jazz.ZTransformGroup;
import edu.umd.cs.jazz.ZVisualComponent;
import edu.umd.cs.jazz.event.ZEventHandler;
import edu.umd.cs.jazz.event.ZGroupEvent;
import edu.umd.cs.jazz.event.ZGroupListener;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.event.ZMouseListener;
import edu.umd.cs.jazz.event.ZMouseMotionListener;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZNodeNotFoundException;
import edu.umd.cs.jazz.util.ZRenderContext;
import edu.umd.cs.jazz.util.ZSceneGraphEditor;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import javax.swing.event.EventListenerList;

public class ZSelectionResizeHandler
implements ZEventHandler,
ZGroupListener,
Serializable {
    private static final Color DEFAULT_HIGHLIGHT_COLOR = Color.red.darker();
    protected static double RESIZE_HANDLE_SIZE = 6.0;
    private boolean active = false;
    private boolean globallyActive = false;
    private ZNode node = null;
    private ZCamera activeCamera = null;
    private ZCamera interactionCamera = null;
    private Color highLightColor = DEFAULT_HIGHLIGHT_COLOR;
    protected transient HashMap activeHandles;
    protected transient EventListenerList listenerList;
    private ResizeListener defaultResizeListener;
    private int allButton1ButShiftMask = 50;
    static /* synthetic */ Class class$edu$umd$cs$jazz$event$ZSelectionResizeHandler$ResizeListener;

    public ZSelectionResizeHandler(ZNode node) {
        this.node = node;
        this.globallyActive = true;
        this.init();
    }

    public ZSelectionResizeHandler(ZNode node, ZCamera camera) {
        this.node = node;
        this.activeCamera = camera;
        this.init();
    }

    public void addResizeListener(ResizeListener l) {
        this.listenerList.add(class$edu$umd$cs$jazz$event$ZSelectionResizeHandler$ResizeListener == null ? (class$edu$umd$cs$jazz$event$ZSelectionResizeHandler$ResizeListener = ZSelectionResizeHandler.class$("edu.umd.cs.jazz.event.ZSelectionResizeHandler$ResizeListener")) : class$edu$umd$cs$jazz$event$ZSelectionResizeHandler$ResizeListener, l);
    }

    public void removeResizeListener(ResizeListener l) {
        this.listenerList.remove(class$edu$umd$cs$jazz$event$ZSelectionResizeHandler$ResizeListener == null ? (class$edu$umd$cs$jazz$event$ZSelectionResizeHandler$ResizeListener = ZSelectionResizeHandler.class$("edu.umd.cs.jazz.event.ZSelectionResizeHandler$ResizeListener")) : class$edu$umd$cs$jazz$event$ZSelectionResizeHandler$ResizeListener, l);
    }

    protected ResizeListener createResizeListener() {
        return new ResizeListener(){

            public void nodeResized(ResizeEvent re) {
                if (re.getMouseEvent().isShiftDown()) {
                    ZSelectionResizeHandler.this.scale(re.getNode().editor().getTransformGroup(), re.getConstrainScaleX(), re.getConstrainScaleY(), re.getX(), re.getY());
                } else {
                    ZSelectionResizeHandler.this.scale(re.getNode().editor().getTransformGroup(), re.getScaleX(), re.getScaleY(), re.getX(), re.getY());
                }
            }

            public void resizeComplete() {
            }
        };
    }

    protected ResizeHandles createResizeHandles() {
        return new ResizeHandles();
    }

    protected void fireResizeEvent(ResizeEvent re) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$edu$umd$cs$jazz$event$ZSelectionResizeHandler$ResizeListener == null ? ZSelectionResizeHandler.class$("edu.umd.cs.jazz.event.ZSelectionResizeHandler$ResizeListener") : class$edu$umd$cs$jazz$event$ZSelectionResizeHandler$ResizeListener)) {
                if (re == null) {
                    ((ResizeListener)listeners[i + 1]).resizeComplete();
                } else {
                    ((ResizeListener)listeners[i + 1]).nodeResized(re);
                }
            }
            i -= 2;
        }
    }

    public Color getHighLightColor() {
        return this.highLightColor;
    }

    protected void init() {
        this.listenerList = new EventListenerList();
        this.defaultResizeListener = this.createResizeListener();
        this.addResizeListener(this.defaultResizeListener);
        this.activeHandles = new HashMap();
    }

    public boolean isActive() {
        return this.active;
    }

    public void nodeAdded(ZGroupEvent e) {
        ZNode node = e.getChild();
        ZSceneGraphEditor editor = node.editor();
        ResizeHandles rh = this.createResizeHandles();
        editor.getNode().addMouseListener(rh);
        editor.getNode().addMouseMotionListener(rh);
        editor.getSelectionGroup().addAuxiliaryVisualComponent(rh);
        this.activeHandles.put(node, rh);
    }

    public void nodeRemoved(ZGroupEvent e) {
        ZNode node = e.getChild();
        ZSceneGraphEditor editor = node.editor();
        ResizeHandles handles = (ResizeHandles)this.activeHandles.get(node);
        if (handles != null) {
            editor.getNode().removeMouseListener(handles);
            editor.getNode().removeMouseMotionListener(handles);
            editor.getSelectionGroup().removeAuxiliaryVisualComponent(handles);
        }
        this.activeHandles.remove(node);
    }

    protected void scale(ZTransformGroup zTransform, double dxz, double dyz, double x, double y) {
        AffineTransform transform = zTransform.getTransform();
        transform.translate(x, y);
        transform.scale(dxz, dyz);
        transform.translate(-x, -y);
        zTransform.setTransform(transform);
    }

    public void setActive(boolean active) {
        if (this.active && !active) {
            this.active = false;
            if (this.globallyActive) {
                ZSelectionManager.removeGroupListener(this);
            } else {
                ZSelectionManager.removeGroupListener(this, this.activeCamera);
            }
        } else if (!this.active && active) {
            this.active = true;
            if (this.globallyActive) {
                ZSelectionManager.addGroupListener(this);
            } else {
                ZSelectionManager.addGroupListener(this, this.activeCamera);
            }
        }
    }

    public void setDefaultResizeListenerActive(boolean active) {
        if (active && this.defaultResizeListener == null) {
            this.defaultResizeListener = this.createResizeListener();
            this.addResizeListener(this.defaultResizeListener);
        } else if (!active && this.defaultResizeListener != null) {
            this.removeResizeListener(this.defaultResizeListener);
            this.defaultResizeListener = null;
        }
    }

    public void setHighLightColor(Color color) {
        this.highLightColor = color;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class ResizeHandles
    extends ZVisualComponent
    implements ZMouseListener,
    ZMouseMotionListener {
        public final Color penColor_DEFAULT;
        protected Color penColor;
        protected Rectangle2D[] handles;
        protected Point2D pressPt;
        protected ZNode pressNode;
        protected Point pressHandle;
        protected Point highLightHandle;
        protected Point2D dragPt;
        protected ArrayList selection;
        private boolean rendered;
        private double pressWidth;
        private double pressHeight;
        private double pressScaleX;
        private double pressScaleY;
        private double prevScaleX;
        private double prevScaleY;
        private double prevConstrainScaleX;
        private double prevConstrainScaleY;
        private double prevNoFlipScaleX;
        private double prevNoFlipScaleY;
        private double prevNoFlipConstrainScaleX;
        private double prevNoFlipConstrainScaleY;
        private ArrayList selectedInverseX;
        private ArrayList selectedInverseY;
        private boolean dragging;
        private Point2D tmpPoint;

        public ResizeHandles() {
            this.penColor = this.penColor_DEFAULT = ZSelectionGroup.penColor_DEFAULT;
            this.handles = null;
            this.pressNode = null;
            this.selection = null;
            this.rendered = false;
            this.selectedInverseX = new ArrayList();
            this.selectedInverseY = new ArrayList();
            this.dragging = false;
            this.tmpPoint = new Point2D.Double();
            this.handles = new Rectangle2D[9];
            this.pressPt = new Point2D.Double();
            this.dragPt = new Point2D.Double();
        }

        private final int mapIndex(int i, int j) {
            return (j + 1) * 3 + (i + 1);
        }

        private final Point unMapIndex(int index) {
            Point cp = new Point(index % 3 - 1, index / 3 - 1);
            return cp;
        }

        public boolean pick(Rectangle2D pickRect, ZSceneGraphPath path) {
            return this.contains(pickRect);
        }

        protected Rectangle2D getHandle(double cx, double cy, double xLen, double yLen) {
            Rectangle2D.Double r = new Rectangle2D.Double(cx - xLen / 2.0, cy - yLen / 2.0, xLen, yLen);
            return r;
        }

        public void render(ZRenderContext ctx) {
            Graphics2D g2 = ctx.getGraphics2D();
            AffineTransform transform = g2.getTransform();
            double xScale = Math.abs(transform.getScaleX());
            double yScale = Math.abs(transform.getScaleY());
            double xSz = 1.0 / xScale;
            double ySz = 1.0 / yScale;
            double xLen = RESIZE_HANDLE_SIZE * xSz;
            double yLen = RESIZE_HANDLE_SIZE * ySz;
            ZNode p = this.getParents()[0];
            if (p instanceof ZSelectionGroup) {
                ZSelectionGroup g = (ZSelectionGroup)p;
                ZBounds r = g.getBounds();
                double x = ((RectangularShape)r).getX();
                double y = ((RectangularShape)r).getY();
                double w = ((RectangularShape)r).getWidth();
                double h = ((RectangularShape)r).getHeight();
                if (w < 3.0 * xLen || h < 3.0 * yLen) {
                    this.rendered = false;
                    return;
                }
                double cx = x + w / 2.0;
                double cy = y + h / 2.0;
                w -= xLen + 2.0 * xSz;
                h -= yLen + 2.0 * ySz;
                g2.setColor(this.penColor);
                int i = -1;
                while (i < 2) {
                    int j = -1;
                    while (j < 2) {
                        if (i != 0 || j != 0) {
                            Rectangle2D handle = this.getHandle(cx + (double)i * (w / 2.0), cy + (double)j * (h / 2.0), xLen, yLen);
                            if (this.highLightHandle != null && (int)this.highLightHandle.getX() == i && (int)this.highLightHandle.getY() == j) {
                                g2.setColor(ZSelectionResizeHandler.this.highLightColor);
                                this.handles[this.mapIndex((int)i, (int)j)] = handle;
                                g2.fill(handle);
                                g2.setColor(this.penColor);
                            } else {
                                this.handles[this.mapIndex((int)i, (int)j)] = handle;
                                g2.fill(handle);
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
                this.rendered = true;
            }
        }

        protected void computeBounds() {
        }

        public Point contains(double x, double y) {
            if (!this.rendered) {
                return null;
            }
            int i = 0;
            while (i < 9) {
                Rectangle2D r = this.handles[i];
                if (r != null && r.contains(x, y)) {
                    return this.unMapIndex(i);
                }
                ++i;
            }
            return null;
        }

        public boolean contains(Rectangle2D rect) {
            if (!this.rendered) {
                return false;
            }
            int i = 0;
            while (i < 9) {
                Rectangle2D r = this.handles[i];
                if (r != null && r.contains(rect.getX() + rect.getWidth() / 2.0, rect.getY() + rect.getHeight() / 2.0)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private void scaleSelection(ZBounds bounds, Point2D oldPt, Point2D newPt, ZMouseEvent mouseEvent) {
            double noFlipScaleY;
            double scaleY;
            double noFlipScaleX;
            double scaleX;
            double newNoFlipHeight;
            double newHeight;
            double newNoFlipWidth;
            double newWidth;
            double noFlipBaseY;
            double baseY;
            double noFlipBaseX;
            double baseX;
            Point2D.Double scalePoint = new Point2D.Double();
            if (this.pressHandle.getX() >= 0.0) {
                baseX = this.prevScaleX >= 0.0 ? bounds.getX() : bounds.getX() + bounds.getWidth();
                noFlipBaseX = bounds.getX();
            } else {
                baseX = this.prevScaleX >= 0.0 ? bounds.getX() + bounds.getWidth() : bounds.getX();
                noFlipBaseX = bounds.getX() + bounds.getWidth();
            }
            if (this.pressHandle.getY() >= 0.0) {
                baseY = this.prevScaleY >= 0.0 ? bounds.getY() : bounds.getY() + bounds.getHeight();
                noFlipBaseY = bounds.getY();
            } else {
                baseY = this.prevScaleY >= 0.0 ? bounds.getY() + bounds.getHeight() : bounds.getY();
                noFlipBaseY = bounds.getY() + bounds.getHeight();
            }
            double oldWidth = Math.abs(oldPt.getX() - baseX);
            double oldHeight = Math.abs(oldPt.getY() - baseY);
            double oldNoFlipWidth = Math.abs(oldPt.getX() - noFlipBaseX);
            double oldNoFlipHeight = Math.abs(oldPt.getY() - noFlipBaseY);
            double offX = this.pressWidth - oldWidth;
            double offY = this.pressHeight - oldHeight;
            double noFlipOffX = this.pressWidth - oldNoFlipWidth;
            double noFlipOffY = this.pressHeight - oldNoFlipHeight;
            if (this.pressHandle.getX() >= 0.0) {
                newWidth = newPt.getX() - baseX;
                newNoFlipWidth = newPt.getX() - noFlipBaseX;
            } else {
                newWidth = baseX - newPt.getX();
                newNoFlipWidth = noFlipBaseX - newPt.getX();
            }
            if (this.pressHandle.getY() >= 0.0) {
                newHeight = newPt.getY() - baseY;
                newNoFlipHeight = newPt.getY() - noFlipBaseY;
            } else {
                newHeight = baseY - newPt.getY();
                newNoFlipHeight = noFlipBaseY - newPt.getY();
            }
            newWidth = newWidth > 0.0 ? (newWidth += offX) : (newWidth -= offX);
            newNoFlipWidth = newNoFlipWidth > 0.0 ? (newNoFlipWidth += noFlipOffX) : (newNoFlipWidth -= noFlipOffX);
            newHeight = newHeight > 0.0 ? (newHeight += offY) : (newHeight -= offY);
            newNoFlipHeight = newNoFlipHeight > 0.0 ? (newNoFlipHeight += noFlipOffY) : (newNoFlipHeight -= noFlipOffY);
            if (this.pressHandle.getX() != 0.0) {
                scaleX = oldWidth == 0.0 || newWidth == 0.0 ? 1.0 : newWidth / this.pressWidth;
                noFlipScaleX = oldNoFlipWidth == 0.0 || newNoFlipWidth == 0.0 ? 1.0 : newNoFlipWidth / this.pressWidth;
            } else {
                scaleX = 1.0;
                noFlipScaleX = 1.0;
            }
            if (this.pressHandle.getY() != 0.0) {
                scaleY = oldHeight == 0.0 || newHeight == 0.0 ? 1.0 : newHeight / this.pressHeight;
                noFlipScaleY = oldNoFlipHeight == 0.0 || newNoFlipHeight == 0.0 ? 1.0 : newNoFlipHeight / this.pressHeight;
            } else {
                scaleY = 1.0;
                noFlipScaleY = 1.0;
            }
            double xSign = scaleX * Math.abs(scaleX) / Math.pow(scaleX, 2.0);
            double ySign = scaleY * Math.abs(scaleY) / Math.pow(scaleY, 2.0);
            double scale = 1.0;
            double noFlipXSign = noFlipScaleX * Math.abs(noFlipScaleX) / Math.pow(noFlipScaleX, 2.0);
            double noFlipYSign = noFlipScaleY * Math.abs(noFlipScaleY) / Math.pow(noFlipScaleY, 2.0);
            double noFlipScale = 1.0;
            if (this.pressHandle.getX() != 0.0 && this.pressHandle.getY() != 0.0) {
                scale = Math.max(Math.abs(scaleX), Math.abs(scaleY));
                noFlipScale = Math.max(Math.abs(noFlipScaleX), Math.abs(noFlipScaleY));
            } else if (this.pressHandle.getX() == 0.0) {
                scale = Math.abs(scaleY);
                noFlipScale = Math.abs(noFlipScaleY);
            } else if (this.pressHandle.getY() == 0.0) {
                scale = Math.abs(scaleX);
                noFlipScale = Math.abs(noFlipScaleX);
            }
            int i = 0;
            while (i < this.selection.size()) {
                ZNode selNode = (ZNode)this.selection.get(i);
                bounds = selNode.getBounds();
                boolean inverseX = (Boolean)this.selectedInverseX.get(i);
                boolean inverseY = (Boolean)this.selectedInverseY.get(i);
                if (inverseX) {
                    if (this.pressHandle.getX() > 0.0) {
                        ((Point2D)scalePoint).setLocation(bounds.getX() + bounds.getWidth(), bounds.getY() + bounds.getHeight());
                    } else if (this.pressHandle.getX() == 0.0) {
                        ((Point2D)scalePoint).setLocation(bounds.getX() + bounds.getWidth() / 2.0, ((Point2D)scalePoint).getY());
                    } else {
                        ((Point2D)scalePoint).setLocation(bounds.getX(), ((Point2D)scalePoint).getY());
                    }
                } else if (this.pressHandle.getX() > 0.0) {
                    ((Point2D)scalePoint).setLocation(bounds.getX(), ((Point2D)scalePoint).getY());
                } else if (this.pressHandle.getX() == 0.0) {
                    ((Point2D)scalePoint).setLocation(bounds.getX() + bounds.getWidth() / 2.0, ((Point2D)scalePoint).getY());
                } else {
                    ((Point2D)scalePoint).setLocation(bounds.getX() + bounds.getWidth(), bounds.getY() + bounds.getHeight());
                }
                if (inverseY) {
                    if (this.pressHandle.getY() > 0.0) {
                        ((Point2D)scalePoint).setLocation(((Point2D)scalePoint).getX(), bounds.getY() + bounds.getHeight());
                    } else if (this.pressHandle.getY() == 0.0) {
                        ((Point2D)scalePoint).setLocation(((Point2D)scalePoint).getX(), bounds.getY() + bounds.getHeight() / 2.0);
                    } else {
                        ((Point2D)scalePoint).setLocation(((Point2D)scalePoint).getX(), bounds.getY());
                    }
                } else if (this.pressHandle.getY() > 0.0) {
                    ((Point2D)scalePoint).setLocation(((Point2D)scalePoint).getX(), bounds.getY());
                } else if (this.pressHandle.getY() == 0.0) {
                    ((Point2D)scalePoint).setLocation(((Point2D)scalePoint).getX(), bounds.getY() + bounds.getHeight() / 2.0);
                } else {
                    ((Point2D)scalePoint).setLocation(((Point2D)scalePoint).getX(), bounds.getY() + bounds.getHeight());
                }
                ResizeEvent re = new ResizeEvent(selNode, mouseEvent, xSign * Math.abs(scaleX) / this.prevScaleX, ySign * Math.abs(scaleY) / this.prevScaleY, xSign * scale / this.prevConstrainScaleX, ySign * scale / this.prevConstrainScaleY, noFlipXSign * Math.abs(noFlipScaleX) / this.prevNoFlipScaleX, noFlipYSign * Math.abs(noFlipScaleY) / this.prevNoFlipScaleY, noFlipXSign * noFlipScale / this.prevNoFlipConstrainScaleX, noFlipYSign * noFlipScale / this.prevNoFlipConstrainScaleY, ((Point2D)scalePoint).getX(), ((Point2D)scalePoint).getY());
                ZSelectionResizeHandler.this.fireResizeEvent(re);
                ++i;
            }
            this.prevScaleX = scaleX;
            this.prevScaleY = scaleY;
            this.prevConstrainScaleX = xSign * scale;
            this.prevConstrainScaleY = ySign * scale;
            this.prevNoFlipScaleX = noFlipScaleX;
            this.prevNoFlipScaleY = noFlipScaleY;
            this.prevNoFlipConstrainScaleX = noFlipXSign * noFlipScale;
            this.prevNoFlipConstrainScaleY = noFlipYSign * noFlipScale;
        }

        public void mousePressed(ZMouseEvent e) {
            if ((e.getModifiers() & ZSelectionResizeHandler.this.allButton1ButShiftMask) == 16) {
                ZSceneGraphPath path = e.getPath();
                if (ZSelectionResizeHandler.this.globallyActive) {
                    ZSelectionResizeHandler.this.interactionCamera = path.getCamera();
                } else {
                    ZSelectionResizeHandler.this.interactionCamera = ZSelectionResizeHandler.this.activeCamera;
                }
                Point2D.Double testPt = new Point2D.Double(e.getX(), e.getY());
                try {
                    path.screenToCamera(testPt, ZSelectionResizeHandler.this.interactionCamera);
                    ZSelectionResizeHandler.this.interactionCamera.cameraToLocal(testPt, path.getNode());
                }
                catch (ZNodeNotFoundException znnfe) {
                    return;
                }
                this.pressPt.setLocation(e.getX(), e.getY());
                path.screenToCamera(this.pressPt, ZSelectionResizeHandler.this.interactionCamera);
                ZSelectionResizeHandler.this.interactionCamera.cameraToLocal(this.pressPt, null);
                this.pressHandle = this.contains(((Point2D)testPt).getX(), ((Point2D)testPt).getY());
                if (this.pressHandle != null) {
                    e.consume();
                    this.pressNode = path.getNode();
                    ZBounds pressBounds = this.pressNode.getGlobalBounds();
                    this.pressWidth = pressBounds.getWidth();
                    this.pressHeight = pressBounds.getHeight();
                    AffineTransform globalToLocal = this.pressNode.getGlobalToLocalTransform();
                    if (globalToLocal.getScaleX() < 0.0) {
                        this.pressHandle.setLocation(-this.pressHandle.getX(), this.pressHandle.getY());
                    }
                    if (globalToLocal.getScaleY() < 0.0) {
                        this.pressHandle.setLocation(this.pressHandle.getX(), -this.pressHandle.getY());
                    }
                    this.selection = ZSelectionManager.getSelectedNodes(ZSelectionResizeHandler.this.interactionCamera);
                    this.selectedInverseX.clear();
                    this.selectedInverseY.clear();
                    int i = 0;
                    while (i < this.selection.size()) {
                        ZNode selNode = (ZNode)this.selection.get(i);
                        globalToLocal = selNode.getGlobalToLocalTransform();
                        if (globalToLocal.getScaleX() < 0.0) {
                            this.selectedInverseX.add(new Boolean(true));
                        } else {
                            this.selectedInverseX.add(new Boolean(false));
                        }
                        if (globalToLocal.getScaleY() < 0.0) {
                            this.selectedInverseY.add(new Boolean(true));
                        } else {
                            this.selectedInverseY.add(new Boolean(false));
                        }
                        ++i;
                    }
                    this.prevScaleX = 1.0;
                    this.prevScaleY = 1.0;
                    this.prevConstrainScaleX = 1.0;
                    this.prevConstrainScaleY = 1.0;
                    this.prevNoFlipScaleX = 1.0;
                    this.prevNoFlipScaleY = 1.0;
                    this.prevNoFlipConstrainScaleX = 1.0;
                    this.prevNoFlipConstrainScaleY = 1.0;
                    this.dragging = true;
                }
            }
        }

        public void mouseDragged(ZMouseEvent e) {
            if ((e.getModifiers() & ZSelectionResizeHandler.this.allButton1ButShiftMask) == 16 && this.dragging && ZSelectionResizeHandler.this.interactionCamera != null) {
                ZSceneGraphPath path = e.getPath();
                this.dragPt.setLocation(e.getX(), e.getY());
                path.screenToCamera(this.dragPt, ZSelectionResizeHandler.this.interactionCamera);
                ZSelectionResizeHandler.this.interactionCamera.cameraToLocal(this.dragPt, null);
                this.scaleSelection(this.pressNode.getGlobalBounds(), this.pressPt, this.dragPt, e);
                e.consume();
            }
        }

        public void mouseReleased(ZMouseEvent e) {
            this.dragging = false;
            if ((e.getModifiers() & ZSelectionResizeHandler.this.allButton1ButShiftMask) == 16) {
                this.mouseMoved(e);
                ZSelectionResizeHandler.this.fireResizeEvent(null);
            }
        }

        public void mouseEntered(ZMouseEvent e) {
        }

        public void mouseExited(ZMouseEvent e) {
            if (this.highLightHandle != null && !this.dragging) {
                this.highLightHandle = null;
                this.repaint();
            }
        }

        public void mouseClicked(ZMouseEvent e) {
        }

        public void mouseMoved(ZMouseEvent e) {
            ZSceneGraphPath path = e.getPath();
            ZCamera camera = ZSelectionResizeHandler.this.globallyActive ? path.getCamera() : ZSelectionResizeHandler.this.activeCamera;
            Point2D.Double testPt = new Point2D.Double(e.getX(), e.getY());
            try {
                path.screenToCamera(testPt, camera);
                camera.cameraToLocal(testPt, path.getNode());
            }
            catch (ZNodeNotFoundException znnfe) {
                return;
            }
            Point newHighLightHandle = this.contains(((Point2D)testPt).getX(), ((Point2D)testPt).getY());
            if (this.highLightHandle == null && newHighLightHandle != null || this.highLightHandle != null && newHighLightHandle == null) {
                this.highLightHandle = newHighLightHandle;
                this.repaint();
            } else if (this.highLightHandle != null && newHighLightHandle != null && (this.highLightHandle.getX() != newHighLightHandle.getX() || this.highLightHandle.getY() != newHighLightHandle.getY())) {
                this.highLightHandle = newHighLightHandle;
                this.repaint();
            }
        }
    }

    public static class ResizeEvent {
        ZNode node;
        ZMouseEvent mouseEvent;
        double xScale;
        double yScale;
        double constrainXScale;
        double constrainYScale;
        double noFlipXScale;
        double noFlipYScale;
        double constrainNoFlipXScale;
        double constrainNoFlipYScale;
        double x;
        double y;

        public ResizeEvent(ZNode node, ZMouseEvent mouseEvent, double xScale, double yScale, double constrainXScale, double constrainYScale, double noFlipXScale, double noFlipYScale, double constrainNoFlipXScale, double constrainNoFlipYScale, double x, double y) {
            this.node = node;
            this.mouseEvent = mouseEvent;
            this.xScale = xScale;
            this.yScale = yScale;
            this.constrainXScale = constrainXScale;
            this.constrainYScale = constrainYScale;
            this.noFlipXScale = noFlipXScale;
            this.noFlipYScale = noFlipYScale;
            this.constrainNoFlipXScale = constrainNoFlipXScale;
            this.constrainNoFlipYScale = constrainNoFlipYScale;
            this.x = x;
            this.y = y;
        }

        public ZNode getNode() {
            return this.node;
        }

        public ZMouseEvent getMouseEvent() {
            return this.mouseEvent;
        }

        public double getScaleX() {
            return this.xScale;
        }

        public double getScaleY() {
            return this.yScale;
        }

        public double getConstrainScaleX() {
            return this.constrainXScale;
        }

        public double getConstrainScaleY() {
            return this.constrainYScale;
        }

        public double getNoFlipScaleX() {
            return this.noFlipXScale;
        }

        public double getNoFlipScaleY() {
            return this.noFlipYScale;
        }

        public double getNoFlipConstrainScaleX() {
            return this.constrainNoFlipXScale;
        }

        public double getNoFlipConstrainScaleY() {
            return this.constrainNoFlipYScale;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }
    }

    public static interface ResizeListener
    extends EventListener {
        public void nodeResized(ResizeEvent var1);

        public void resizeComplete();
    }
}

