/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz.event;

import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.event.ZFilteredEventHandler;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZCanvas;
import java.awt.event.KeyEvent;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;

public class ZSelectionScaleHandler
extends ZFilteredEventHandler {
    private double fScaleFactor = 1.1f;

    public ZSelectionScaleHandler(ZCanvas aFilteredKeyEventSouce) {
        super(null, aFilteredKeyEventSouce);
    }

    public ZSelectionScaleHandler(ZCamera aIgnoredCamera, ZCanvas aFilteredKeyEventSouce) {
        this(aFilteredKeyEventSouce);
    }

    public double getScaleFactor() {
        return this.fScaleFactor;
    }

    public void setScaleFactor(double aScaleFactor) {
        this.fScaleFactor = aScaleFactor;
    }

    protected void filteredKeyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 33: {
                this.scaleSelectionUp();
                break;
            }
            case 34: {
                this.scaleSelectionDown();
            }
        }
    }

    protected void scaleSelectionUp() {
        this.scaleSelectionBy(this.getScaleFactor());
    }

    protected void scaleSelectionDown() {
        this.scaleSelectionBy(1.0 / this.getScaleFactor());
    }

    protected void scaleSelectionBy(double aScaleFactor) {
        ZBounds totalSelectionBounds = new ZBounds();
        Collection currentSelection = this.getCurrentSelection();
        Iterator i = currentSelection.iterator();
        while (i.hasNext()) {
            ZNode each = (ZNode)i.next();
            totalSelectionBounds.add(each.getGlobalBounds());
        }
        Point2D selectionCenterPoint = totalSelectionBounds.getCenter2D();
        Point2D.Double temp = new Point2D.Double();
        i = currentSelection.iterator();
        while (i.hasNext()) {
            ZNode each = (ZNode)i.next();
            temp.setLocation(selectionCenterPoint);
            each.globalToLocal(temp);
            each.editor().getTransformGroup().scale(aScaleFactor, ((Point2D)temp).getX(), ((Point2D)temp).getY());
        }
    }
}

