/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.xmp;

import com.drew.imaging.PhotographicConversions;
import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.TagDescriptor;
import java.text.DecimalFormat;

public class XmpDescriptor
extends TagDescriptor {
    private static final DecimalFormat SimpleDecimalFormatter = new DecimalFormat("0.#");

    public XmpDescriptor(Directory directory) {
        super(directory);
    }

    public String getDescription(int tagType) throws MetadataException {
        switch (tagType) {
            case 1: 
            case 2: {
                return this._directory.getString(tagType);
            }
            case 3: {
                return this.getExposureTimeDescription();
            }
            case 12: {
                return this.getExposureProgramDescription();
            }
            case 4: {
                return this.getShutterSpeedDescription();
            }
            case 5: {
                return this.getFNumberDescription();
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return this._directory.getString(tagType);
            }
            case 10: {
                return this.getFocalLengthDescription();
            }
            case 11: {
                return this.getApertureValueDescription();
            }
        }
        return this._directory.getString(tagType);
    }

    public String getExposureTimeDescription() {
        if (!this._directory.containsTag(3)) {
            return null;
        }
        return this._directory.getString(3) + " sec";
    }

    public String getExposureProgramDescription() throws MetadataException {
        if (!this._directory.containsTag(12)) {
            return null;
        }
        switch (this._directory.getInt(12)) {
            case 1: {
                return "Manual control";
            }
            case 2: {
                return "Program normal";
            }
            case 3: {
                return "Aperture priority";
            }
            case 4: {
                return "Shutter priority";
            }
            case 5: {
                return "Program creative (slow program)";
            }
            case 6: {
                return "Program action (high-speed program)";
            }
            case 7: {
                return "Portrait mode";
            }
            case 8: {
                return "Landscape mode";
            }
        }
        return "Unknown program (" + this._directory.getInt(34850) + ")";
    }

    public String getShutterSpeedDescription() throws MetadataException {
        if (!this._directory.containsTag(4)) {
            return null;
        }
        float apexValue = this._directory.getFloat(4);
        if (apexValue <= 1.0f) {
            float apexPower = (float)(1.0 / Math.exp((double)apexValue * Math.log(2.0)));
            long apexPower10 = Math.round((double)apexPower * 10.0);
            float fApexPower = (float)apexPower10 / 10.0f;
            return fApexPower + " sec";
        }
        int apexPower = (int)Math.exp((double)apexValue * Math.log(2.0));
        return "1/" + apexPower + " sec";
    }

    public String getFNumberDescription() throws MetadataException {
        if (!this._directory.containsTag(5)) {
            return null;
        }
        Rational fNumber = this._directory.getRational(5);
        return "F" + SimpleDecimalFormatter.format(fNumber.doubleValue());
    }

    public String getFocalLengthDescription() throws MetadataException {
        if (!this._directory.containsTag(10)) {
            return null;
        }
        DecimalFormat formatter = new DecimalFormat("0.0##");
        Rational focalLength = this._directory.getRational(10);
        return formatter.format(focalLength.doubleValue()) + " mm";
    }

    public String getApertureValueDescription() throws MetadataException {
        if (!this._directory.containsTag(11)) {
            return null;
        }
        double aperture = this._directory.getDouble(11);
        double fStop = PhotographicConversions.apertureToFStop(aperture);
        return "F" + SimpleDecimalFormatter.format(fStop);
    }
}

