/*
 * Decompiled with CFR 0.152.
 */
package info.cqs.remotefs;

import info.cqs.remotefs.RemoteFS;
import info.cqs.remotefs.ftp.Ftp4jAdapter;
import info.cqs.remotefs.ftp.FtpAdapter;
import info.cqs.remotefs.sftp.SftpAdapter;
import se.datadosen.jalbum.TransferProtocol;

public class RemoteFSFactory {
    private RemoteFSFactory() {
    }

    public static RemoteFS getRemoteFS(TransferProtocol type) throws IllegalArgumentException {
        switch (type) {
            case ftp: {
                return new FtpAdapter();
            }
            case sftp: {
                return new SftpAdapter();
            }
            case ftps: 
            case ftpes: {
                return new Ftp4jAdapter(type);
            }
            case ftp4j: {
                return new Ftp4jAdapter(TransferProtocol.ftp);
            }
        }
        throw new IllegalArgumentException("Unsupported type (" + (Object)((Object)type) + ")");
    }
}

