/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JProgressSpinner
extends JComponent {
    public static final int nticks = 12;
    public int prefSize = 20;
    private int phase = 0;
    private int delay = 50;
    private boolean hidden = false;
    private Thread animator;
    private int nWorkers = 0;
    private BufferedImage[] phases = new BufferedImage[12];

    public JProgressSpinner() {
        this.init();
    }

    public JProgressSpinner(int preferredSize, boolean spinning) {
        this.prefSize = preferredSize;
        this.setSpinning(true);
        this.init();
    }

    public JProgressSpinner(int preferredSize) {
        this.prefSize = preferredSize;
        this.init();
    }

    public JProgressSpinner(boolean spinning) {
        this.setSpinning(true);
        this.init();
    }

    private void renderPhases(int size) {
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        Color c = this.getForeground();
        int red = c.getRed();
        int green = c.getGreen();
        int blue = c.getBlue();
        int[] alphas = new int[12];
        for (int i = 0; i < alphas.length; ++i) {
            alphas[i] = 30 + 15 * i;
        }
        float unit = (float)size / 10.0f;
        for (int p = 0; p < 12; ++p) {
            this.phases[p] = gc.createCompatibleImage(size, size, 3);
            Graphics2D g2d = this.phases[p].createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.translate(size / 2, size / 2);
            for (int i = 0; i < 12; ++i) {
                g2d.setColor(new Color(red, green, blue, alphas[(i + 12 - p) % 12]));
                g2d.rotate(0.5235987755982988);
                g2d.fillRoundRect((int)(2.0f * unit), (int)(-unit) / 2, (int)(2.8 * (double)unit), (int)unit, (int)unit, (int)unit);
            }
            g2d.dispose();
        }
    }

    protected void paintComponent(Graphics g) {
        if (this.hidden || !this.isVisible()) {
            return;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        Insets in = this.getInsets();
        int size = Math.min(w -= in.left + in.right, h -= in.top + in.bottom);
        if (this.phases[0] == null || this.phases[0].getWidth() != size) {
            this.renderPhases(size);
        }
        g.drawImage(this.phases[this.phase], in.left + (w - size) / 2, in.top + (h - size) / 2, null);
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase % 12;
        this.repaint();
    }

    public void advancePhase() {
        this.setPhase(this.getPhase() + 1);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
        this.setSpinning(!hidden);
        this.repaint();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.setSpinning(visible);
    }

    public void workStarted() {
        if (this.nWorkers == 0) {
            this.setHidden(false);
        }
        ++this.nWorkers;
    }

    public void workDone() {
        if (this.nWorkers > 0) {
            --this.nWorkers;
        }
        if (this.nWorkers == 0) {
            this.setHidden(true);
        }
    }

    public boolean isSpinning() {
        return this.animator != null;
    }

    public void setSpinning(boolean spinning) {
        if (spinning && this.animator != null) {
            return;
        }
        if (spinning) {
            this.animator = new Thread("JProgressSpinner animator"){

                public void run() {
                    try {
                        while (!this.isInterrupted()) {
                            1.sleep(JProgressSpinner.this.delay);
                            JProgressSpinner.this.advancePhase();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            };
            this.animator.setDaemon(true);
            this.animator.start();
        } else {
            Thread t = this.animator;
            if (t != null) {
                t.interrupt();
                this.animator = null;
            }
        }
    }

    public Dimension getPreferredSize() {
        Insets in = this.getInsets();
        return new Dimension(this.prefSize + in.left + in.right, this.prefSize + in.top + in.bottom);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Progress spinner test");
        f.setLayout(new BorderLayout());
        JProgressSpinner spinner = new JProgressSpinner(true);
        f.add((Component)spinner, "North");
        JProgressSpinner spinner2 = new JProgressSpinner(true);
        f.add((Component)spinner2, "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setBackground(new Color(100, 100, 200));
        for (int i = 0; i < 10; ++i) {
            bottomPanel.add(new JProgressSpinner(true));
        }
        f.add((Component)bottomPanel, "South");
        f.setSize(200, 200);
        f.validate();
        f.setDefaultCloseOperation(3);
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }

    protected void finalize() throws Throwable {
        if (this.animator != null) {
            this.animator.interrupt();
        }
        super.finalize();
    }

    private void init() {
    }
}

