/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import net.jalbum.resty.web.Resty;
import org.w3c.dom.NodeList;
import se.datadosen.component.MenuBasedAutoCompleter;

public class TagAutoCompleter
extends MenuBasedAutoCompleter {
    private String postfix = ", ";
    private int threshold = 1;
    private String separatorChars = ",;+";
    private Set<String> allTags = new HashSet<String>();
    private String previousTagPart = "";

    public TagAutoCompleter(JTextComponent comp) {
        super(comp);
    }

    protected boolean updateListData() {
        int pos;
        String content = this.textComp.getText();
        final String tagPart = TagAutoCompleter.tagAt(content, pos = this.textComp.getCaretPosition());
        if (tagPart.equals(this.previousTagPart)) {
            ArrayList<String> tags = new ArrayList<String>();
            if (tagPart.length() >= this.threshold) {
                for (String t : this.allTags) {
                    if (!t.toLowerCase().startsWith(tagPart.toLowerCase())) continue;
                    tags.add(t);
                }
                if (tags.size() == 1 && tagPart.equalsIgnoreCase((String)tags.get(0))) {
                    tags.remove(0);
                }
            }
            this.list.setListData(tags.toArray(new String[0]));
            return true;
        }
        this.previousTagPart = tagPart;
        new Thread("tagFinder"){

            public void run() {
                TagAutoCompleter.this.loadMatchingTags(tagPart);
            }
        }.start();
        return true;
    }

    static String tagAt(String s, int pos) {
        int end;
        int start;
        char[] chars = s.toCharArray();
        for (start = pos - 1; start >= 0 && chars[start] != ','; --start) {
        }
        ++start;
        while (start < chars.length && Character.isWhitespace(chars[start])) {
            ++start;
        }
        for (end = pos; end < chars.length && chars[end] != ','; ++end) {
        }
        return new String(chars, start, end - start);
    }

    private void loadMatchingTags(String tagPart) {
        try {
            String autoCompleteUrl = "http://j-album.org:8080/integration/auto-complete?tag=" + URLEncoder.encode(tagPart, "UTF-8");
            Resty r = new Resty(new Resty.Option[0]);
            NodeList nodes = (NodeList)r.xml(autoCompleteUrl).get("/reply/result/tag", NodeList.class);
            HashSet<String> tags = new HashSet<String>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                tags.add(nodes.item(i).getTextContent());
            }
            this.allTags = tags;
            this.showPopup();
        }
        catch (IOException ex) {
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void acceptedListItem(String selected) {
        if (selected == null) {
            return;
        }
        String content = this.textComp.getText();
        int pos = this.textComp.getCaretPosition();
        String tagPart = TagAutoCompleter.tagAt(content, pos);
        try {
            int endIndex = this.indexOfTagEnd(content, pos);
            String post = this.postfix;
            if (endIndex < content.length() && content.charAt(endIndex) == ',') {
                post = "";
            }
            this.textComp.getDocument().insertString(this.indexOfTagEnd(content, pos), selected.substring(tagPart.length()) + post, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private int indexOfTagEnd(String content, int pos) {
        char[] chars = content.toCharArray();
        while (pos < chars.length && chars[pos] != ',') {
            ++pos;
        }
        return pos;
    }
}

