/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import com.adobe.xmp.XMPException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.jalbum.filterManager.FilterList;
import net.jalbum.filterManager.JAlbumImageFilter;
import se.datadosen.component.WordList;
import se.datadosen.explorer.CaptionEditor;
import se.datadosen.explorer.FileNameEditor;
import se.datadosen.explorer.JExplorerPanel;
import se.datadosen.explorer.KeywordsEditor;
import se.datadosen.explorer.NullEditor;
import se.datadosen.explorer.TemporaryFileNameEditor;
import se.datadosen.explorer.TitleEditor;
import se.datadosen.io.LinkFile;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Flag;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumBorders;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.TipOfTheDay;
import se.datadosen.jalbum.XmpManager;
import se.datadosen.util.DataSizeFormatter;
import se.datadosen.util.IO;
import se.datadosen.util.NamedThreadFactory;
import se.datadosen.util.Platform;
import se.datadosen.util.annotations.ToolTipText;

public class JAlbumObject
extends JComponent
implements Transferable {
    static boolean tabCycling;
    private static ImageIcon isWebSafeIcon;
    private static ImageIcon isCommentedIcon;
    private static ImageIcon isFolderThumbnailIcon;
    private static ImageIcon isMediaFileIcon;
    private static ImageIcon hasImageFiltersIcon;
    private static ImageIcon hasOriginalIcon;
    public static DataFlavor jAlbumObjectFlavor;
    private static Image excludedImage;
    private static ImageIcon defaultImageIcon;
    private static ImageIcon[] stars;
    private static ImageIcon linkImage;
    private static ExecutorService iconLoaderPool;
    Future<ImageIcon> iconLoader = null;
    private static ExecutorService metadataLoaderPool;
    Future<Object> metadataLoader = null;
    public final AlbumObject ao;
    final JExplorerPanel context;
    private boolean selected;
    private boolean rubberbanded;
    private NorthPanel northPanel;
    private JPanel imagePanel = new JPanel();
    LabelEditor editor;
    private JPanel buttonPanel = new JPanel(new FlowLayout(0, 1, 1));
    private JLabel image;
    private static final DateFormat dateTimeFormat;

    private static JLabel createStatusLabel(Icon icon) {
        JLabel label = new JLabel(icon);
        label.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        label.setVisible(false);
        return label;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException("JAlbum Objects are not serializable");
    }

    public JAlbumObject(AlbumObject ao, JExplorerPanel context) {
        this.ao = ao;
        this.context = context;
        this.setLayout(new BorderLayout());
        this.setFocusable(true);
        this.image = new JLabel(defaultImageIcon);
        this.image.setPreferredSize(context.iconBounds);
        this.image.setLayout(new BorderLayout());
        this.buttonPanel.setOpaque(false);
        this.imagePanel.setLayout(new BorderLayout());
        this.imagePanel.setOpaque(false);
        this.imagePanel.add((Component)this.image, "Center");
        this.add((Component)this.imagePanel, "North");
        this.editor = new NullEditor(this);
        this.add((Component)this.editor, "Center");
        this.imagePanel.setBorder(JAlbumBorders.createImageBorder());
        this.validate();
    }

    private void installNorthPanel() {
        this.northPanel = new NorthPanel();
        this.image.add((Component)this.northPanel, "North");
        this.validate();
    }

    void attachEditButton(JButton editButton) {
        if (this.buttonPanel.getComponentCount() > 0 && editButton == this.buttonPanel.getComponent(0)) {
            editButton.setVisible(true);
            return;
        }
        Container c = editButton.getParent();
        if (c != null) {
            c.remove(editButton);
        }
        this.buttonPanel.add(editButton);
        editButton.setVisible(true);
        if (!TipOfTheDay.isPendingNotification() && !TipOfTheDay.isShowingNotification()) {
            TipOfTheDay.showInBackground(Msg.get("tip.editMode"));
        }
    }

    private void render() {
        if (this.iconLoader == null) {
            this.installNorthPanel();
            this.iconLoader = iconLoaderPool.submit(new Callable<ImageIcon>(){

                @Override
                public ImageIcon call() throws Exception {
                    ImageIcon icon = JAlbumObject.this.ao.getRepresentingIcon(JAlbumObject.this.context.iconBounds, false);
                    JAlbumObject.this.image.setIcon(icon);
                    JAlbumObject.this.repaint();
                    return icon;
                }
            });
        } else if (this.iconLoader.isDone()) {
            try {
                this.image.setIcon(this.ao.getRepresentingIcon(this.context.iconBounds, false));
            }
            catch (Exception ex) {
                this.image.setText("Broken");
            }
        }
        if (this.editor instanceof NullEditor && this.metadataLoader == null) {
            this.remove(this.editor);
            Config config = Config.getConfig();
            if (this.ao.isFolder() || this.ao.getCategory() == Category.webPage || config.getLabelType() == Config.LabelType.fileName) {
                this.editor = new FileNameEditor(this);
            } else {
                switch (config.getLabelType()) {
                    case title: {
                        this.editor = new TitleEditor(this);
                        break;
                    }
                    case caption: {
                        this.editor = new CaptionEditor(this);
                        break;
                    }
                    case keywords: {
                        this.editor = new KeywordsEditor(this);
                    }
                }
            }
            this.add((Component)this.editor, "Center");
            this.editor.setSelected(this.selected);
            this.validate();
            this.repaint();
            this.metadataLoader = metadataLoaderPool.submit(new Callable(){

                public Object call() throws Exception {
                    JAlbumObject.this.editor.refresh();
                    JAlbumObject.this.northPanel.updateToolTip();
                    WordList knownKeywords = JAlbumObject.this.context.context.knownKeywords;
                    try {
                        XmpManager manager = JAlbumObject.this.ao.getXmpManager();
                        if (manager != null) {
                            knownKeywords.addAll(manager.getKeywordSet());
                        }
                    }
                    catch (XMPException xMPException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
    }

    public void paintChildren(Graphics g) {
        this.render();
        Graphics2D g2d = (Graphics2D)g;
        super.paintChildren(g);
        this.northPanel.updateStatusIcons();
        if (this.ao.isLink()) {
            int ypos = this.image.getHeight() - linkImage.getIconHeight();
            g2d.drawImage(linkImage.getImage(), 2, ypos, null);
        }
        if (!this.ao.isIncluded()) {
            g2d.drawImage(excludedImage, (this.getWidth() - excludedImage.getWidth(null)) / 2, this.image.getY() + (this.image.getHeight() - excludedImage.getHeight(null)) / 2, null);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    boolean isEditing() {
        return this.editor.isEditing();
    }

    void setEditing(boolean editing) {
        this.render();
        this.editor.setEditing(editing);
    }

    public void setRubberbanded(boolean rubberbanded) {
        if (this.isVisible() && this.rubberbanded != rubberbanded) {
            this.setSelected(!this.selected);
        }
        this.rubberbanded = rubberbanded;
    }

    public void resetRubberbanded() {
        this.rubberbanded = false;
    }

    public boolean isIncluded() {
        return this.ao.isIncluded();
    }

    public void setIncluded(boolean included) {
        this.ao.setIncluded(included);
        this.repaint();
    }

    public void setSelected(boolean selected) {
        boolean oldSelected = this.selected;
        this.selected = selected;
        this.editor.setSelected(selected);
        if (selected) {
            this.imagePanel.setBorder(JAlbumBorders.createSelectedImageBorder());
        } else {
            this.editor.setEditing(false);
            this.imagePanel.setBorder(JAlbumBorders.createImageBorder());
        }
        if (selected != oldSelected) {
            this.context.selectionModel.objectSelected(this, selected);
        }
    }

    public Object getTransferData(DataFlavor flavor) {
        if (flavor.equals(jAlbumObjectFlavor)) {
            return null;
        }
        return null;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{jAlbumObjectFlavor};
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return jAlbumObjectFlavor.equals(flavor);
    }

    public String toString() {
        return this.getClass().getName() + " [name=" + this.ao.getName() + "]";
    }

    public static Image getCrossImage() {
        return excludedImage;
    }

    static {
        isWebSafeIcon = Icons.getIcon("small.warning");
        isCommentedIcon = Icons.getIcon("small.message");
        isFolderThumbnailIcon = Icons.getIcon("small.folder");
        isMediaFileIcon = Icons.getIcon("small.film");
        hasImageFiltersIcon = Icons.getIcon("small.edited");
        hasOriginalIcon = Icons.getIcon("small.original");
        jAlbumObjectFlavor = new DataFlavor(JAlbumObject.class, "JAlbum object");
        excludedImage = new ImageIcon(JAlbumObject.class.getResource("images/forbidden.png")).getImage();
        stars = new ImageIcon[5];
        for (int i = 1; i <= 5; ++i) {
            JAlbumObject.stars[i - 1] = Icons.getIcon("small.star" + i);
        }
        try {
            defaultImageIcon = new ImageIcon(new File(Config.getConfig().progDir, "res/image.png").toURL());
            linkImage = Platform.isMac() ? new ImageIcon(JAlbumObject.class.getResource("images/link_mac.png")) : new ImageIcon(JAlbumObject.class.getResource("images/link.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        iconLoaderPool = Executors.newFixedThreadPool(4, new NamedThreadFactory("Icon loader"));
        metadataLoaderPool = Executors.newCachedThreadPool(new NamedThreadFactory("Metadata loader"));
        dateTimeFormat = DateFormat.getDateTimeInstance();
    }

    private class NorthPanel
    extends JPanel
    implements PropertyChangeListener {
        private JPanel statusPanel;
        @ToolTipText(value="ui.isWebSafeToolTip")
        private JLabel isWebSafeStatus;
        private JLabel isCommentedStatus;
        @ToolTipText(value="ui.isFolderThumbnailToolTip")
        private JLabel isFolderThumbnailStatus;
        @ToolTipText(value="ui.isMediaFileToolTip")
        private JLabel isMediaFileStatus;
        @ToolTipText(value="ui.hasImageFiltersToolTip")
        private JLabel hasImageFiltersToolTip;
        @ToolTipText(value="ui.hasOriginaToolTip")
        private JLabel hasOriginalStatus;
        @ToolTipText(value="ui.notReEncodedToolTip")
        private JLabel notReEncodedStatus;
        private JLabel ratingStatus;
        private JLabel flagStatus;

        public NorthPanel() {
            super(new BorderLayout());
            this.statusPanel = new JPanel(new FlowLayout(2, 0, 1));
            this.isWebSafeStatus = JAlbumObject.createStatusLabel(isWebSafeIcon);
            this.isCommentedStatus = JAlbumObject.createStatusLabel(isCommentedIcon);
            this.isFolderThumbnailStatus = JAlbumObject.createStatusLabel(isFolderThumbnailIcon);
            this.isMediaFileStatus = JAlbumObject.createStatusLabel(isMediaFileIcon);
            this.hasImageFiltersToolTip = new JFiltersLabel();
            this.hasOriginalStatus = JAlbumObject.createStatusLabel(hasOriginalIcon);
            this.notReEncodedStatus = JAlbumObject.createStatusLabel(hasOriginalIcon);
            this.ratingStatus = JAlbumObject.createStatusLabel(null);
            this.flagStatus = JAlbumObject.createStatusLabel(null);
            this.init();
        }

        private void init() {
            this.statusPanel.setOpaque(false);
            this.statusPanel.add(this.isWebSafeStatus);
            this.statusPanel.add(this.isFolderThumbnailStatus);
            this.statusPanel.add(this.isMediaFileStatus);
            this.statusPanel.add(this.hasImageFiltersToolTip);
            this.statusPanel.add(this.ratingStatus);
            this.statusPanel.add(this.flagStatus);
            this.statusPanel.add(this.hasOriginalStatus);
            this.statusPanel.add(this.notReEncodedStatus);
            this.statusPanel.add(Box.createHorizontalStrut(1));
            this.setOpaque(false);
            this.add((Component)JAlbumObject.this.buttonPanel, "West");
            this.add((Component)this.statusPanel, "East");
            this.isWebSafeStatus.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (!(JAlbumObject.this.editor instanceof FileNameEditor)) {
                        TemporaryFileNameEditor editor = new TemporaryFileNameEditor(JAlbumObject.this);
                        editor.install();
                    }
                    JAlbumObject.this.setEditing(true);
                }
            });
            Msg.setTexts(this);
            JAlbumObject.this.ao.addPropertyChangeListener(this);
        }

        private void updateStatusIcons() {
            boolean isFolderThumbnail = false;
            if (JAlbumObject.this.context.context.currentFolder != null) {
                AlbumObject thisRep;
                AlbumObject rep = JAlbumObject.this.context.context.currentFolder.getRepresentingAlbumObject();
                AlbumObject albumObject = thisRep = JAlbumObject.this.ao.getRepresentingAlbumObject() != null ? JAlbumObject.this.ao.getRepresentingAlbumObject() : JAlbumObject.this.ao;
                if (rep != null && thisRep != null && thisRep.getFile().equals(rep.getFile())) {
                    isFolderThumbnail = true;
                }
            }
            this.isFolderThumbnailStatus.setVisible(isFolderThumbnail);
            if (JAlbumObject.this.editor instanceof FileNameEditor) {
                this.isCommentedStatus.setVisible(JAlbumObject.this.ao.getComment().length() > 0);
            }
            this.isWebSafeStatus.setVisible(!IO.baseName(JAlbumObject.this.ao.getName()).equals(IO.baseName(JAlbumObject.this.ao.getWebName())));
            int rating = JAlbumObject.this.ao.getRating();
            if (rating > 0 && rating <= 5) {
                if (this.ratingStatus.getIcon() != stars[rating - 1]) {
                    this.ratingStatus.setIcon(stars[rating - 1]);
                    this.ratingStatus.setToolTipText(Msg.get("ui.ratingToolTip", rating));
                }
                this.ratingStatus.setVisible(true);
            } else {
                this.ratingStatus.setVisible(false);
            }
            Flag flag = JAlbumObject.this.ao.getFlag();
            if (flag != Flag.NoFlag) {
                this.flagStatus.setIcon(flag.getIcon());
                this.flagStatus.setToolTipText(flag.toString());
                this.flagStatus.setVisible(true);
            } else {
                this.flagStatus.setVisible(false);
            }
            FilterList filterList = (FilterList)JAlbumObject.this.ao.getProperties().get("filterList");
            boolean hasFilters = filterList != null && filterList.getPosition() > 0;
            this.hasImageFiltersToolTip.setVisible(hasFilters);
            this.isMediaFileStatus.setVisible(JAlbumObject.this.ao.getCategory() == Category.video);
            if (JAlbumObject.this.ao.getCategory() == Category.video) {
                this.notReEncodedStatus.setVisible(JAlbumObject.this.ao.isIncludeOriginal());
            } else {
                this.hasOriginalStatus.setVisible(JAlbumObject.this.ao.isIncludeOriginal());
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String type = evt.getPropertyName();
            if ("comment".equals(type)) {
                this.updateToolTip();
                JAlbumObject.this.editor.refresh();
            } else if ("name".equals(type)) {
                JAlbumObject.this.editor.refresh();
                this.updateStatusIcons();
                this.updateToolTip();
            } else if ("keywords".equals(type) || "title".equals(type)) {
                JAlbumObject.this.editor.refresh();
            } else if ("orientation".equals(type)) {
                JAlbumObject.this.repaint();
            } else if ("imageUpdated".equals(type)) {
                JAlbumObject.this.repaint();
            } else if ("hidden".equals(type)) {
                JAlbumObject.this.repaint();
            } else if ("linkRepaired".equals(type)) {
                JAlbumObject.this.repaint();
                this.updateToolTip();
            } else if ("properties".equals(type)) {
                this.updateStatusIcons();
                JAlbumObject.this.context.context.applyFilter(JAlbumObject.this);
            }
        }

        private void updateToolTip() {
            String comment = JAlbumObject.this.ao.getComment();
            if (!JAlbumObject.this.ao.getFile().exists()) {
                JAlbumObject.this.setToolTipText(Msg.get("edit.brokenLinkError", JAlbumObject.this.ao.getFile()));
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("<html><table>");
                sb.append("<tr><td align=\"right\">").append(Msg.get("info.type")).append(":").append("</td><td>").append(JAlbumObject.this.ao.getCategory().getPrintableName()).append("</td></tr>");
                if (!JAlbumObject.this.ao.isFolder()) {
                    sb.append("<tr><td align=\"right\">").append(Msg.get("info.size")).append(":").append("</td><td>").append(DataSizeFormatter.groupByThousands(JAlbumObject.this.ao.getFile().length())).append(" bytes (").append(DataSizeFormatter.format(JAlbumObject.this.ao.getFile().length())).append(")</td></tr>");
                }
                sb.append("<tr><td align=\"right\">").append(Msg.get("info.location")).append(":").append("</td><td>").append(JAlbumObject.this.ao.getFile() instanceof LinkFile ? ((LinkFile)JAlbumObject.this.ao.getFile()).getTarget() : JAlbumObject.this.ao.getFile()).append("</td></tr>");
                sb.append("<tr><td align=\"right\">").append(Msg.get("info.added")).append(":").append("</td><td>").append(dateTimeFormat.format(new Date(JAlbumObject.this.ao.getWhenAdded()))).append("</td></tr>");
                sb.append("<tr><td align=\"right\">").append(Msg.get("info.modified")).append(":").append("</td><td>").append(dateTimeFormat.format(new Date(JAlbumObject.this.ao.getFile().lastModified()))).append("</td></tr>");
                sb.append("</table></html>");
                JAlbumObject.this.setToolTipText(sb.toString());
                if (comment != null && comment.length() > 0 && JAlbumObject.this.editor instanceof FileNameEditor) {
                    this.isCommentedStatus.setToolTipText("<html><body>" + JAlbumObject.this.ao.getComment() + "</body></html>");
                } else if (this.getToolTipText() != null) {
                    this.isCommentedStatus.setToolTipText(null);
                }
            }
        }

        class JFiltersLabel
        extends JLabel {
            public JFiltersLabel() {
                super(hasImageFiltersIcon);
                this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                this.setVisible(false);
            }

            public String getToolTipText(MouseEvent event) {
                FilterList filterList = (FilterList)JAlbumObject.this.ao.getProperties().get("filterList");
                boolean hasFilters = filterList != null && filterList.getPosition() > 0;
                NorthPanel.this.hasImageFiltersToolTip.setVisible(hasFilters);
                if (hasFilters) {
                    Vector<JAlbumImageFilter> filters = filterList.getFilters();
                    StringBuilder buf = new StringBuilder();
                    for (int i = 0; i < filterList.getPosition(); ++i) {
                        if (i > 0) {
                            buf.append(", ");
                        }
                        buf.append(filters.get(i).getName());
                    }
                    return Msg.get("ui.hasImageFiltersToolTip") + " (" + buf.toString() + ")";
                }
                return "";
            }
        }
    }

    static abstract class LabelEditor
    extends JPanel {
        public static final Font labelFont = new Font("SansSerif", 0, 11);
        protected final JAlbumObject jao;

        LabelEditor(JAlbumObject jao) {
            this.jao = jao;
        }

        abstract void refresh();

        abstract void setEditing(boolean var1);

        abstract boolean isEditing();

        abstract void setSelected(boolean var1);
    }
}

