/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.Color;
import java.io.IOException;
import javax.swing.JTextArea;
import se.datadosen.component.Autocompleter;
import se.datadosen.explorer.AbstractEditor;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.Tracer;

class KeywordsEditor
extends AbstractEditor {
    public static final Color keywordsColor = new Color(0, 128, 0);

    public KeywordsEditor(JAlbumObject jao) {
        super(jao);
    }

    public String readText() {
        return this.ao.getKeywords();
    }

    public void writeText(String text) throws IOException {
        this.ao.setKeywords(text);
        Tracer.getInstance().trace("keywords edited", "location:explorer");
    }

    public String getPromptText() {
        return Msg.get("ui.addKeywords");
    }

    protected Color getTextColor() {
        return keywordsColor;
    }

    protected JTextArea getEditArea() {
        if (this.editArea == null) {
            super.getEditArea();
            new Autocompleter(this.editArea, this.jao.context.context.knownKeywords);
            this.editArea.setToolTipText(Msg.get("edit.keywordsToolTip"));
        }
        return this.editArea;
    }
}

