/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.util.FileFilters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlbumFileFilter
implements FileFilter,
Serializable {
    private File outputDir;
    private Set ignoreDirs = new HashSet();
    private Pattern ignorePattern;
    private Pattern includePattern;
    String pageExtension;
    private boolean ignoreControlFiles = true;

    public boolean isIgnoreControlFiles() {
        return this.ignoreControlFiles;
    }

    public void setIgnoreControlFiles(boolean ignoreControlFiles) {
        this.ignoreControlFiles = ignoreControlFiles;
    }

    public Set<String> getIgnoreDirs() {
        return this.ignoreDirs;
    }

    public AlbumFileFilter(AlbumBean engine) {
        this(engine, engine.getInterpretedOutputDirectory(), engine.getIgnorePattern());
    }

    public AlbumFileFilter(AlbumBean engine, File outputDir, String ignorePattern) {
        this.pageExtension = engine.getPageExtension();
        if (this.pageExtension.length() == 0) {
            this.pageExtension = ".html";
        }
        if (outputDir != null) {
            if ("".equals(engine.getDirectory())) {
                outputDir = new File(outputDir.getName());
            }
            this.outputDir = outputDir;
            this.ignoreDirs.add(engine.getResourceDirectory().toLowerCase());
            this.ignoreDirs.add("gifs".toLowerCase());
            this.ignoreDirs.add(engine.getThumbnailDirectory().toLowerCase());
            this.ignoreDirs.add(engine.getSlideDirectory().toLowerCase());
            this.ignoreDirs.add(engine.getHiResDirectory().toLowerCase());
        }
        this.ignorePattern = Pattern.compile(ignorePattern, 2);
        String ip = engine.getIncludePattern();
        if (ip != null && ip.length() > 0) {
            this.includePattern = Pattern.compile(engine.getIncludePattern(), 2);
        }
    }

    @Override
    public boolean accept(File file) {
        String name = file.getName();
        Matcher m = this.ignorePattern.matcher(name);
        if (name.endsWith(".jap") || name.endsWith(".properties") || name.endsWith(".info") || name.equals(".jalbum") || name.equals("albumfiles.txt")) {
            return !this.ignoreControlFiles;
        }
        if (m.matches() || name.endsWith(this.pageExtension)) {
            return false;
        }
        if (file.isDirectory()) {
            if (this.outputDir != null) {
                if (!this.outputDir.isAbsolute() && name.equals(this.outputDir.getName())) {
                    return false;
                }
                if (this.ignoreDirs.contains(name.toLowerCase()) || file.equals(this.outputDir)) {
                    return false;
                }
            }
            return true;
        }
        if (this.includePattern != null) {
            Matcher includeMatcher = this.includePattern.matcher(name);
            return includeMatcher.matches();
        }
        if (!file.exists() || FileFilters.isFileSupported(file)) {
            return true;
        }
        return FileFilters.hasIcon(file);
    }
}

