/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import se.datadosen.explorer.JAlbumObject;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.AlbumObjectMetadata;
import se.datadosen.jalbum.AlbumObjectProperties;
import se.datadosen.jalbum.Category;
import se.datadosen.jalbum.Flag;
import se.datadosen.jalbum.PermissionException;
import se.datadosen.jalbum.XmpManager;
import se.datadosen.util.Orientation;
import se.datadosen.util.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface AlbumObject
extends Transferable {
    public static final DataFlavor albumObjectFlavor = new DataFlavor(JAlbumObject.class, "JAlbum object");

    public AlbumObject getParent();

    public File getFile();

    public long getLastModified();

    public long getWhenAdded();

    public Image loadImage(boolean var1, Dimension var2) throws IOException;

    public Image loadImage() throws IOException;

    public AlbumObjectFactory getFactory();

    public String getName();

    public String getWebName();

    public boolean setName(String var1);

    public String getComment();

    public void setComment(String var1) throws IOException;

    public String getTitle();

    public boolean setTitle(String var1);

    public int getRating();

    public void setRating(int var1);

    public Flag getFlag();

    public void setFlag(Flag var1);

    public String getKeywords();

    public void setKeywords(String var1);

    public AlbumObjectMetadata getMetadata();

    public AlbumObjectProperties getProperties();

    public XmpManager getXmpManager();

    public void rotateLeft();

    public void rotateRight();

    public Orientation getOrientation();

    public void setOrientation(Orientation var1);

    public boolean isIncludeOriginal();

    public void setIncludeOriginal(boolean var1);

    public void delete() throws IOException, PermissionException;

    public AlbumObject createFolder(String var1) throws IOException;

    public AlbumObject createPage(String var1) throws IOException;

    public AlbumObject createPage(String var1, File var2) throws IOException;

    public boolean isDisplayableImage();

    public boolean hasDisplayableImage();

    public boolean isLink();

    public boolean isFolder();

    public Category getCategory();

    public boolean isIncluded();

    public void setIncluded(boolean var1);

    public boolean isHidden();

    public boolean isWithin(AlbumObject var1);

    public void setHidden(boolean var1);

    public List<AlbumObject> getChildren();

    public AlbumObject getChild(String var1);

    public void setChildren(List<AlbumObject> var1) throws IOException;

    public boolean containsName(String var1);

    public void moveTo(AlbumObject var1) throws IOException;

    public void moveTo(AlbumObject var1, int var2) throws IOException;

    public boolean repairLink(File var1) throws IOException;

    public void add(List<File> var1) throws IOException;

    public void add(int var1, Set<AlbumObject> var2) throws IOException;

    public void add(Set<AlbumObject> var1) throws IOException;

    public Ordering getOrdering();

    public void setOrdering(Ordering var1) throws IOException;

    public Ordering getFolderOrdering();

    public void setFolderOrdering(Ordering var1) throws IOException;

    public boolean isFoldersFirst();

    public void setFoldersFirst(boolean var1) throws IOException;

    public boolean isReverseOrdering();

    public void setReverseOrdering(boolean var1) throws IOException;

    public boolean isReverseFolderOrdering();

    public void setReverseFolderOrdering(boolean var1) throws IOException;

    public void setRepresentingIcon(BufferedImage var1, boolean var2) throws IOException;

    public AlbumObject getRepresentingAlbumObject();

    public AlbumObject getRepresentingAlbumObject(boolean var1);

    public void setRepresentingAlbumObject(AlbumObject var1);

    public void updateRepresentingIcon();

    public void invalidate();

    public ImageIcon getRepresentingIcon(Dimension var1, boolean var2) throws IOException;

    public ImageIcon getRepresentingIcon(Dimension var1, boolean var2, boolean var3) throws IOException;

    public File getRepresentingImageFile();

    public String getThumbnailPath();

    public void addPropertyChangeListener(PropertyChangeListener var1);

    public String getPathFromRoot();

    public void removePropertyChangeListener(PropertyChangeListener var1);

    public void addPropertyChangeListener(String var1, PropertyChangeListener var2);

    public Scope getVars();

    public void setVars(Scope var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Ordering {
        jalbum,
        custom,
        date,
        cameraDate,
        addedDate,
        rating,
        name,
        simpleName,
        title,
        comment;

    }
}

