/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import se.datadosen.jalbum.Config;
import se.datadosen.util.IO;

public class Cameras {
    public static final String FOCAL_LENGTH_MULTIPLIER = "focalLengthMultiplier";
    protected static Cameras theInstance;
    private Map<String, String> map;

    private Cameras() {
        File f = new File(Config.getConfig().progDir, "system/cameras.properties");
        try {
            this.map = IO.readMapFile(f);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Double getFocalLengthMultiplier(String maker, String model) {
        String value = this.getValue(maker, model, FOCAL_LENGTH_MULTIPLIER);
        if (value == null) {
            return null;
        }
        return Double.parseDouble(value);
    }

    public String getValue(String maker, String model, String key) {
        String value = this.map.get("" + maker + " " + model + "." + key);
        if (value == null) {
            value = this.map.get(model + "." + key);
        }
        return value;
    }

    public String putValue(String maker, String model, String key, String value) {
        return this.map.put("" + maker + " " + model + "." + key, value);
    }

    public static Cameras getInstance() {
        if (theInstance == null) {
            theInstance = new Cameras();
        }
        return theInstance;
    }
}

