/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import se.datadosen.component.JPlainButton;
import se.datadosen.component.JPlainToggleButton;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.AlbumBeanEvent;
import se.datadosen.jalbum.AlbumBeanListener;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.Msg;
import se.datadosen.jalbum.Tracer;
import se.datadosen.util.Platform;
import se.datadosen.util.Stopwatch;
import se.datadosen.util.annotations.Text;

public class JProgressDialog
extends JDialog
implements AlbumBeanListener {
    private JPanel thePanel = new JPanel();
    private JPanel mainPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JLabel directory = new JLabel();
    private JProgressBar progressBar = new JProgressBar(){

        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            dim.width = 280;
            return dim;
        }
    };
    private JPlainToggleButton pauseButton = new JPlainToggleButton((Icon)Icons.getIcon("small.pause"), (Icon)Icons.getIcon("small.pause1"));
    private JButton abortButton = new JPlainButton(Icons.getIcon("small.abort"), (Icon)Icons.getIcon("small.abort1"));
    private JButton viewAlbumButton = new JButton();
    private JButton publishButton;
    private JButton openFolderButton;
    private JLabel file = new JLabel();
    private JLabel timeInfo = new JLabel();
    private Stopwatch timer = new Stopwatch();
    boolean abort = false;
    private boolean finished = false;
    private Window parent;
    private Object engineMonitor = new Object();
    @Text(value="ui.openFolder")
    Action openFolderAction = new AbstractAction(){
        {
            this.putValue("SmallIcon", Icons.getIcon("big.folder"));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Tracer.getInstance().trace("open album folder clicked");
                BrowserLauncher.openLocal(((JProgressDialog)JProgressDialog.this).getFrame().engine.getInterpretedOutputDirectory());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    };

    public JProgressDialog(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.parent = parent;
        this.init();
    }

    public JProgressDialog(Dialog parent, String title, boolean modal) {
        super(parent, title, modal);
        this.parent = parent;
        this.init();
    }

    public JProgressDialog(Dialog parent, String title, boolean modal, boolean abortOnly) {
        super(parent, title, modal);
        this.parent = parent;
        try {
            this.initComponents(abortOnly);
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void init() {
        try {
            this.initComponents(false);
            this.setResizable(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initComponents(boolean abortOnly) throws Exception {
        Msg.maintainTranslated(this);
        this.thePanel.setLayout(new BorderLayout());
        this.publishButton = new JButton(this.getFrame().actions.publishAction);
        this.publishButton.setIcon(Icons.getIcon("big.publish"));
        this.openFolderButton = new JButton(this.openFolderAction);
        if (!abortOnly) {
            this.viewAlbumButton.setAction(this.getFrame().actions.viewAlbumAction);
            this.publishButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (JProgressDialog.this.finished) {
                        JProgressDialog.this.dispose();
                    }
                }
            });
            this.getRootPane().setDefaultButton(this.viewAlbumButton);
            this.pauseButton.setSelectedIcon(Icons.getIcon("small.play"));
            this.pauseButton.setRolloverSelectedIcon(Icons.getIcon("small.play1"));
            this.pauseButton.setToolTipText(Msg.get("progress.pause"));
            this.pauseButton.setSelectedToolTipText(Msg.get("ui.continue"));
            this.pauseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JProgressDialog.this.pauseButton_actionPerformed(e);
                }
            });
        }
        this.abortButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JProgressDialog.this.abortPerformed(e);
            }
        });
        this.abortButton.setToolTipText(Msg.get("abort"));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.mainPanel.setLayout(new RiverLayout());
        this.directory.setText(Msg.get("progress.processingInfo"));
        this.file.setText(Msg.get("progress.fileInfo"));
        this.timeInfo.setText(Msg.get("progress.estimatedTimeLeftInfo"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JProgressDialog.this.this_windowClosing(e);
            }
        });
        this.getContentPane().add(this.thePanel);
        this.thePanel.add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.directory, null);
        this.mainPanel.add("br", this.file);
        this.mainPanel.add("br", Box.createRigidArea(new Dimension(4, 4)));
        JPanel progressPanel = new JPanel(new BorderLayout());
        progressPanel.add((Component)this.progressBar, "Center");
        JPanel progressControls = new JPanel(new FlowLayout(0, 0, 0));
        progressControls.add(Box.createRigidArea(new Dimension(4, 4)));
        if (!abortOnly) {
            progressControls.add(this.pauseButton);
        }
        progressControls.add(this.abortButton);
        progressPanel.add((Component)progressControls, "East");
        this.mainPanel.add("br hfill", progressPanel);
        this.mainPanel.add("br", Box.createRigidArea(new Dimension(4, 4)));
        this.mainPanel.add("br", this.timeInfo);
        this.thePanel.add((Component)this.buttonPanel, "South");
        if (!abortOnly) {
            this.buttonPanel.add(this.viewAlbumButton);
            this.buttonPanel.add(this.openFolderButton);
            this.buttonPanel.add(this.publishButton);
        }
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        JLayeredPane pane = this.getLayeredPane();
        AbstractAction closeAction = new AbstractAction("close"){

            public void actionPerformed(ActionEvent e) {
                JProgressDialog.this.abortPerformed(null);
            }
        };
        pane.registerKeyboardAction(closeAction, "close", ks, 2);
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }

    private static String twoDigits(int x) {
        if (x < 10) {
            return "0" + x;
        }
        return "" + x;
    }

    private static String timerFormat(int secs) {
        int hours = secs / 3600;
        int minutes = secs % 3600 / 60;
        int seconds = secs % 60;
        return "" + hours + ":" + JProgressDialog.twoDigits(minutes) + ":" + JProgressDialog.twoDigits(seconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void imageProcessingStarted(final AlbumBeanEvent e) {
        if (this.finished) {
            return;
        }
        Object object = this.engineMonitor;
        synchronized (object) {
            if (this.pauseButton.isSelected()) {
                try {
                    this.engineMonitor.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.isVisible() && !this.abort) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JProgressDialog.this.updateStateAndSetVisible(true);
                        }
                    });
                }
            }
        }
        if (this.abort) {
            e.abortProcessing();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (!JProgressDialog.this.timer.isRunning()) {
                    JProgressDialog.this.timer.start();
                    JProgressDialog.this.directory.setText(Msg.get("progress.processingInfo"));
                    JProgressDialog.this.directory.setVisible(true);
                    JProgressDialog.this.file.setText(e.msg);
                    JProgressDialog.this.file.setVisible(true);
                    if (!JProgressDialog.this.progressBar.isIndeterminate()) {
                        JProgressDialog.this.progressBar.setValue(e.processedFiles);
                        JProgressDialog.this.progressBar.setMaximum(e.totalFiles);
                        JProgressDialog.this.progressBar.setStringPainted(true);
                        JProgressDialog.this.progressBar.setString(Msg.get("progress.processingInfo2", e.processedFiles + 1, e.totalFiles));
                    }
                }
                JProgressDialog.this.directory.setText(Msg.get("progress.processingInfo") + " " + e.directory);
                JProgressDialog.this.file.setText(e.msg);
            }
        });
    }

    public void imageProcessingFinished(final AlbumBeanEvent e) {
        if (this.finished) {
            return;
        }
        if (this.abort) {
            e.abortProcessing();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int processedImages = e.processedFiles;
                if (JProgressDialog.this.progressBar.getValue() < processedImages) {
                    if (!JProgressDialog.this.progressBar.isIndeterminate()) {
                        JProgressDialog.this.progressBar.setValue(processedImages);
                        JProgressDialog.this.progressBar.setMaximum(e.totalFiles);
                        JProgressDialog.this.progressBar.setStringPainted(true);
                        JProgressDialog.this.progressBar.setString(Msg.get("progress.processingInfo2", processedImages, e.totalFiles));
                    }
                    if (processedImages < e.totalFiles) {
                        long elapsed = JProgressDialog.this.timer.getMillis();
                        long totalMillis = (long)e.totalFiles * elapsed / (long)processedImages;
                        int secsLeft = (int)(totalMillis - elapsed) / 1000;
                        JProgressDialog.this.timeInfo.setText(Msg.get("progress.estimatedTimeLeftInfo") + " " + JProgressDialog.timerFormat(secsLeft));
                    }
                }
            }
        });
    }

    void setDialogToFinishedState() {
        JProgressDialog theDialog = this;
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(this.progressBar.getMaximum());
        this.progressBar.setString(Msg.get("progress.processingInfo2", this.progressBar.getMaximum(), this.progressBar.getMaximum()));
        this.pauseButton.setEnabled(false);
        this.viewAlbumButton.setAction(this.getFrame().actions.viewAlbumAction);
        this.publishButton.setEnabled(true);
        this.openFolderButton.setEnabled(true);
        this.directory.setText(" ");
        this.file.setText(Msg.get("ui.albumGenerationDone"));
        this.timer.stop();
        long secsElapsed = this.timer.getMillis() / 1000L;
        this.timeInfo.setText(Msg.get("progress.timeElapsedInfo") + " " + JProgressDialog.timerFormat((int)secsElapsed));
        if (Platform.isMac()) {
            if (!theDialog.isFocused()) {
                theDialog.setVisible(false);
                theDialog.setVisible(true);
            }
        } else {
            theDialog.toFront();
            theDialog.requestFocusInWindow();
        }
    }

    public void errorOccured(Throwable t, File f) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abortPerformed(ActionEvent e) {
        Object object = this.engineMonitor;
        synchronized (object) {
            this.abort = true;
            this.updateStateAndSetVisible(false);
            if (!this.finished) {
                this.pauseButton.setSelected(false);
                this.engineMonitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void pauseButton_actionPerformed(ActionEvent e) {
        Object object = this.engineMonitor;
        synchronized (object) {
            if (this.pauseButton.isSelected()) {
                this.timer.stop();
            } else {
                this.timer.start();
                this.engineMonitor.notifyAll();
            }
        }
    }

    public void setIndeterminate(boolean b) {
        this.progressBar.setIndeterminate(b);
    }

    private JAlbumFrame getFrame() {
        return JAlbumContext.getInstance().getFrame();
    }

    public void updateStateAndSetVisible(boolean visible) {
        if (visible) {
            this.pauseButton.setSelected(false);
            this.pauseButton.setEnabled(true);
            this.publishButton.setEnabled(false);
            this.openFolderButton.setEnabled(false);
            this.directory.setText(" ");
            this.file.setText(" ");
            this.timeInfo.setText(" ");
            this.progressBar.setValue(0);
            this.progressBar.setString("");
            this.timer.reset();
            this.abort = false;
            this.finished = false;
            this.abortButton.setToolTipText(Msg.get("close"));
            this.buttonPanel.invalidate();
            this.pack();
            this.setVisible(visible);
        } else {
            this.setVisible(visible);
        }
    }

    void this_windowClosing(WindowEvent e) {
        if (!this.finished) {
            this.abort = true;
        }
    }
}

