/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.awt.Point;
import java.awt.dnd.DropTargetContext;
import java.io.File;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import se.datadosen.dnd.AbstractTreeTransferHandler;
import se.datadosen.jalbum.JPublishWizard;
import se.datadosen.jalbum.RemoteFSNode;
import se.datadosen.jalbum.UploadBean;
import se.datadosen.util.IO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteFSTreeTransferHandler
extends AbstractTreeTransferHandler {
    private UploadBean uploadBean;
    private JPublishWizard publishWizard;

    public RemoteFSTreeTransferHandler(JTree tree, JPublishWizard publishWizard, UploadBean uploadBean, int action) {
        super(tree, action, true);
        this.publishWizard = publishWizard;
        this.uploadBean = uploadBean;
    }

    @Override
    public boolean canDropNode(DropTargetContext dtc, DefaultMutableTreeNode draggedNode, int action, Point location) {
        TreePath pathTarget = this.tree.getPathForLocation(location.x, location.y);
        if (pathTarget == null) {
            this.tree.setSelectionPath(null);
            return false;
        }
        RemoteFSNode targetNode = (RemoteFSNode)pathTarget.getLastPathComponent();
        if (targetNode.isLeaf()) {
            return false;
        }
        this.tree.setSelectionPath(pathTarget);
        if (action == 2) {
            RemoteFSNode parentNode = (RemoteFSNode)pathTarget.getLastPathComponent();
            return !targetNode.isAlbum() && !draggedNode.isRoot() && parentNode != draggedNode.getParent() && !draggedNode.isNodeDescendant(parentNode);
        }
        return false;
    }

    @Override
    public boolean executeDrop(DefaultMutableTreeNode dragged, DefaultMutableTreeNode newParent, int action) {
        RemoteFSNode draggedNode = (RemoteFSNode)dragged;
        RemoteFSNode newParentNode = (RemoteFSNode)newParent;
        if (action == 2) {
            String from = draggedNode.remotePath();
            String to = IO.combinePaths(newParentNode.remotePath(), draggedNode.getRemoteName());
            try {
                this.uploadBean.getRemoteFS().rename(from, to);
                JPublishWizard.PublishStep publishStep = this.publishWizard.publishStep;
                if (publishStep.notifier != null) {
                    publishStep.notifier.albumMovedBg(this.publishWizard.currentAccount, publishStep.getUrl(from), publishStep.getUrl(to));
                }
                draggedNode.removeFromParent();
                if (newParentNode.areChildrenDefined()) {
                    ((DefaultTreeModel)this.tree.getModel()).insertNodeInto(draggedNode, newParentNode, newParentNode.getChildCount());
                }
                TreePath treePath = new TreePath(draggedNode.getPath());
                this.tree.scrollPathToVisible(treePath);
                this.tree.setSelectionPath(treePath);
                return true;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public int filesDragged(DropTargetContext dtc, int action, Point location) {
        TreePath pathTarget = this.tree.getPathForLocation(location.x, location.y);
        if (pathTarget == null) {
            this.tree.setSelectionPath(null);
            return 0;
        }
        RemoteFSNode targetNode = (RemoteFSNode)pathTarget.getLastPathComponent();
        if (targetNode.isLeaf()) {
            return 0;
        }
        this.tree.setSelectionPath(pathTarget);
        return 1;
    }

    @Override
    public boolean executeDrop(List<File> droppedFiles, DefaultMutableTreeNode newParentNode, int action) {
        this.publishWizard.publishStep.doUploadFiles(droppedFiles);
        return true;
    }

    @Override
    public boolean executeAlbumObjectDrop(DefaultMutableTreeNode newParentNode, int action) {
        throw new UnsupportedOperationException("TODO: Implement me!");
    }
}

