/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.util;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class WindowUtilities {
    public static boolean setApplicationModalExclusion(JFrame frmMain) {
        try {
            Class<?> exclusionType = Class.forName("java.awt.Dialog$ModalExclusionType");
            Field field = exclusionType.getField("APPLICATION_EXCLUDE");
            Object value = field.get(exclusionType);
            Method meth = JFrame.class.getMethod("setModalExclusionType", exclusionType);
            meth.invoke((Object)frmMain, value);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void setDefaultFocus(Component c) {
        c.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                final Component c = e.getComponent();
                if (c.isShowing() && (e.getChangeFlags() & 4L) != 0L) {
                    Window toplevel = SwingUtilities.getWindowAncestor(c);
                    toplevel.addComponentListener(new ComponentAdapter(){

                        public void componentShown(ComponentEvent e) {
                            c.requestFocusInWindow();
                        }
                    });
                }
            }
        });
    }
}

