/*
 * Decompiled with CFR 0.152.
 */
package nl.tomcee.skinprops;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import net.miginfocom.swing.MigLayout;
import se.datadosen.jalbum.Frog;
import se.datadosen.jalbum.JAlbumContext;
import se.datadosen.jalbum.SkinProperties;
import se.datadosen.util.JComponentHolder;
import se.datadosen.util.ManagesImport;
import se.datadosen.util.PropertyBinder;

public class SkinPropsEditor
extends JFrame {
    static final String APP_NAME = "Skin Properties Editor";
    static final String VERSION = "2.0";
    static final String AUTHOR = "Tom and David";
    final String SIMPLE_NAME = this.getClass().getSimpleName();
    private JAlbumContext context = JAlbumContext.getInstance();
    private String skin = this.context.getSkinDir().getName();
    private String accountProfileName = this.context.getEngine().getAccountProfileName();
    private SkinProperties skinProperties = this.context.getEngine().getSkinProperties();
    private Date currentDate = new Date();
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private DefaultFormatterFactory dff = new DefaultFormatterFactory(new DateFormatter(this.formatter));
    private String now = this.formatter.format(this.currentDate);
    JContentPanel contentPanel = new JContentPanel();

    private JMenuBar buildMenu() {
        JMenuBar menubar = new JMenuBar();
        JMenuItem aboutMenuItem = new JMenuItem("About");
        aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                new Frog().ribbit();
                String aboutText = "<html><b>Skin Properties Editor<br>version: 2.0<br>author: Tom and David</b></html>";
                JOptionPane.showMessageDialog(SkinPropsEditor.this.rootPane, aboutText, "About: " + SkinPropsEditor.this.SIMPLE_NAME, 1, new ImageIcon(this.getClass().getResource("tclogo.gif")));
            }
        });
        menubar.add(aboutMenuItem);
        return menubar;
    }

    private void getSkinProps() {
        PropertyBinder.syncUI((Map)this.skinProperties.getProperties(), (JComponentHolder)this.contentPanel);
    }

    private void saveSkinProps() {
        PropertyBinder.getProperties((JComponentHolder)this.contentPanel, (Map)this.skinProperties.getProperties());
        try {
            this.skinProperties.save();
            System.out.println(new Date() + " skin.properties saved succesfully.");
        }
        catch (IOException ex) {
            System.out.println(ex + " - failed to write skin.properties");
        }
    }

    public SkinPropsEditor() {
        this.setTitle(this.skin + " - " + APP_NAME);
        this.setIconImage(new ImageIcon(this.getClass().getResource("tclogo.gif")).getImage());
        this.setLocationByPlatform(true);
        this.setDefaultCloseOperation(2);
        this.setJMenuBar(this.buildMenu());
        this.getSkinProps();
        this.getContentPane().add(this.contentPanel);
        this.pack();
        this.setVisible(true);
        this.contentPanel.description.setCaretPosition(0);
        this.contentPanel.cancelButton.requestFocusInWindow();
    }

    static /* synthetic */ DefaultFormatterFactory access$000(SkinPropsEditor x0) {
        return x0.dff;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class JContentPanel
    extends JPanel
    implements JComponentHolder,
    ManagesImport {
        public JTextField title = new JTextField("", 40);
        public JTextField supportForum = new JTextField("", 40);
        public JTextField author = new JTextField("", 40);
        public JCheckBox autoWidgetInjection = new JCheckBox();
        public JCheckBox compatibilityMode = new JCheckBox();
        public JCheckBox fullSiteSupport = new JCheckBox();
        public JCheckBox fullVideoSupport = new JCheckBox();
        public JTextField company = new JTextField("", 40);
        public JTextArea description = new JTextArea(){
            {
                this.setRows(5);
                this.setColumns(40);
                this.setLineWrap(true);
                this.setWrapStyleWord(true);
                this.setFont(new Font("Tahoma", 0, 11));
            }
        };
        public JScrollPane spDescription = new JScrollPane(){
            {
                this.setViewportView(JContentPanel.this.description);
            }
        };
        public JTextField homePage = new JTextField("", 40);
        public JTextField requiredJalbumVersion = new JTextField("", 40);
        public JTextField requiredJavaVersion = new JTextField("", 40);
        public JTextField username = new JTextField("", 40);
        public JTextField version = new JTextField("", 40);
        public JFormattedTextField creationDate = new JFormattedTextField(SkinPropsEditor.access$000(SkinPropsEditor.this));
        public JFormattedTextField lastModifiedDate = new JFormattedTextField(SkinPropsEditor.access$000(SkinPropsEditor.this));
        private JButton saveButton = new JButton("Save"){
            {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        SkinPropsEditor.this.saveSkinProps();
                        SkinPropsEditor.this.dispose();
                    }
                });
            }
        };
        private JButton cancelButton = new JButton("Cancel"){
            {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        SkinPropsEditor.this.dispose();
                    }
                });
            }
        };
        private JButton nowButton = new JButton("now!"){
            {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        JContentPanel.this.lastModifiedDate.setText(SkinPropsEditor.this.now);
                    }
                });
                this.addMouseListener(new MouseAdapter(){

                    public void mouseEntered(MouseEvent evt) {
                        this.setText(SkinPropsEditor.this.now);
                    }

                    public void mouseExited(MouseEvent evt) {
                        this.setText("now!");
                    }
                });
            }
        };

        public JContentPanel() {
            this.setLayout((LayoutManager)new MigLayout("wrap 2"));
            this.add(new JLabel("title"));
            this.add(this.title);
            this.add(new JLabel("version"));
            this.add(this.version);
            this.add(new JLabel("author"));
            this.add(this.author);
            this.add(new JLabel("creationDate"));
            this.add((Component)this.creationDate, "split 2");
            this.add(new JLabel("(YYYY-MM-DD)"));
            this.add(new JLabel("lastModifiedDate"));
            this.add((Component)this.lastModifiedDate, "split 3");
            this.add(new JLabel("(YYYY-MM-DD)"));
            this.add(this.nowButton);
            this.add(new JLabel("autoWidgetInjection"));
            this.add(this.autoWidgetInjection);
            this.add(new JLabel("compatibilityMode"));
            this.add(this.compatibilityMode);
            this.add(new JLabel("fullSiteSupport"));
            this.add(this.fullSiteSupport);
            this.add(new JLabel("fullVideoSupport"));
            this.add(this.fullVideoSupport);
            this.add(new JLabel("requiredJalbumVersion"));
            this.add(this.requiredJalbumVersion);
            this.add(new JLabel("requiredJavaVersion"));
            this.add(this.requiredJavaVersion);
            this.add(new JLabel("company"));
            this.add(this.company);
            this.add(new JLabel("username"));
            this.add(this.username);
            this.add(new JLabel("homePage"));
            this.add(this.homePage);
            this.add(new JLabel("supportForum"));
            this.add(this.supportForum);
            this.add(new JLabel("description"));
            this.add(this.spDescription);
            this.add((Component)this.saveButton, "cell 1 13, split 2, align right");
            this.add(this.cancelButton);
        }

        public void importVariables(Map<String, Object> skinVariables) {
            if (!skinVariables.containsKey("title")) {
                skinVariables.put("title", SkinPropsEditor.this.skin);
            }
            if (!skinVariables.containsKey("creationDate")) {
                skinVariables.put("creationDate", SkinPropsEditor.this.now);
            }
            if (!skinVariables.containsKey("lastModifiedDate")) {
                skinVariables.put("lastModifiedDate", SkinPropsEditor.this.now);
            }
            if (!skinVariables.containsKey("username") && !SkinPropsEditor.this.accountProfileName.equals("")) {
                skinVariables.put("username", SkinPropsEditor.this.accountProfileName.substring(SkinPropsEditor.this.accountProfileName.lastIndexOf("- ") + 2));
            }
            if (!skinVariables.containsKey("requiredJavaVersion")) {
                skinVariables.put("requiredJavaVersion", "1.5");
            }
        }
    }
}

