/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.jalbum.filterManager.FilterProperties;
import net.jalbum.filters.BasicFilter;
import net.jalbum.filters.ColorAdjustmentControl;
import se.datadosen.jalbum.Msg;

public class ColorAdjustmentFilterPlugin
extends BasicFilter {
    private static final long serialVersionUID = -7171960078871425785L;
    protected double brightness = 1.0;
    protected double contrast = 1.0;
    protected double saturation = 1.0;
    protected boolean absoluteBrightness = true;
    protected ColorAdjustmentControl colorAdjustmentControl;

    public ColorAdjustmentFilterPlugin() {
        this.name = Msg.getString((Object)this, (String)"filters.colorAdjustment.name");
        this.shortName = Msg.getString((Object)this, (String)"filters.colorAdjustment.shortName");
        this.icon = new ImageIcon(this.getClass().getResource("res/color.png"));
        this.author = "David Fichtmueller";
        this.version = "1.0";
        this.description = Msg.getString((Object)this, (String)"filters.colorAdjustment.description");
        this.category = FilterProperties.FilterCategory.ADVANCED;
        this.prescale = false;
        this.postscale = true;
        this.colorAdjustmentControl = new ColorAdjustmentControl(this);
    }

    protected BufferedImage cloneBufferedImage(BufferedImage bi) {
        return bi;
    }

    public BufferedImage renderImage(BufferedImage bi) {
        int w = bi.getWidth();
        int h = bi.getHeight();
        BufferedImage out = new BufferedImage(w, h, bi.getType());
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int rgb = bi.getRGB(x, y);
                int alpha = (int)(((long)rgb & 0xFF000000L) >> 24);
                int r = (rgb & 0xFF0000) >> 16;
                int g = (rgb & 0xFF00) >> 8;
                int b = rgb & 0xFF;
                if (this.absoluteBrightness) {
                    r += (int)(2.55 * this.brightness);
                    g += (int)(2.55 * this.brightness);
                    b += (int)(2.55 * this.brightness);
                } else {
                    r = (int)((double)r * this.brightness);
                    g = (int)((double)g * this.brightness);
                    b = (int)((double)b * this.brightness);
                }
                double Y = (double)r * 0.299 + (double)g * 0.587 + (double)b * 0.114;
                double Cb = (double)r * -0.168736 + (double)g * -0.331264 + (double)b * 0.5;
                double Cr = (double)r * 0.5 + (double)g * -0.418688 + (double)b * -0.081312;
                Cb *= this.saturation;
                Cr *= this.saturation;
                Y = (Y - 127.0) * this.contrast + 127.0;
                r = (int)(Y + (Cr *= this.contrast) * 1.402);
                g = (int)(Y + (Cb *= this.contrast) * -0.344136 + Cr * -0.714136);
                b = (int)(Y + Cb * 1.772);
                if (alpha > 255) {
                    alpha = 255;
                } else if (alpha < 0) {
                    alpha = 0;
                }
                if (g > 255) {
                    g = 255;
                } else if (g < 0) {
                    g = 0;
                }
                if (r > 255) {
                    r = 255;
                } else if (r < 0) {
                    r = 0;
                }
                if (b > 255) {
                    b = 255;
                } else if (b < 0) {
                    b = 0;
                }
                rgb = (alpha & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
                out.setRGB(x, y, rgb);
            }
        }
        return out;
    }

    public void adjustContrast(int contrast) {
        double gamma = 0.25;
        this.contrast = contrast > 0 ? 100.0 * Math.pow(contrast - 1, 4.0) / Math.pow(100.0, 4.0) + 1.0 : (contrast == 0 ? 1.0 : 1.0 / (100.0 * Math.pow(-contrast + 1, 4.0) / Math.pow(100.0, 4.0) + 1.0));
        this.renderImage();
    }

    public void adjustBrightness(int brightness) {
        double gamma = 0.25;
        this.brightness = this.absoluteBrightness ? (double)brightness : (brightness > 0 ? 100.0 * Math.pow(brightness, 4.0) / Math.pow(100.0, 4.0) + 1.0 : (brightness == 0 ? 1.0 : 1.0 / (100.0 * Math.pow(-brightness, 4.0) / Math.pow(100.0, 4.0) + 1.0)));
        this.renderImage();
    }

    public void adjustSaturation(int saturation) {
        double gamma = 0.25;
        this.saturation = saturation > 0 ? 100.0 * Math.pow(saturation - 1, 4.0) / Math.pow(100.0, 4.0) + 1.0 : (saturation == 0 ? 1.0 : 1.0 / (100.0 * Math.pow(-saturation + 1, 4.0) / Math.pow(100.0, 4.0) + 1.0));
        this.renderImage();
    }

    public JPanel getControls() {
        return this.colorAdjustmentControl;
    }

    public double getContrast() {
        return this.contrast;
    }

    public void setContrast(double contrast) {
        this.contrast = contrast;
    }

    public double getBrightness() {
        return this.brightness;
    }

    public void setBrightness(double brightness) {
        this.brightness = brightness;
    }

    public double getSaturation() {
        return this.saturation;
    }

    public void setSaturation(double saturation) {
        this.saturation = saturation;
    }

    public boolean isAbsoluteBrightness() {
        return this.absoluteBrightness;
    }

    public void setAbsoluteBrightness(boolean absoluteBrightness) {
        this.absoluteBrightness = absoluteBrightness;
    }
}

