/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import net.jalbum.filters.FilterControl;
import net.jalbum.filters.GammaFilterPlugin;
import net.jalbum.filters.components.GammaSlider;
import se.datadosen.jalbum.Msg;

public class GammaControl
extends FilterControl {
    private static final long serialVersionUID = 2472355637938881568L;
    protected GammaFilterPlugin gammaFilterPlugin;
    protected GammaSlider sliderAll;
    protected GammaSlider sliderRed;
    protected GammaSlider sliderGreen;
    protected GammaSlider sliderBlue;
    protected JLabel labelRed;
    protected JLabel labelGreen;
    protected JLabel labelBlue;
    protected JButton resetAll;
    protected JCheckBox individualSettings;
    protected double gammaValueAll = 1.0;
    protected double gammaValueRed = 1.0;
    protected double gammaValueGreen = 1.0;
    protected double gammaValueBlue = 1.0;

    public GammaControl() {
    }

    public GammaControl(GammaFilterPlugin gammaFilterPlugin) {
        this.init(gammaFilterPlugin);
        this.addGammaControls();
    }

    protected void addGammaControls() {
        this.sliderAll = new GammaSlider(0);
        this.sliderAll.getSlider().setPaintLabels(false);
        this.sliderAll.setSliderWidth(132);
        this.sliderAll.removeResetButton();
        this.sliderAll.addActionListener(this);
        this.sliderRed = new GammaSlider(0);
        this.sliderRed.getSlider().setPaintLabels(false);
        this.sliderRed.setSliderWidth(132);
        this.sliderRed.removeResetButton();
        this.sliderRed.setEnabled(false);
        this.sliderRed.addActionListener(this);
        this.sliderGreen = new GammaSlider(0);
        this.sliderGreen.getSlider().setPaintLabels(false);
        this.sliderGreen.setSliderWidth(132);
        this.sliderGreen.removeResetButton();
        this.sliderGreen.setEnabled(false);
        this.sliderGreen.addActionListener(this);
        this.sliderBlue = new GammaSlider(0);
        this.sliderBlue.getSlider().setPaintLabels(false);
        this.sliderBlue.setSliderWidth(132);
        this.sliderBlue.removeResetButton();
        this.sliderBlue.setEnabled(false);
        this.sliderBlue.addActionListener(this);
        this.labelRed = new JLabel(Msg.getString((Object)this, (String)"filters.gamma.gammaRed"));
        this.labelRed.setEnabled(false);
        this.labelGreen = new JLabel(Msg.getString((Object)this, (String)"filters.gamma.gammaGreen"));
        this.labelGreen.setEnabled(false);
        this.labelBlue = new JLabel(Msg.getString((Object)this, (String)"filters.gamma.gammaBlue"));
        this.labelBlue.setEnabled(false);
        this.individualSettings = new JCheckBox();
        this.individualSettings.addActionListener(this);
        this.resetAll = new JButton(Msg.getString((Object)this, (String)"filters.colorAdjustment.resetAll"));
        this.resetAll.addActionListener(this);
        this.add(new JLabel(Msg.getString((Object)this, (String)"filters.gamma.gammaAll")));
        this.add("br", this.sliderAll);
        this.add("br", this.individualSettings);
        this.add(new JLabel(Msg.getString((Object)this, (String)"filters.gamma.enable")));
        this.add("br", this.labelRed);
        this.add("br", this.sliderRed);
        this.add("br", this.labelGreen);
        this.add("br", this.sliderGreen);
        this.add("br", this.labelBlue);
        this.add("br", this.sliderBlue);
        this.add("br", this.resetAll);
    }

    protected void init(GammaFilterPlugin gammaFilterPlugin) {
        this.gammaFilterPlugin = gammaFilterPlugin;
        super.init(gammaFilterPlugin);
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.sliderAll) {
            this.gammaValueAll = this.sliderAll.getResultingGamma();
            this.gammaFilterPlugin.setGammaAlpha(this.gammaValueAll);
            if (!this.individualSettings.isSelected()) {
                this.gammaValueRed = this.gammaValueAll;
                this.gammaFilterPlugin.setGammaR(this.gammaValueRed);
                this.gammaValueGreen = this.gammaValueAll;
                this.gammaFilterPlugin.setGammaG(this.gammaValueGreen);
                this.gammaValueBlue = this.gammaValueAll;
                this.gammaFilterPlugin.setGammaB(this.gammaValueBlue);
            }
            this.gammaFilterPlugin.renderImage();
        } else if (e.getSource() == this.sliderRed) {
            this.gammaValueRed = this.sliderRed.getResultingGamma();
            this.gammaFilterPlugin.setGammaR(this.gammaValueRed);
            this.gammaFilterPlugin.renderImage();
        } else if (e.getSource() == this.sliderGreen) {
            this.gammaValueGreen = this.sliderGreen.getResultingGamma();
            this.gammaFilterPlugin.setGammaG(this.gammaValueGreen);
            this.gammaFilterPlugin.renderImage();
        } else if (e.getSource() == this.sliderBlue) {
            this.gammaValueBlue = this.sliderBlue.getResultingGamma();
            this.gammaFilterPlugin.setGammaB(this.gammaValueBlue);
            this.gammaFilterPlugin.renderImage();
        } else if (e.getSource() == this.individualSettings) {
            this.sliderRed.setEnabled(this.individualSettings.isSelected());
            this.sliderGreen.setEnabled(this.individualSettings.isSelected());
            this.sliderBlue.setEnabled(this.individualSettings.isSelected());
            this.labelRed.setEnabled(this.individualSettings.isSelected());
            this.labelGreen.setEnabled(this.individualSettings.isSelected());
            this.labelBlue.setEnabled(this.individualSettings.isSelected());
            if (!this.individualSettings.isSelected()) {
                this.gammaValueRed = this.gammaValueAll;
                this.gammaValueGreen = this.gammaValueAll;
                this.gammaValueBlue = this.gammaValueAll;
            } else {
                this.gammaValueRed = this.sliderRed.getResultingGamma();
                this.gammaValueGreen = this.sliderGreen.getResultingGamma();
                this.gammaValueBlue = this.sliderBlue.getResultingGamma();
            }
            this.gammaFilterPlugin.setGammaR(this.gammaValueRed);
            this.gammaFilterPlugin.setGammaG(this.gammaValueGreen);
            this.gammaFilterPlugin.setGammaB(this.gammaValueBlue);
            this.gammaFilterPlugin.renderImage();
        } else if (e.getSource() == this.resetAll) {
            this.sliderAll.reset();
            this.sliderRed.reset();
            this.sliderGreen.reset();
            this.sliderBlue.reset();
            this.sliderRed.setEnabled(false);
            this.sliderGreen.setEnabled(false);
            this.sliderBlue.setEnabled(false);
            this.labelRed.setEnabled(false);
            this.labelGreen.setEnabled(false);
            this.labelBlue.setEnabled(false);
            this.individualSettings.setSelected(false);
        }
    }
}

