/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.jalbum.filters.MultipleResizableBoxControl;
import net.jalbum.filters.ResizableObject;
import net.jalbum.filters.TextBox;
import net.jalbum.filters.TextFilterPlugin;
import se.datadosen.component.JCollapsiblePanel;
import se.datadosen.component.JColorSelector;
import se.datadosen.component.RiverLayout;
import se.datadosen.jalbum.Msg;

public class TextControl
extends MultipleResizableBoxControl
implements PropertyChangeListener {
    private static final long serialVersionUID = 2654787059978561742L;
    protected TextFilterPlugin textFilterPlugin;
    protected TextBox textBox;
    protected JTextArea textArea;
    protected JComboBox fonts;
    protected JTextField textSizeField;
    protected JCheckBox bold;
    protected JCheckBox italic;
    protected JButton textAlignLeft;
    protected JButton textAlignCenter;
    protected JButton textAlignRight;
    protected JColorSelector textColor;
    protected JLabel textColorText;
    protected JTextField transparency;
    protected JCheckBox watermark;
    protected JCheckBox shadow;
    protected JLabel shadowAngleText;
    protected JTextField shadowAngle;
    protected JLabel shadowAngleUnitText;
    protected JLabel shadowDistanceText;
    protected JTextField shadowDistance;
    protected JLabel shadowDistanceUnitText;
    protected JLabel shadowStrengthText;
    protected JTextField shadowStrength;
    protected JLabel shadowStrengthUnitText;
    protected JLabel shadowColorText;
    protected JScrollPane scrollText;
    protected JColorSelector shadowColor;
    protected JCollapsiblePanel shadowPanel;
    protected JCollapsiblePanel advancedPanel;

    public TextControl() {
    }

    public TextControl(TextFilterPlugin textFilterPlugin) {
        this.init(textFilterPlugin);
        this.addMultipleControls();
        this.addTextControls();
    }

    protected void init(TextFilterPlugin textFilterPlugin) {
        this.textFilterPlugin = textFilterPlugin;
        this.resizableObject = this.textBox;
        super.init(textFilterPlugin);
    }

    protected void addTextControls() {
        this.removeAll();
        this.add(this.removeButton);
        this.removeButton.setEnabled(false);
        this.fonts = new JComboBox();
        this.fonts.setPreferredSize(new Dimension(160, 25));
        this.fonts.setMaximumRowCount(20);
        this.fonts.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                Font f = label.getFont();
                label.setFont(new Font(value.toString(), 0, 14));
                label.setToolTipText(value.toString());
                return label;
            }
        });
        Thread fontAdderThread = new Thread("Font adder"){

            public void run() {
                for (String fontName : GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
                    TextControl.this.fonts.addItem(fontName);
                }
                TextControl.this.fonts.setSelectedItem("Arial");
                TextControl.this.fonts.addActionListener(TextControl.this);
            }
        };
        fontAdderThread.setDaemon(true);
        fontAdderThread.setPriority(1);
        fontAdderThread.start();
        this.textArea = new JTextArea(Msg.getString((Object)this, (String)"filters.text.welcomeText"));
        this.textArea.setLineWrap(false);
        this.textArea.setWrapStyleWord(false);
        this.scrollText = new JScrollPane(this.textArea);
        this.scrollText.setVerticalScrollBarPolicy(22);
        this.scrollText.setHorizontalScrollBarPolicy(30);
        this.scrollText.setPreferredSize(new Dimension(200, 100));
        this.textSizeField = new JTextField("12", 2);
        this.bold = new JCheckBox("<html><b>" + Msg.getString((Object)this, (String)"filters.text.bold") + "</b></html>");
        this.italic = new JCheckBox("<html><i>" + Msg.getString((Object)this, (String)"filters.text.italic") + "</i></html>");
        this.textAlignLeft = new JButton(new ImageIcon(this.getClass().getResource("res/align-left.png")));
        this.textAlignLeft.setPreferredSize(new Dimension(20, 23));
        this.textAlignCenter = new JButton(new ImageIcon(this.getClass().getResource("res/align-center.png")));
        this.textAlignCenter.setPreferredSize(new Dimension(20, 23));
        this.textAlignRight = new JButton(new ImageIcon(this.getClass().getResource("res/align-right.png")));
        this.textAlignRight.setPreferredSize(new Dimension(20, 23));
        this.textColor = new JColorSelector(Msg.getString((Object)this, (String)"filters.text.textColor"));
        this.textColorText = new JLabel(Msg.getString((Object)this, (String)"filters.text.textColor"));
        this.transparency = new JTextField("0", 2);
        this.watermark = new JCheckBox(Msg.getString((Object)this, (String)"filters.text.watermark"));
        this.advancedPanel = new JCollapsiblePanel(Msg.getString((Object)this, (String)"filters.text.advanced"));
        this.shadowPanel = new JCollapsiblePanel(Msg.getString((Object)this, (String)"filters.text.shadow"));
        this.shadow = new JCheckBox(Msg.getString((Object)this, (String)"filters.text.showShadow"));
        this.shadowAngle = new JTextField("0", 2);
        this.shadowAngleText = new JLabel(Msg.getString((Object)this, (String)"filters.text.shadowAngle"));
        this.shadowAngleUnitText = new JLabel("\u00b0");
        this.shadowDistance = new JTextField("5", 2);
        this.shadowDistanceText = new JLabel(Msg.getString((Object)this, (String)"filters.text.shadowDistance"));
        this.shadowDistanceUnitText = new JLabel("px");
        this.shadowStrength = new JTextField("100", 2);
        this.shadowStrengthText = new JLabel(Msg.getString((Object)this, (String)"filters.text.shadowStrength"));
        this.shadowStrengthUnitText = new JLabel("%");
        this.shadowColor = new JColorSelector(Msg.getString((Object)this, (String)"filters.text.shadowColor"));
        this.shadowColorText = new JLabel(Msg.getString((Object)this, (String)"filters.text.shadowColor"));
        this.textArea.addKeyListener(this);
        this.textSizeField.addActionListener(this);
        this.textSizeField.addKeyListener(this);
        this.bold.addActionListener(this);
        this.italic.addActionListener(this);
        this.textAlignLeft.addActionListener(this);
        this.textAlignCenter.addActionListener(this);
        this.textAlignRight.addActionListener(this);
        this.textColor.addPropertyChangeListener((PropertyChangeListener)this);
        this.transparency.addActionListener(this);
        this.transparency.addKeyListener(this);
        this.watermark.addActionListener(this);
        this.shadow.addActionListener(this);
        this.shadowAngle.addActionListener(this);
        this.shadowAngle.addKeyListener(this);
        this.shadowDistance.addActionListener(this);
        this.shadowDistance.addKeyListener(this);
        this.shadowStrength.addActionListener(this);
        this.shadowStrength.addKeyListener(this);
        this.shadowColor.addPropertyChangeListener((PropertyChangeListener)this);
        this.add("br", this.scrollText);
        this.add("br", new JLabel(Msg.getString((Object)this, (String)"filters.text.font")));
        this.add(this.fonts);
        this.add("br", new JLabel(Msg.getString((Object)this, (String)"filters.text.size")));
        this.add(this.textSizeField);
        this.add(this.bold);
        this.add(this.italic);
        this.add("br", this.textAlignLeft);
        this.add(this.textAlignCenter);
        this.add(this.textAlignRight);
        this.add(this.textColorText);
        this.add((Component)this.textColor);
        this.advancedPanel.getContentPanel().setLayout((LayoutManager)new RiverLayout());
        this.advancedPanel.getContentPanel().add(new JLabel(Msg.getString((Object)this, (String)"filters.text.transparency")));
        this.advancedPanel.getContentPanel().add(this.transparency);
        this.advancedPanel.getContentPanel().add(new JLabel("%"));
        this.advancedPanel.getContentPanel().add("br", this.watermark);
        this.shadowPanel.getContentPanel().setLayout((LayoutManager)new RiverLayout());
        this.shadowPanel.getContentPanel().add("br", this.shadow);
        this.shadowPanel.getContentPanel().add("br", this.shadowAngleText);
        this.shadowPanel.getContentPanel().add(this.shadowAngle);
        this.shadowPanel.getContentPanel().add(this.shadowAngleUnitText);
        this.shadowPanel.getContentPanel().add("br", this.shadowDistanceText);
        this.shadowPanel.getContentPanel().add(this.shadowDistance);
        this.shadowPanel.getContentPanel().add(this.shadowDistanceUnitText);
        this.shadowPanel.getContentPanel().add("br", this.shadowStrengthText);
        this.shadowPanel.getContentPanel().add(this.shadowStrength);
        this.shadowPanel.getContentPanel().add(this.shadowStrengthUnitText);
        this.shadowPanel.getContentPanel().add("br", this.shadowColorText);
        this.shadowPanel.getContentPanel().add((Component)this.shadowColor);
        this.add("br", (Component)this.advancedPanel);
        this.add("br", (Component)this.shadowPanel);
    }

    public void update(double x1, double y1, double boxWidth, double boxHeight) {
        this.X1 = x1;
        this.Y1 = y1;
        this.boxWidth = boxWidth;
        this.boxHeight = boxHeight;
    }

    public void actionPerformed(ActionEvent e) {
        block44: {
            super.actionPerformed(e);
            if (e.getSource() == this.fonts) {
                this.textBox.setFont((String)this.fonts.getSelectedItem());
            } else if (e.getSource() == this.textSizeField) {
                try {
                    int textSize = Integer.parseInt(this.textSizeField.getText());
                    this.textBox.setTextSize(textSize);
                }
                catch (Exception ex) {
                    this.textSizeField.setText(new Integer(this.textBox.getTextSize()).toString());
                }
            } else if (e.getSource() == this.bold) {
                this.textBox.setBold(this.bold.isSelected());
            } else if (e.getSource() == this.italic) {
                this.textBox.setItalic(this.italic.isSelected());
            } else if (e.getSource() == this.textAlignLeft) {
                this.textBox.setAlignment(0);
            } else if (e.getSource() == this.textAlignCenter) {
                this.textBox.setAlignment(1);
            } else if (e.getSource() == this.textAlignRight) {
                this.textBox.setAlignment(2);
            } else if (e.getSource() == this.transparency) {
                try {
                    int textTransparency = Integer.parseInt(this.transparency.getText());
                    if (textTransparency < 0) {
                        textTransparency = 0;
                    }
                    if (textTransparency > 100) {
                        textTransparency = 100;
                    }
                    if (this.watermark.isSelected()) {
                        this.textBox.setWatermarkStrength(255 - textTransparency * 255 / 100);
                    } else {
                        this.textBox.setTextStrength(255 - textTransparency * 255 / 100);
                    }
                    this.transparency.setText(new Integer(textTransparency).toString());
                }
                catch (Exception ex) {
                    if (this.watermark.isSelected()) {
                        this.transparency.setText(new Integer(100 - this.textBox.getWatermarkStrength() * 100 / 255).toString());
                        break block44;
                    }
                    this.transparency.setText(new Integer(100 - this.textBox.getTextStrength() * 100 / 255).toString());
                }
            } else if (e.getSource() == this.watermark) {
                this.textBox.setShowWatermark(this.watermark.isSelected());
                if (this.watermark.isSelected()) {
                    this.transparency.setText(new Integer(100 - this.textBox.getWatermarkStrength() * 100 / 255).toString());
                } else {
                    this.transparency.setText(new Integer(100 - this.textBox.getTextStrength() * 100 / 255).toString());
                }
                this.textColor.setEnabled(!this.watermark.isSelected());
                this.textColorText.setEnabled(!this.watermark.isSelected());
                this.shadow.setEnabled(!this.watermark.isSelected());
                this.changeShadow();
            } else if (e.getSource() == this.shadow) {
                this.textBox.setShowShadow(this.shadow.isSelected());
                this.changeShadow();
            } else if (e.getSource() == this.shadowAngle) {
                try {
                    int angle = Integer.parseInt(this.shadowAngle.getText());
                    this.textBox.setShadowAngle(angle);
                    this.shadowAngle.setText(new Integer(angle).toString());
                }
                catch (Exception ex) {
                    this.shadowAngle.setText(new Integer(this.textBox.getShadowAngle()).toString());
                }
            } else if (e.getSource() == this.shadowDistance) {
                try {
                    int distance = Integer.parseInt(this.shadowDistance.getText());
                    this.textBox.setShadowDistance(distance);
                    this.shadowDistance.setText(new Integer(distance).toString());
                }
                catch (Exception ex) {
                    this.shadowDistance.setText(new Integer(this.textBox.getShadowDistance()).toString());
                }
            } else if (e.getSource() == this.shadowStrength) {
                try {
                    int strength = Integer.parseInt(this.shadowStrength.getText());
                    if (strength < 0) {
                        strength = 0;
                    }
                    if (strength > 100) {
                        strength = 100;
                    }
                    this.textBox.setShadowStrength(strength * 255 / 100);
                    this.shadowStrength.setText(new Integer(strength).toString());
                }
                catch (Exception ex) {
                    this.shadowStrength.setText(new Integer(this.textBox.getShadowStrength() * 100 / 255).toString());
                }
            }
        }
        this.textFilterPlugin.renderPreview();
    }

    protected void changeShadow() {
        this.shadowAngle.setEnabled(!this.watermark.isSelected() && this.shadow.isSelected());
        this.shadowAngleText.setEnabled(!this.watermark.isSelected() && this.shadow.isSelected());
        this.shadowAngleUnitText.setEnabled(!this.watermark.isSelected() && this.shadow.isSelected());
        this.shadowDistance.setEnabled(!this.watermark.isSelected() && this.shadow.isSelected());
        this.shadowDistanceText.setEnabled(!this.watermark.isSelected() && this.shadow.isSelected());
        this.shadowDistanceUnitText.setEnabled(!this.watermark.isSelected() && this.shadow.isSelected());
        this.shadowStrength.setEnabled(!this.watermark.isSelected() && this.shadow.isSelected());
        this.shadowStrengthText.setEnabled(!this.watermark.isSelected() && this.shadow.isSelected());
        this.shadowStrengthUnitText.setEnabled(!this.watermark.isSelected() && this.shadow.isSelected());
        this.shadowColor.setEnabled(!this.watermark.isSelected() && this.shadow.isSelected());
        this.shadowColorText.setEnabled(!this.watermark.isSelected() && this.shadow.isSelected());
    }

    public TextBox getTextBox() {
        return this.textBox;
    }

    public void adjustTextBox(TextBox textBox) {
        this.adjustResizableObject(textBox);
    }

    public void setTextBox(TextBox textBox) {
        this.textBox = textBox;
    }

    public void adjustResizableObject(ResizableObject resizableObject) {
        this.textBox = (TextBox)resizableObject;
        this.fonts.setSelectedItem(this.textBox.getFont());
        this.textArea.setText(this.textBox.getText());
        this.textSizeField.setText(new Integer(this.textBox.getTextSize()).toString());
        this.bold.setSelected(this.textBox.isBold());
        this.italic.setSelected(this.textBox.isItalic());
        this.textColor.setColor(this.textBox.getTextColor());
        this.transparency.setText(new Integer(100 - this.textBox.getTextStrength() * 100 / 255).toString());
        this.watermark.setSelected(this.textBox.isShowWatermark());
        this.shadow.setSelected(this.textBox.isShowShadow());
        this.shadow.setEnabled(!this.watermark.isSelected());
        this.changeShadow();
        this.shadowAngle.setText(new Integer(this.textBox.getShadowAngle()).toString());
        this.shadowDistance.setText(new Integer(this.textBox.getShadowDistance()).toString());
        this.shadowStrength.setText(new Integer(this.textBox.getShadowStrength() * 100 / 255).toString());
        this.shadowColor.setColor(this.textBox.getShadowColor());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.textBox == null) {
            return;
        }
        if (evt.getSource() == this.textColor) {
            this.textBox.setTextColor(this.textColor.getColor());
        } else if (evt.getSource() == this.shadowColor) {
            this.textBox.setShadowColor(this.shadowColor.getColor());
        }
    }

    public void keyReleased(KeyEvent e) {
        block39: {
            if (e.getSource() == this.textArea) {
                this.textBox.setText(this.textArea.getText());
                this.textFilterPlugin.renderPreview();
            } else {
                if (e.getSource() == this.textSizeField) {
                    try {
                        int textSize = Integer.parseInt(this.textSizeField.getText());
                        if (textSize < 1) {
                            textSize = 1;
                        }
                        if (textSize == this.textBox.getTextSize()) break block39;
                        this.textBox.setTextSize(textSize);
                        this.textFilterPlugin.renderPreview();
                        if (!new Integer(textSize).toString().equals(this.textSizeField.getText())) {
                            this.textSizeField.setText(new Integer(textSize).toString());
                        }
                        break block39;
                    }
                    catch (Exception ex) {
                        if (!this.textSizeField.getText().equals("")) {
                            this.textSizeField.setText(new Integer(this.textBox.getTextSize()).toString());
                        }
                        break block39;
                    }
                }
                if (e.getSource() == this.transparency) {
                    try {
                        int textTransparency = Integer.parseInt(this.transparency.getText());
                        if (textTransparency < 0) {
                            textTransparency = 0;
                        }
                        if (textTransparency > 100) {
                            textTransparency = 100;
                        }
                        if (this.watermark.isSelected()) {
                            if (textTransparency != Math.round(100.0f - (float)(this.textBox.getWatermarkStrength() * 100) / 255.0f)) {
                                this.textBox.setWatermarkStrength(255 - Math.round((float)(textTransparency * 255) / 100.0f));
                                this.textFilterPlugin.renderPreview();
                            }
                        } else if (textTransparency != Math.round(100.0f - (float)(this.textBox.getTextStrength() * 100) / 255.0f)) {
                            this.textBox.setTextStrength(255 - Math.round((float)(textTransparency * 255) / 100.0f));
                            this.textFilterPlugin.renderPreview();
                        }
                        if (!new Integer(textTransparency).toString().equals(this.transparency.getText())) {
                            this.transparency.setText(new Integer(textTransparency).toString());
                        }
                    }
                    catch (Exception ex) {
                        if (this.transparency.getText().equals("")) break block39;
                        if (this.watermark.isSelected()) {
                            this.transparency.setText(new Integer(100 - this.textBox.getWatermarkStrength() * 100 / 255).toString());
                            break block39;
                        }
                        this.transparency.setText(new Integer(100 - this.textBox.getTextStrength() * 100 / 255).toString());
                    }
                } else {
                    if (e.getSource() == this.shadowAngle && !this.shadowAngle.getText().equals("")) {
                        try {
                            int angle = Integer.parseInt(this.shadowAngle.getText());
                            if (angle < -360 || angle > 360) {
                                angle %= 360;
                            }
                            if (angle == this.textBox.getShadowAngle()) break block39;
                            this.textBox.setShadowAngle(angle);
                            this.textFilterPlugin.renderPreview();
                            if (!new Integer(angle).toString().equals(this.shadowAngle.getText())) {
                                this.shadowAngle.setText(new Integer(angle).toString());
                            }
                            break block39;
                        }
                        catch (Exception ex) {
                            if (!this.shadowAngle.getText().equals("")) {
                                this.shadowAngle.setText(new Integer(this.textBox.getShadowAngle()).toString());
                            }
                            break block39;
                        }
                    }
                    if (e.getSource() == this.shadowDistance && !this.shadowDistance.getText().equals("")) {
                        try {
                            int distance = Integer.parseInt(this.shadowDistance.getText());
                            if (distance < 0) {
                                distance = 0;
                            }
                            if (distance == this.textBox.getShadowDistance()) break block39;
                            this.textBox.setShadowDistance(distance);
                            this.textFilterPlugin.renderPreview();
                            if (!new Integer(distance).toString().equals(this.shadowDistance.getText())) {
                                this.shadowDistance.setText(new Integer(distance).toString());
                            }
                            break block39;
                        }
                        catch (Exception ex) {
                            if (!this.shadowDistance.getText().equals("")) {
                                this.shadowDistance.setText(new Integer(this.textBox.getShadowDistance()).toString());
                            }
                            break block39;
                        }
                    }
                    if (e.getSource() == this.shadowStrength && !this.shadowStrength.getText().equals("")) {
                        try {
                            int strength = Integer.parseInt(this.shadowStrength.getText());
                            if (strength < 0) {
                                strength = 0;
                            }
                            if (strength > 100) {
                                strength = 100;
                            }
                            if (strength != Math.round((float)(this.textBox.getShadowStrength() * 100) / 255.0f)) {
                                this.textBox.setShadowStrength(Math.round((float)(strength * 255) / 100.0f));
                                this.textFilterPlugin.renderPreview();
                                if (!new Integer(strength).toString().equals(this.shadowStrength.getText())) {
                                    this.shadowStrength.setText(new Integer(strength).toString());
                                }
                            }
                        }
                        catch (Exception ex) {
                            if (this.shadowStrength.getText().equals("")) break block39;
                            this.shadowStrength.setText(new Integer(this.textBox.getShadowStrength() * 100 / 255).toString());
                        }
                    }
                }
            }
        }
    }

    public void dispose() {
        this.fonts = null;
    }

    public TextFilterPlugin getTextPanel() {
        return this.textFilterPlugin;
    }

    public void setTextPanel(TextFilterPlugin textFilterPlugin) {
        this.textFilterPlugin = textFilterPlugin;
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public void setTextArea(JTextArea textArea) {
        this.textArea = textArea;
    }

    public JComboBox getFonts() {
        return this.fonts;
    }

    public void setFonts(JComboBox fonts) {
        this.fonts = fonts;
    }

    public JTextField getTextSizeField() {
        return this.textSizeField;
    }

    public void setTextSizeField(JTextField size) {
        this.textSizeField = size;
    }

    public JCheckBox getBold() {
        return this.bold;
    }

    public void setBold(JCheckBox bold) {
        this.bold = bold;
    }

    public JCheckBox getItalic() {
        return this.italic;
    }

    public void setItalic(JCheckBox italic) {
        this.italic = italic;
    }

    public JColorSelector getTextColor() {
        return this.textColor;
    }

    public void setTextColor(JColorSelector textColor) {
        this.textColor = textColor;
    }

    public JLabel getTextColorText() {
        return this.textColorText;
    }

    public void setTextColorText(JLabel textColorText) {
        this.textColorText = textColorText;
    }

    public JTextField getTransparency() {
        return this.transparency;
    }

    public void setTransparency(JTextField transparency) {
        this.transparency = transparency;
    }

    public JCheckBox getWatermark() {
        return this.watermark;
    }

    public void setWatermark(JCheckBox watermark) {
        this.watermark = watermark;
    }

    public JCheckBox getShadow() {
        return this.shadow;
    }

    public void setShadow(JCheckBox shadow) {
        this.shadow = shadow;
    }

    public JLabel getShadowAngleText() {
        return this.shadowAngleText;
    }

    public void setShadowAngleText(JLabel shadowAngleText) {
        this.shadowAngleText = shadowAngleText;
    }

    public JTextField getShadowAngle() {
        return this.shadowAngle;
    }

    public void setShadowAngle(JTextField shadowAngle) {
        this.shadowAngle = shadowAngle;
    }

    public JLabel getShadowAngleUnitText() {
        return this.shadowAngleUnitText;
    }

    public void setShadowAngleUnitText(JLabel shadowAngleUnitText) {
        this.shadowAngleUnitText = shadowAngleUnitText;
    }

    public JLabel getShadowDistanceText() {
        return this.shadowDistanceText;
    }

    public void setShadowDistanceText(JLabel shadowDistanceText) {
        this.shadowDistanceText = shadowDistanceText;
    }

    public JTextField getShadowDistance() {
        return this.shadowDistance;
    }

    public void setShadowDistance(JTextField shadowDistance) {
        this.shadowDistance = shadowDistance;
    }

    public JLabel getShadowDistanceUnitText() {
        return this.shadowDistanceUnitText;
    }

    public void setShadowDistanceUnitText(JLabel shadowDistanceUnitText) {
        this.shadowDistanceUnitText = shadowDistanceUnitText;
    }

    public JLabel getShadowStrengthText() {
        return this.shadowStrengthText;
    }

    public void setShadowStrengthText(JLabel shadowStrengthText) {
        this.shadowStrengthText = shadowStrengthText;
    }

    public JTextField getShadowStrength() {
        return this.shadowStrength;
    }

    public void setShadowStrength(JTextField shadowStrength) {
        this.shadowStrength = shadowStrength;
    }

    public JLabel getShadowStrengthUnitText() {
        return this.shadowStrengthUnitText;
    }

    public void setShadowStrengthUnitText(JLabel shadowStrengthUnitText) {
        this.shadowStrengthUnitText = shadowStrengthUnitText;
    }

    public JLabel getShadowColorText() {
        return this.shadowColorText;
    }

    public void setShadowColorText(JLabel shadowColorText) {
        this.shadowColorText = shadowColorText;
    }

    public JScrollPane getScrollText() {
        return this.scrollText;
    }

    public void setScrollText(JScrollPane scrollText) {
        this.scrollText = scrollText;
    }

    public JColorSelector getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(JColorSelector shadowColor) {
        this.shadowColor = shadowColor;
    }
}

