/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.resty.web.mime;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.jalbum.resty.web.AbstractContent;

public class MultipartContent
extends AbstractContent {
    private String subType;
    private List<AbstractContent> parts;
    private String boundary = "jb" + UUID.randomUUID().toString();

    public MultipartContent(String aSubtype, AbstractContent ... content) {
        this.subType = aSubtype;
        this.parts = new ArrayList<AbstractContent>(Arrays.asList(content));
    }

    protected void addContent(URLConnection con) throws IOException {
        con.setDoOutput(true);
        con.addRequestProperty("Content-Type", "multipart/" + this.subType + "; boundary=" + this.boundary);
        OutputStream os = con.getOutputStream();
        this.writeContent(os);
        os.close();
    }

    public void writeContent(OutputStream os) throws IOException {
        if (this.parts.isEmpty()) {
            return;
        }
        for (AbstractContent c : this.parts) {
            os.write(this.ascii("--"));
            os.write(this.ascii(this.boundary));
            os.write(CRLF);
            c.writeHeader(os);
            os.write(CRLF);
            c.writeContent(os);
            os.write(CRLF);
        }
        os.write(this.ascii("--"));
        os.write(this.ascii(this.boundary));
        os.write(this.ascii("--"));
        os.write(CRLF);
    }

    public void writeHeader(OutputStream os) throws IOException {
        os.write(this.ascii("Content-Type: multipart/" + this.subType + "; boundary=" + this.boundary + "\r\n"));
    }
}

