/*
 * Decompiled with CFR 0.152.
 */
package module.aolim.ui;

import component.IcbmCore;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import main.Oscar;
import module.aolim.ui.ImAttribute;
import module.aolim.ui.SampleTextPanel;
import module.aolim.ui.UiBean;
import uiutil.ChangeListener;
import uiutil.ChoiceUI;
import uiutil.ColorSelector;
import uiutil.ColorSelectorListener;
import uiutil.IUtil;
import uiutil.ImageButton;
import uiutil.PropertySheet;
import uiutil.Spacer;
import uiutil.TransparentPanel;
import util.KeyBindings;

public class ImWindowProps
extends PropertySheet
implements ChangeListener,
ColorSelectorListener,
ActionListener,
ItemListener {
    private static final String MODULE = "ImWindowProps";
    private UiBean uibean;
    private ChangeListener changeListener;
    private boolean changed = false;
    private String[] colorButtonLabels = new String[]{"Foreground", "Background", "My Name", "My Buddy's Name", "IM Background"};
    private ImageButton[] colorButtons = new ImageButton[this.colorButtonLabels.length];
    private Choice fontName = new Choice();
    private Choice fontStyle = new Choice();
    private Choice fontSize = new Choice();
    private SampleTextPanel rightPanel;
    private int[] fontStyleArray = new int[]{0, 2, 1, 3};
    private ImAttribute attribute;

    public ImWindowProps(UiBean uiBean, ChangeListener changeListener) {
        TransparentPanel transparentPanel;
        this.uibean = uiBean;
        this.attribute = uiBean.getImAttribute();
        this.changeListener = changeListener;
        ((Component)((Object)this)).setBackground(Oscar.backgroundColor);
        ((Container)((Object)this)).setLayout(new BorderLayout());
        TransparentPanel transparentPanel2 = new TransparentPanel();
        ((Container)((Object)this)).add("Center", (Component)transparentPanel2);
        ((Container)((Object)this)).add("North", (Component)new Spacer());
        ((Container)((Object)this)).add("West", (Component)new Spacer());
        ((Container)((Object)this)).add("East", (Component)new Spacer());
        transparentPanel2.setLayout(new GridLayout(1, 2, 0, 0));
        TransparentPanel transparentPanel3 = new TransparentPanel();
        transparentPanel3.setLayout(new GridLayout(2, 1, 0, 20));
        this.rightPanel = new SampleTextPanel(this);
        TransparentPanel transparentPanel4 = new TransparentPanel();
        transparentPanel4.setLayout(new GridLayout(3, 1, 0, 0));
        transparentPanel4.add(new Label("Message Colors:"));
        int n = 0;
        while (n < 2) {
            transparentPanel = new TransparentPanel();
            transparentPanel.setLayout(new FlowLayout(0));
            this.colorButtons[n] = new ImageButton(12, 12);
            transparentPanel.add((Component)this.colorButtons[n]);
            this.colorButtons[n].addActionListener((ActionListener)this);
            transparentPanel.add(new Label(this.colorButtonLabels[n]));
            transparentPanel4.add((Component)transparentPanel);
            ++n;
        }
        transparentPanel3.add((Component)transparentPanel4);
        transparentPanel4 = new TransparentPanel();
        transparentPanel4.setLayout(new GridLayout(3, 1, 0, 0));
        transparentPanel4.add(new Label("Names Colors:"));
        int n2 = 2;
        while (n2 < 4) {
            transparentPanel = new TransparentPanel();
            transparentPanel.setLayout(new FlowLayout(0));
            this.colorButtons[n2] = new ImageButton(12, 12);
            transparentPanel.add((Component)this.colorButtons[n2]);
            this.colorButtons[n2].addActionListener((ActionListener)this);
            transparentPanel.add(new Label(this.colorButtonLabels[n2]));
            transparentPanel4.add((Component)transparentPanel);
            ++n2;
        }
        transparentPanel3.add((Component)transparentPanel4);
        transparentPanel = new TransparentPanel();
        transparentPanel.setLayout(new BorderLayout());
        transparentPanel.add("West", (Component)new Spacer());
        transparentPanel.add("North", (Component)new Spacer());
        transparentPanel.add("East", (Component)new Spacer());
        transparentPanel4 = new TransparentPanel();
        transparentPanel4.setLayout(new GridLayout(3, 3, 30, 0));
        transparentPanel4.add(new Label("Font Name"));
        transparentPanel4.add(new Label("Font Style"));
        transparentPanel4.add(new Label("Font Size"));
        this.fontName = new Choice();
        transparentPanel4.add(this.fontName);
        this.fontStyle = new Choice();
        transparentPanel4.add(this.fontStyle);
        this.fontSize = new Choice();
        transparentPanel4.add(this.fontSize);
        this.fontName.addItemListener(this);
        this.fontStyle.addItemListener(this);
        this.fontSize.addItemListener(this);
        transparentPanel4.add((Component)new Spacer());
        transparentPanel.add("Center", (Component)transparentPanel4);
        ((Container)((Object)this)).add("South", (Component)transparentPanel);
        transparentPanel = new TransparentPanel();
        transparentPanel.setLayout(new FlowLayout(0));
        this.colorButtons[4] = new ImageButton(12, 12);
        transparentPanel.add((Component)this.colorButtons[4]);
        this.colorButtons[4].addActionListener((ActionListener)this);
        transparentPanel.add(new Label(this.colorButtonLabels[4]));
        transparentPanel2.add((Component)transparentPanel3);
        transparentPanel4 = new TransparentPanel();
        transparentPanel4.setLayout(new BorderLayout());
        transparentPanel4.add("North", new Label("Sample Text"));
        transparentPanel4.add("Center", this.rightPanel);
        transparentPanel4.add("South", (Component)transparentPanel);
        transparentPanel2.add((Component)transparentPanel4);
        this.setValues();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        itemEvent.getSource();
        this.setChanged(true);
        this.rightPanel.setFont(new Font(this.fontName.getSelectedItem(), this.fontStyleArray[this.fontStyle.getSelectedIndex()], Integer.parseInt(this.fontSize.getSelectedItem())));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        this.setChanged(true);
        int n = 0;
        while (n < this.colorButtons.length) {
            if (this.colorButtons[n] == object) {
                if (n == 0) {
                    new ColorSelector((ColorSelectorListener)this, object, String.valueOf(this.colorButtonLabels[0]) + " Color", this.colorButtons[0].getBackground(), this.colorButtons[1].getBackground(), true);
                    return;
                }
                if (n == 1 || n == 4) {
                    new ColorSelector((ColorSelectorListener)this, object, String.valueOf(this.colorButtonLabels[n]) + " Color", this.colorButtons[0].getBackground(), this.colorButtons[n].getBackground(), false);
                    return;
                }
                new ColorSelector((ColorSelectorListener)this, object, String.valueOf(this.colorButtonLabels[n]) + " Color", this.colorButtons[n].getBackground(), this.colorButtons[4].getBackground(), true);
                return;
            }
            ++n;
        }
    }

    public boolean changed() {
        return this.changed;
    }

    public boolean help() {
        ChoiceUI.newChoiceUI((String)"ImWindow Help", (String)"You can alter the appearances of the names of the sender and the receiver by changing the font or colors. To change the font, simply choose a new font characteristic (name, style, or size) in the choice boxes below the color buttons. Clicking on any of the color button brings up a color palette from which you can choose a color to apply to a text. In likewise manners, you can change the visual characteristics of the message you send.");
        return true;
    }

    public void removeNotify() {
        ((Container)((Object)this)).removeAll();
        this.uibean = null;
        this.changeListener = null;
        this.rightPanel = null;
        this.attribute = null;
        int n = 0;
        while (n < this.colorButtonLabels.length) {
            if (this.colorButtons[n] != null) {
                this.colorButtons[n].destroy();
                this.colorButtons[n] = null;
            }
            ++n;
        }
        this.colorButtons = null;
        super.removeNotify();
    }

    public boolean save() {
        KeyBindings keyBindings = Oscar.config.getKeyBindingsOrAdd(IcbmCore.IM_KEY);
        this.attribute.setSightAttribute(this.colorButtons[0].getBackground(), this.colorButtons[1].getBackground(), this.colorButtons[2].getBackground(), this.colorButtons[3].getBackground(), this.colorButtons[4].getBackground(), this.fontName.getSelectedItem(), this.fontStyleArray[this.fontStyle.getSelectedIndex()], Integer.parseInt(this.fontSize.getSelectedItem()));
        keyBindings.setValue(IcbmCore.FONT_NAME_KEY, this.fontName.getSelectedItem());
        keyBindings.setValue(IcbmCore.FONT_STYLE_KEY, this.fontStyle.getSelectedItem());
        keyBindings.setValue(IcbmCore.FONT_SIZE_KEY, this.fontSize.getSelectedItem());
        keyBindings.setValue(IcbmCore.FONT_FG_COLOR_KEY, IUtil.getStringFromColor((Color)this.colorButtons[0].getBackground()));
        keyBindings.setValue(IcbmCore.FONT_BG_COLOR_KEY, IUtil.getStringFromColor((Color)this.colorButtons[1].getBackground()));
        keyBindings.setValue(IcbmCore.LOCAL_NAME_COLOR_KEY, IUtil.getStringFromColor((Color)this.colorButtons[2].getBackground()));
        keyBindings.setValue(IcbmCore.REMOTE_NAME_COLOR_KEY, IUtil.getStringFromColor((Color)this.colorButtons[3].getBackground()));
        keyBindings.setValue(IcbmCore.WINDOW_COLOR_KEY, IUtil.getStringFromColor((Color)this.colorButtons[4].getBackground()));
        this.uibean.attributeChanged();
        this.setChanged(false);
        return true;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
        if (bl) {
            this.changeListener.setChanged(true);
        }
    }

    private final void setFontCharacteristics() {
        this.fontName.addItem("Helvetica");
        this.fontName.addItem("TimesRoman");
        this.fontName.addItem("Courier");
        this.fontName.addItem("Dialog");
        this.fontName.addItem("DialogInput");
        this.fontName.addItem("ZapfDingbats");
        this.fontName.addItem("default");
        this.fontStyle.addItem("Plain");
        this.fontStyle.addItem("Italic");
        this.fontStyle.addItem("Bold");
        this.fontStyle.addItem("Bold Italic");
        this.fontSize.addItem("8");
        this.fontSize.addItem("10");
        this.fontSize.addItem("12");
        this.fontSize.addItem("14");
        this.fontSize.addItem("18");
        this.fontSize.addItem("24");
        this.fontName.select(this.attribute.fontName);
        if (this.attribute.fontStyle == 2) {
            this.fontStyle.select(1);
        } else if (this.attribute.fontStyle == 1) {
            this.fontStyle.select(2);
        } else if (this.attribute.fontStyle == 3) {
            this.fontStyle.select(3);
        } else {
            this.fontStyle.select(0);
        }
        this.fontSize.select(String.valueOf(this.attribute.fontSize));
    }

    private final void setTextColors() {
        this.colorButtons[0].setBackground(this.attribute.textFgColor);
        this.colorButtons[1].setBackground(this.attribute.textBgColor);
        this.colorButtons[2].setBackground(this.attribute.myNameColor);
        this.colorButtons[3].setBackground(this.attribute.otherNameColor);
        this.colorButtons[4].setBackground(this.attribute.windowColor);
    }

    public void setValues() {
        this.setFontCharacteristics();
        this.setTextColors();
        this.rightPanel.setFont(new Font(this.attribute.fontName, this.attribute.fontStyle, this.attribute.fontSize));
        this.setChanged(false);
    }

    void colorChanged() {
        this.rightPanel.repaint();
    }

    Color[] getColors() {
        return new Color[]{this.colorButtons[0].getBackground(), this.colorButtons[1].getBackground(), this.colorButtons[2].getBackground(), this.colorButtons[3].getBackground(), this.colorButtons[4].getBackground()};
    }

    public void setColor(Object object, boolean bl, Color color) {
        ((Component)object).setBackground(color);
        this.colorChanged();
    }
}

