/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.User;
import java.util.Date;
import java.util.Vector;
import main.Nickname;
import main.Oscar;
import util.JUtil;
import util.KeyBindings;

class BuddyList {
    public static int UNCHANGED;
    public static int CREATED;
    public static int RENAMED;
    public static int DELETED;
    public static int UPDATED;
    public int change = CREATED;
    private String name;
    private String oldName;
    private User[] buddies;
    private int validBuddies;
    private boolean renamed = false;

    public BuddyList(String string) {
        this.name = string;
    }

    public BuddyList(String string, KeyBindings keyBindings) {
        int n = keyBindings.size();
        this.name = string;
        this.buddies = new User[n];
        int n2 = 0;
        while (n2 < n) {
            ++this.validBuddies;
            this.buddies[n2] = new User(keyBindings.getKeyAt(n2));
            this.buddies[n2].attributes = keyBindings.getValuesAt(n2);
            ++n2;
        }
    }

    public void addBuddies(User[] userArray) {
        if (userArray == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < userArray.length) {
            if (!this.buddyInList(userArray[n2].name)) {
                userArray[n2].markAdded();
                ++n;
            } else {
                userArray[n2].changed = false;
            }
            ++n2;
        }
        if (n > 0) {
            int n3 = this.buddies == null ? 0 : this.buddies.length;
            int n4 = n3 + n;
            User[] userArray2 = new User[n4];
            n2 = 0;
            while (n2 < n3) {
                userArray2[n2] = this.buddies[n2];
                ++n2;
            }
            int n5 = 0;
            while (n5 < userArray.length) {
                if (userArray[n5].changed) {
                    userArray2[n2++] = userArray[n5];
                }
                ++n5;
            }
            this.buddies = userArray2;
            this.validBuddies += n;
            this.change = UPDATED;
        }
    }

    public void buddiesArrived(Nickname[] nicknameArray, long l) {
        long l2 = new Date().getTime();
        if (this.buddies == null) {
            return;
        }
        int n = 0;
        while (n < this.buddies.length) {
            User user = this.buddies[n];
            int n2 = 0;
            while (n2 < nicknameArray.length) {
                Nickname nickname = nicknameArray[n2];
                if (user.name().equals(Nickname.normalize(nickname.nickname)) && user.status != 3) {
                    if (user.status == 2) {
                        user.logTime = l2 - user.logTime < l ? 0L : l2;
                    } else if (user.status == 0) {
                        user.logTime = l2;
                    }
                    user.signon = nickname.signonTOD;
                    user.name = nickname.nickname;
                    user.changed = true;
                    user.status = 1;
                    user.evil = nickname.evil;
                    user.idle = nickname.idleTime;
                    user.userClass = nickname.getClassCode();
                    user.memberSince = nickname.memberSince;
                    this.change = UPDATED;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void buddiesDeparted(Nickname[] nicknameArray, long l) {
        long l2 = new Date().getTime();
        int n = 0;
        while (n < nicknameArray.length) {
            int n2 = 0;
            while (n2 < this.buddies.length) {
                if (this.buddies[n2].name().equals(Nickname.normalize(nicknameArray[n].nickname))) {
                    if (nicknameArray[n].isOnline()) {
                        this.buddies[n2].userClass = nicknameArray[n].getClassCode();
                        this.buddies[n2].changed = true;
                    } else {
                        this.buddies[n2].logTime = l2;
                        this.buddies[n2].setStatus(0);
                        this.buddies[n2].changed = true;
                    }
                }
                ++n2;
            }
            ++n;
        }
        this.change = UPDATED;
    }

    private boolean buddyInList(String string) {
        boolean bl = false;
        if (this.buddies == null) {
            return bl;
        }
        int n = 0;
        while (n < this.buddies.length) {
            if (this.buddies[n].status != 3 && Nickname.normalize(string).equals(this.buddies[n].name())) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    public void clearChanges(long l) {
        long l2 = new Date().getTime();
        int n = 0;
        if (this.buddies != null) {
            int n2 = 0;
            while (n2 < this.buddies.length) {
                if (this.buddies[n2].status == 2 && l2 - this.buddies[n2].logTime >= l) {
                    this.buddies[n2].setStatus(0);
                    this.buddies[n2].logTime = 0L;
                } else if (this.buddies[n2].status == 3) {
                    ++n;
                }
                this.buddies[n2].changed = false;
                ++n2;
            }
            if (n > 0) {
                int n3 = this.buddies.length - n;
                User[] userArray = new User[n3];
                n2 = 0;
                int n4 = 0;
                while (n2 < this.buddies.length && n4 < n3) {
                    if (this.buddies[n2].status != 3) {
                        userArray[n4++] = this.buddies[n2];
                    }
                    ++n2;
                }
                this.buddies = userArray;
            }
        }
        this.change = UNCHANGED;
        this.oldName = this.name;
        this.renamed = false;
    }

    public void deleteBuddies(User[] userArray) {
        if (userArray == null) {
            return;
        }
        int n = 0;
        while (n < userArray.length) {
            User user = this.getBuddy(userArray[n].name());
            if (user != null) {
                user.markDeleted();
                --this.validBuddies;
                this.change = UPDATED;
            }
            ++n;
        }
    }

    public User[] getBuddies() {
        return this.buddies;
    }

    public int getBuddiesOnline() {
        int n = 0;
        if (this.buddies != null) {
            int n2 = 0;
            while (n2 < this.buddies.length) {
                if (this.buddies[n2].status == 1) {
                    ++n;
                }
                ++n2;
            }
        }
        return n;
    }

    public int getBuddiesTotal() {
        return this.validBuddies;
    }

    public User getBuddy(String string) {
        User user = null;
        if (this.buddies != null) {
            int n = 0;
            while (n < this.buddies.length) {
                if (this.buddies[n].name().equals(Nickname.normalize(string))) {
                    user = this.buddies[n];
                    break;
                }
                ++n;
            }
        }
        return user;
    }

    public String[] getBuddyNames() {
        String[] stringArray = null;
        if (this.buddies != null) {
            stringArray = new String[this.validBuddies];
            int n = 0;
            int n2 = 0;
            while (n2 < this.buddies.length && n < this.validBuddies) {
                if (this.buddies[n2].status != 3) {
                    stringArray[n++] = new String(this.buddies[n2].name);
                }
                ++n2;
            }
        }
        return stringArray;
    }

    public void initialize(long l) {
        if (this.buddies != null) {
            int n = 0;
            while (n < this.buddies.length) {
                this.buddies[n].logTime = l;
                this.buddies[n].status = 2;
                ++n;
            }
        }
    }

    public void initializeByClass(long l, Vector vector) {
        if (this.buddies != null && vector != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < this.buddies.length) {
                int n3 = 0;
                while (n3 < n) {
                    int n4 = (Integer)vector.elementAt(n3);
                    if (this.buddies[n2].userClass == n4 && this.buddies[n2].status == 0) {
                        this.buddies[n2].status = 2;
                        this.buddies[n2].logTime = l;
                        this.buddies[n2].changed = true;
                    }
                    ++n3;
                }
                ++n2;
            }
            this.change = UPDATED;
        }
    }

    public void makePermissionsUpdate(long l, Vector vector, int[] nArray) {
        if (this.buddies != null && vector != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < this.buddies.length) {
                int n3 = 0;
                while (n3 < n) {
                    String string = (String)vector.elementAt(n3);
                    if (this.buddies[n2].name().equals(Nickname.normalize(string))) {
                        if (JUtil.inArray(this.buddies[n2].userClass, nArray)) {
                            if (this.buddies[n2].status == 0) {
                                this.buddies[n2].status = 2;
                                this.buddies[n2].logTime = l;
                                this.buddies[n2].changed = true;
                            }
                        } else {
                            this.buddies[n2].status = 0;
                            this.buddies[n2].logTime = 0L;
                            this.buddies[n2].changed = true;
                        }
                    }
                    ++n3;
                }
                ++n2;
            }
            this.change = UPDATED;
        }
    }

    public void markAllBuddiesChanged() {
        if (this.buddies != null) {
            int n = 0;
            while (n < this.buddies.length) {
                this.buddies[n].changed = true;
                ++n;
            }
        }
    }

    public void markAllBuddiesOffline() {
        if (this.buddies != null) {
            int n = 0;
            while (n < this.buddies.length) {
                this.buddies[n].status = 0;
                this.buddies[n].logTime = 0L;
                this.buddies[n].changed = true;
                ++n;
            }
            this.change = UPDATED;
        }
    }

    public void markBuddiesOfflineByName(Vector vector) {
        if (this.buddies != null && vector != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < this.buddies.length) {
                int n3 = 0;
                while (n3 < n) {
                    String string = Nickname.normalize((String)vector.elementAt(n3));
                    if (this.buddies[n2].status != 3 && this.buddies[n2].name().equals(string) && !Nickname.normalize(Oscar.nickname).equals(string)) {
                        this.buddies[n2].status = 0;
                        this.buddies[n2].logTime = 0L;
                        this.buddies[n2].changed = true;
                    }
                    ++n3;
                }
                ++n2;
            }
            this.change = UPDATED;
        }
    }

    public String name() {
        return this.name;
    }

    public String oldName() {
        if (this.oldName == null) {
            return this.name;
        }
        return this.oldName;
    }

    public void rename(String string) {
        this.change = RENAMED;
        this.oldName = new String(this.name);
        this.name = string;
        this.renamed = true;
    }

    public boolean renamed() {
        return this.renamed;
    }

    public int size() {
        if (this.buddies == null) {
            return 0;
        }
        return this.buddies.length;
    }

    public KeyBindings toKeyBindings() {
        KeyBindings keyBindings = new KeyBindings(this.name);
        if (this.buddies != null) {
            int n = 0;
            while (n < this.buddies.length) {
                if (this.buddies[n].status != 3) {
                    keyBindings.setValues(this.buddies[n].name, this.buddies[n].attributes);
                }
                ++n;
            }
        }
        return keyBindings;
    }

    public String toString() {
        String string = new String(this.name);
        if (this.buddies != null) {
            int n = 0;
            while (n < this.buddies.length) {
                string = String.valueOf(string) + "\n  " + this.buddies[n];
                ++n;
            }
        }
        return string;
    }

    public void updateBuddyEvil(String string, int n) {
        User user = this.getBuddy(string);
        if (user != null) {
            user.evil = n;
            user.changed = true;
        }
    }

    public void updateBuddyInfo(Nickname nickname) {
        User user = this.getBuddy(nickname.nickname);
        if (user != null && user.status == 1 && nickname.getClassCode() != -1) {
            user.signon = nickname.signonTOD;
            user.idle = nickname.idleTime;
            user.userClass = nickname.getClassCode();
            user.changed = true;
        }
    }

    static {
        CREATED = 1;
        RENAMED = 2;
        DELETED = 3;
        UPDATED = 4;
    }
}

