/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.AdminTool;
import component.AdminUIListener;
import component.Tools;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import main.AdminConstants;
import main.Oscar;
import uiutil.ACheckbox;
import uiutil.ACheckboxGroup;
import uiutil.ChangeListener;
import uiutil.ChoiceListener;
import uiutil.ChoiceUI;
import uiutil.PropertySheet;
import uiutil.Spacer;
import uiutil.TransparentPanel;
import uiutil.UrlViewer;
import util.KeyBindings;

public class PrivacyProps
extends PropertySheet
implements AdminConstants,
AdminUIListener,
ChoiceListener,
ChangeListener,
ItemListener {
    private static final String MODULE = "PrivacyProps";
    private Tools tools;
    private AdminTool admin;
    private ChangeListener changeListener;
    private boolean changed = false;
    private ACheckbox publishIdleCheck;
    private ACheckbox publishMemberCheck;
    private Label registrationLabel;
    private ACheckbox showFullCheck;
    private ACheckbox showSomeCheck;
    private ACheckbox showNoneCheck;

    public PrivacyProps(Tools tools, ChangeListener changeListener) {
        this.tools = tools;
        this.admin = (AdminTool)tools.get(AdminTool.NAME);
        this.admin.addAdminUIListener(this);
        this.changeListener = changeListener;
        this.setBackground(Oscar.backgroundColor);
        this.setLayout(new BorderLayout());
        this.add("North", new Spacer());
        this.add("West", new Spacer());
        TransparentPanel transparentPanel = new TransparentPanel(new BorderLayout());
        this.add("Center", transparentPanel);
        TransparentPanel transparentPanel2 = new TransparentPanel(new BorderLayout());
        transparentPanel.add("North", transparentPanel2);
        transparentPanel2.add("North", new Label("Allow other members to see...", 0));
        transparentPanel2.add("West", new Spacer());
        TransparentPanel transparentPanel3 = new TransparentPanel(new GridLayout(0, 1, 0, 0));
        transparentPanel2.add("Center", transparentPanel3);
        this.publishIdleCheck = new ACheckbox("How long I've been idle");
        transparentPanel3.add(this.publishIdleCheck);
        this.publishIdleCheck.addItemListener(this);
        this.publishMemberCheck = new ACheckbox("When I became a member");
        transparentPanel3.add(this.publishMemberCheck);
        this.publishMemberCheck.addItemListener(this);
        transparentPanel3.add(new Spacer());
        transparentPanel2 = new TransparentPanel(new BorderLayout());
        transparentPanel.add("Center", transparentPanel2);
        transparentPanel3 = new TransparentPanel(new BorderLayout());
        transparentPanel2.add("North", transparentPanel3);
        this.registrationLabel = new Label("When members look me up by email address...");
        transparentPanel3.add("North", this.registrationLabel);
        transparentPanel3.add("West", new Spacer());
        TransparentPanel transparentPanel4 = new TransparentPanel(new GridLayout(0, 1, 0, 0));
        transparentPanel3.add("Center", transparentPanel4);
        ACheckboxGroup aCheckboxGroup = new ACheckboxGroup();
        this.showFullCheck = new ACheckbox("Show members my nickname", aCheckboxGroup, false);
        transparentPanel4.add(this.showFullCheck);
        this.showFullCheck.addItemListener(this);
        this.showSomeCheck = new ACheckbox("Show members only that I'm a member", aCheckboxGroup, false);
        transparentPanel4.add(this.showSomeCheck);
        this.showSomeCheck.addItemListener(this);
        this.showNoneCheck = new ACheckbox("Don't reveal my nickname or membership", aCheckboxGroup, false);
        transparentPanel4.add(this.showNoneCheck);
        this.showNoneCheck.addItemListener(this);
        transparentPanel2.add("Center", new Spacer());
        this.setEnabled(Oscar.mainTool.getEnabled());
        this.setValues();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.setChanged(true);
    }

    public boolean changed() {
        return this.changed;
    }

    public boolean help() {
        ChoiceUI.newChoiceUI("Privacy Setup Help", "This is where you control access to some of the information other members know about you online. Publishing your idle time is useful as it lets others know when you've stepped away from your computer so they'll know you are not reachable. Publishing the date you became a member boosts your credibility by showing you are an established member. Other members may look you up if they know your email address. You may control whether to reveal your nickname, only the fact that you are a member or nothing about your membership by selecting the corresponding checkbox. You must be online to change this setting.");
        return true;
    }

    public void removeNotify() {
        this.removeAll();
        this.tools = null;
        if (this.admin != null) {
            this.admin.removeAdminUIListener(this);
            this.admin = null;
        }
        this.changeListener = null;
        this.publishIdleCheck = null;
        this.publishMemberCheck = null;
        this.registrationLabel = null;
        this.showFullCheck = null;
        this.showSomeCheck = null;
        this.showNoneCheck = null;
        super.removeNotify();
    }

    public boolean save() {
        KeyBindings keyBindings = Oscar.config.getKeyBindings("Privacy");
        if (keyBindings == null) {
            keyBindings = Oscar.config.addKeyBindings("Privacy");
        }
        keyBindings.setValue("publishIdleTime", String.valueOf(this.publishIdleCheck.getState()));
        keyBindings.setValue("publishMemberSince", String.valueOf(this.publishMemberCheck.getState()));
        if (this.showFullCheck.getState()) {
            this.admin.changeRegistrationStatus(3);
        } else if (this.showSomeCheck.getState()) {
            this.admin.changeRegistrationStatus(2);
        } else if (this.showNoneCheck.getState()) {
            this.admin.changeRegistrationStatus(1);
        }
        Oscar.permit.sendPrivacy();
        this.setChanged(false);
        return true;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
        if (bl) {
            this.changeListener.setChanged(true);
        }
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            this.registrationLabel.setText("When members look me up by email address...");
        } else {
            this.registrationLabel.setText("Change registration status (You must be online)");
        }
        this.showFullCheck.setEnabled(bl);
        this.showSomeCheck.setEnabled(bl);
        this.showNoneCheck.setEnabled(bl);
    }

    public void setValues() {
        String string;
        KeyBindings keyBindings = Oscar.config.getKeyBindings("Privacy");
        if (keyBindings == null) {
            keyBindings = Oscar.config.addKeyBindings("Privacy");
        }
        if ((string = keyBindings.getValue("publishIdleTime")) == null || string.equalsIgnoreCase("true")) {
            this.publishIdleCheck.setState(true);
        } else {
            this.publishIdleCheck.setState(false);
        }
        string = keyBindings.getValue("publishMemberSince");
        if (string == null || string.equalsIgnoreCase("true")) {
            this.publishMemberCheck.setState(true);
        } else {
            this.publishMemberCheck.setState(false);
        }
        if (Oscar.registrationStatus == -1) {
            this.showFullCheck.setState(false);
            this.showSomeCheck.setState(false);
            this.showNoneCheck.setState(false);
            if (Oscar.mainTool.getEnabled()) {
                this.admin.requestRegistrationStatus();
            }
        } else {
            this.setRegistrationStatus(Oscar.registrationStatus);
        }
        this.setChanged(false);
    }

    public void setNickname(String string) {
    }

    public void setEmailAddress(String string) {
    }

    public void setRegistrationStatus(int n) {
        if (!(this.showFullCheck.getState() || this.showSomeCheck.getState() || this.showNoneCheck.getState())) {
            if (Oscar.registrationStatus == 2) {
                this.showSomeCheck.setState(true);
                return;
            }
            if (Oscar.registrationStatus == 1) {
                this.showNoneCheck.setState(true);
                return;
            }
            if (Oscar.registrationStatus == 3) {
                this.showFullCheck.setState(true);
            }
        }
    }

    public void error(int n, String string, String string2) {
        if (n == 3) {
            ChoiceUI.newChoiceUI(this, 0, string2, "Server Request", "Unable to determine your registration status due to " + string + ".", "OK", "More Info", null, Oscar.WARNING_SOUND);
            this.setEnabled(false);
        }
    }

    public void changeSuccessful(int n, Object object) {
    }

    public void changeFailed(int n, String string, String string2) {
        if (n == 3) {
            ChoiceUI.newChoiceUI(this, 0, string2, "Privacy Change", "The server failed to process your request to change your registration status due to " + string + ". Please try again later.", "OK", "More Info", null, Oscar.WARNING_SOUND);
        }
    }

    public void choiceMade(int n, int n2, Object object) {
        if (n2 == 1) {
            new UrlViewer((String)object);
        }
    }
}

