/*
 * Decompiled with CFR 0.152.
 */
package component;

import component.Folders;
import component.OscarLabelButton;
import component.OscarSetup;
import component.Tool;
import component.Tools;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import main.Oscar;
import uiutil.ChangeListener;
import uiutil.ChoiceListener;
import uiutil.ChoiceUI;
import uiutil.IUtil;
import uiutil.ImageLabel;
import uiutil.ImagePanel;
import uiutil.TransparentPanel;

public class SetupUI
extends ImagePanel
implements ChoiceListener,
ChangeListener,
ActionListener {
    private static int SAVE_CHOICE;
    private static int CANCEL_CHOICE;
    private OscarSetup oscarSetup;
    private Tools tools;
    private Tool tool;
    private String title;
    private ImageLabel titleLabel;
    private OscarLabelButton helpButton;
    private OscarLabelButton okButton;
    private OscarLabelButton cancelButton;
    private OscarLabelButton applyButton;
    private ImagePanel folderPanel;
    private CardLayout folderLayout;
    private Hashtable folderStore = new Hashtable();
    private Folders currentFolders;

    public SetupUI(OscarSetup oscarSetup, Tools tools, Tool tool, Image image) {
        this.oscarSetup = oscarSetup;
        this.tools = tools;
        this.tool = tool;
        this.title = "";
        this.setTile(image);
        this.setLayout(new BorderLayout());
        this.titleLabel = new ImageLabel(this.title, 1);
        this.add("North", this.titleLabel);
        this.folderPanel = new ImagePanel();
        this.add("Center", this.folderPanel);
        this.folderLayout = new CardLayout();
        this.folderPanel.setLayout(this.folderLayout);
        this.folderPanel.setTile(image);
        TransparentPanel transparentPanel = new TransparentPanel();
        this.add("South", transparentPanel);
        transparentPanel.setLayout(new BorderLayout());
        TransparentPanel transparentPanel2 = new TransparentPanel();
        transparentPanel.add("West", transparentPanel2);
        this.helpButton = new OscarLabelButton("Help", tool, transparentPanel2);
        transparentPanel2.add(this.helpButton);
        this.helpButton.addActionListener(this);
        transparentPanel2 = new TransparentPanel();
        transparentPanel.add("East", transparentPanel2);
        this.okButton = new OscarLabelButton("OK", tool, transparentPanel2);
        transparentPanel2.add(this.okButton);
        this.okButton.addActionListener(this);
        this.cancelButton = new OscarLabelButton("Cancel", tool, transparentPanel2);
        transparentPanel2.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        this.applyButton = new OscarLabelButton("Apply", tool, transparentPanel2);
        transparentPanel2.add(this.applyButton);
        this.applyButton.addActionListener(this);
        this.setChanged(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.helpButton) {
            this.helpAction();
            return;
        }
        if (object == this.okButton) {
            this.okAction();
            return;
        }
        if (object == this.cancelButton) {
            this.cancelAction();
            return;
        }
        if (object == this.applyButton) {
            this.applyAction();
        }
    }

    public void addFolders(String string, Folders folders) {
        this.folderPanel.add(string, folders);
        this.folderStore.put(string, folders);
    }

    public boolean applyAction() {
        boolean bl = false;
        Enumeration enumeration = this.folderStore.elements();
        while (enumeration.hasMoreElements()) {
            Folders folders = (Folders)enumeration.nextElement();
            if (!folders.save()) continue;
            bl = true;
        }
        if (bl) {
            IUtil.playSound(this.tool, "save");
            this.setChanged(false);
        }
        Oscar.saveConfiguration();
        return bl;
    }

    public void cancelAction() {
        if (this.changed()) {
            ChoiceUI.newChoiceUI(this, 0, null, "Unsaved Changes", "You changed one or more of your preference settings which you have not saved. You may choose to save now, discard your changes or continue using setup.", "Save", "Discard", "Setup", Oscar.WARNING_SOUND);
            return;
        }
        this.oscarSetup.dispose();
    }

    public boolean changed() {
        boolean bl = false;
        Enumeration enumeration = this.folderStore.elements();
        while (enumeration.hasMoreElements()) {
            Folders folders = (Folders)enumeration.nextElement();
            if (!folders.changed()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void choiceMade(int n, int n2, Object object) {
        if (n2 == SAVE_CHOICE) {
            this.okAction();
            return;
        }
        if (n2 == CANCEL_CHOICE) {
            this.oscarSetup.dispose();
        }
    }

    public void helpAction() {
        if (this.currentFolders != null && !this.currentFolders.help()) {
            ChoiceUI.newChoiceUI("Setup", "There's no help available for this screen of " + this.title + ".", Oscar.WARNING_SOUND);
        }
    }

    public void okAction() {
        if (this.changed() && !this.applyAction()) {
            return;
        }
        this.oscarSetup.dispose();
    }

    public void removeNotify() {
        this.removeAll();
        this.oscarSetup = null;
        this.tools = null;
        this.tool = null;
        this.title = null;
        this.titleLabel = null;
        this.helpButton = null;
        this.okButton = null;
        this.cancelButton = null;
        this.applyButton = null;
        this.folderPanel = null;
        this.folderLayout = null;
        if (this.folderStore != null) {
            Enumeration enumeration = this.folderStore.elements();
            while (enumeration.hasMoreElements()) {
                this.folderStore.remove(enumeration.nextElement());
            }
            this.folderStore = null;
        }
        this.currentFolders = null;
        this.setLayout(null);
        super.removeNotify();
    }

    public void reset() {
        Enumeration enumeration = this.folderStore.elements();
        while (enumeration.hasMoreElements()) {
            Folders folders = (Folders)enumeration.nextElement();
            folders.reset();
        }
    }

    public void setChanged(boolean bl) {
        this.applyButton.setEnabled(bl);
    }

    public Folders getFolders(String string) {
        if (string == null) {
            return this.currentFolders;
        }
        return (Folders)this.folderStore.get(string);
    }

    public void showFolders(String string, int n) {
        Folders folders = (Folders)this.folderStore.get(string);
        if (folders == null) {
            System.out.println("Getting the folder from oscarSetup");
            folders = this.oscarSetup.getFolders(string);
            if (folders != null) {
                this.addFolders(string, folders);
            }
        }
        if (folders != null) {
            folders.selectCard(-1);
            this.folderLayout.show(this.folderPanel, string);
            this.currentFolders = folders;
            this.title = string;
        }
    }

    static {
        CANCEL_CHOICE = 1;
    }
}

