/*
 * Decompiled with CFR 0.152.
 */
package snac;

import flap.FLAPSock;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import snac.AdminListener;
import snac.DispatcherListener;
import snac.Listener;
import snac.SNACHeader;
import snac.SnacAdmininfo;
import snac.SnacHandler;
import snac.SnacTlv;
import snac.TLV;
import uiutil.ErrorMgr;
import util.Log;
import util.OutputBuffer;

public class AdminHandler
extends SnacHandler {
    private static final String MODULE = "SNAC";

    public AdminHandler(DispatcherListener dispatcherListener) {
        this.dispatcher = dispatcherListener;
        dispatcherListener.registerSNACHandler(7, 1, this);
    }

    public void infoQuery(FLAPSock fLAPSock, AdminListener adminListener, Object object, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing adminInfoQuery SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n)).write(outputBuffer.d);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, adminListener, object, 7, 2, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Admin", "got IOException in adminInfoQuery " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeInfoReply(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got adminInfoReply SNAC");
        AdminListener adminListener = (AdminListener)listener;
        try {
            block8: {
                int n;
                int n2;
                Vector<SnacAdmininfo> vector2;
                block7: {
                    vector2 = new Vector<SnacAdmininfo>();
                    while (dataInputStream.available() > 0) {
                        vector2.addElement(new SnacAdmininfo(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (adminListener != null) {
                        n2 = this.updateHandledState(n2, adminListener.adminInfoReply(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    AdminListener adminListener2;
                    if ((adminListener2 = (AdminListener)vector.elementAt(n)) != adminListener) {
                        n2 = this.updateHandledState(n2, adminListener2.adminInfoReply(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Admin", "got IOException in adminInfoReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void infoChangeRequest(FLAPSock fLAPSock, AdminListener adminListener, Object object, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing adminInfoChangeRequest SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n)).write(outputBuffer.d);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, adminListener, object, 7, 4, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Admin", "got IOException in adminInfoChangeRequest " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeInfoChangeReply(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got adminInfoChangeReply SNAC");
        AdminListener adminListener = (AdminListener)listener;
        try {
            block8: {
                int n;
                int n2;
                Vector<SnacAdmininfo> vector2;
                block7: {
                    vector2 = new Vector<SnacAdmininfo>();
                    while (dataInputStream.available() > 0) {
                        vector2.addElement(new SnacAdmininfo(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (adminListener != null) {
                        n2 = this.updateHandledState(n2, adminListener.adminInfoChangeReply(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    AdminListener adminListener2;
                    if ((adminListener2 = (AdminListener)vector.elementAt(n)) != adminListener) {
                        n2 = this.updateHandledState(n2, adminListener2.adminInfoChangeReply(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Admin", "got IOException in adminInfoChangeReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void acctConfirmRequest(FLAPSock fLAPSock, AdminListener adminListener, Object object) {
        Log.log(MODULE, Log.DB1, "writing adminAcctConfirmRequest SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            this.dispatcher.queueOutput(fLAPSock, adminListener, object, 7, 6, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Admin", "got IOException in adminAcctConfirmRequest " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeAcctConfirmReply(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got adminAcctConfirmReply SNAC");
        AdminListener adminListener = (AdminListener)listener;
        try {
            block8: {
                int n;
                int n2;
                TLV tLV;
                int n3;
                block7: {
                    n3 = dataInputStream.readUnsignedShort();
                    tLV = new TLV();
                    while (dataInputStream.available() > 0) {
                        tLV.addElement(new SnacTlv(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (adminListener != null) {
                        n2 = this.updateHandledState(n2, adminListener.adminAcctConfirmReply(fLAPSock, object, sNACHeader.reqID, n2, n3, tLV));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    AdminListener adminListener2;
                    if ((adminListener2 = (AdminListener)vector.elementAt(n)) != adminListener) {
                        n2 = this.updateHandledState(n2, adminListener2.adminAcctConfirmReply(fLAPSock, object, sNACHeader.reqID, n2, n3, tLV));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Admin", "got IOException in adminAcctConfirmReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void acctDeleteRequest(FLAPSock fLAPSock, AdminListener adminListener, Object object, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing adminAcctDeleteRequest SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n)).write(outputBuffer.d);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, adminListener, object, 7, 8, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Admin", "got IOException in adminAcctDeleteRequest " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeAcctDeleteReply(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got adminAcctDeleteReply SNAC");
        AdminListener adminListener = (AdminListener)listener;
        try {
            block8: {
                int n;
                int n2;
                TLV tLV;
                block7: {
                    tLV = new TLV();
                    while (dataInputStream.available() > 0) {
                        tLV.addElement(new SnacTlv(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (adminListener != null) {
                        n2 = this.updateHandledState(n2, adminListener.adminAcctDeleteReply(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    AdminListener adminListener2;
                    if ((adminListener2 = (AdminListener)vector.elementAt(n)) != adminListener) {
                        n2 = this.updateHandledState(n2, adminListener2.adminAcctDeleteReply(fLAPSock, object, sNACHeader.reqID, n2, tLV));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Admin", "got IOException in adminAcctDeleteReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void decodeSNAC(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        if (sNACHeader.subtype == 1) {
            this.decodeSnacError(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 3) {
            this.decodeInfoReply(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 5) {
            this.decodeInfoChangeReply(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 7) {
            this.decodeAcctConfirmReply(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 9) {
            this.decodeAcctDeleteReply(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        ErrorMgr.warn("Admin", " got unrecognized SNAC " + sNACHeader + " ignoring");
        fLAPSock.close("server sending bad data", 23);
    }
}

