/*
 * Decompiled with CFR 0.152.
 */
package snac;

import flap.FLAPSock;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import snac.BosHostListener;
import snac.DispatcherListener;
import snac.Listener;
import snac.SNACHeader;
import snac.SnacHandler;
import snac.SnacNickname;
import snac.SnacTlv;
import snac.TLV;
import uiutil.ErrorMgr;
import util.Log;
import util.OutputBuffer;

public class BosHostHandler
extends SnacHandler {
    private static final String MODULE = "SNAC";

    public BosHostHandler(DispatcherListener dispatcherListener) {
        this.dispatcher = dispatcherListener;
        dispatcherListener.registerSNACHandler(9, 1, this);
    }

    private void decodeRightsQuery(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got bosRightsQuery SNAC");
        BosHostListener bosHostListener = (BosHostListener)listener;
        int n = this.initHandledState();
        if (bosHostListener != null) {
            n = this.updateHandledState(n, bosHostListener.bosRightsQuery(fLAPSock, object, sNACHeader.reqID, n));
        }
        int n2 = 0;
        while (vector != null && n2 < vector.size() && this.proceed(n)) {
            BosHostListener bosHostListener2 = (BosHostListener)vector.elementAt(n2);
            if (bosHostListener2 != bosHostListener) {
                n = this.updateHandledState(n, bosHostListener2.bosRightsQuery(fLAPSock, object, sNACHeader.reqID, n));
            }
            ++n2;
        }
    }

    public void rightsReply(FLAPSock fLAPSock, BosHostListener bosHostListener, Object object, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing bosRightsReply SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n)).write(outputBuffer.d);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, bosHostListener, object, 9, 3, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Bos", "got IOException in bosRightsReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeSetGroupPermitMask(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got bosSetGroupPermitMask SNAC");
        BosHostListener bosHostListener = (BosHostListener)listener;
        try {
            int n = dataInputStream.available();
            if (n < 4) {
                throw new IOException("read underflow");
            }
            byte[] byArray = new byte[4];
            dataInputStream.read(byArray, 0, 4);
            int n2 = this.initHandledState();
            if (bosHostListener != null) {
                n2 = this.updateHandledState(n2, bosHostListener.bosSetGroupPermitMask(fLAPSock, object, sNACHeader.reqID, n2, byArray));
            }
            int n3 = 0;
            while (vector != null) {
                if (n3 >= vector.size()) return;
                if (!this.proceed(n2)) {
                    return;
                }
                BosHostListener bosHostListener2 = (BosHostListener)vector.elementAt(n3);
                if (bosHostListener2 != bosHostListener) {
                    n2 = this.updateHandledState(n2, bosHostListener2.bosSetGroupPermitMask(fLAPSock, object, sNACHeader.reqID, n2, byArray));
                }
                ++n3;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Bos", "got IOException in bosSetGroupPermitMask " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeAddPermListEntries(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got bosAddPermListEntries SNAC");
        BosHostListener bosHostListener = (BosHostListener)listener;
        try {
            block8: {
                int n;
                int n2;
                Vector<SnacNickname> vector2;
                block7: {
                    vector2 = new Vector<SnacNickname>();
                    while (dataInputStream.available() > 0) {
                        vector2.addElement(new SnacNickname(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (bosHostListener != null) {
                        n2 = this.updateHandledState(n2, bosHostListener.bosAddPermListEntries(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    BosHostListener bosHostListener2;
                    if ((bosHostListener2 = (BosHostListener)vector.elementAt(n)) != bosHostListener) {
                        n2 = this.updateHandledState(n2, bosHostListener2.bosAddPermListEntries(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Bos", "got IOException in bosAddPermListEntries " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeDelPermListEntries(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got bosDelPermListEntries SNAC");
        BosHostListener bosHostListener = (BosHostListener)listener;
        try {
            block8: {
                int n;
                int n2;
                Vector<SnacNickname> vector2;
                block7: {
                    vector2 = new Vector<SnacNickname>();
                    while (dataInputStream.available() > 0) {
                        vector2.addElement(new SnacNickname(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (bosHostListener != null) {
                        n2 = this.updateHandledState(n2, bosHostListener.bosDelPermListEntries(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    BosHostListener bosHostListener2;
                    if ((bosHostListener2 = (BosHostListener)vector.elementAt(n)) != bosHostListener) {
                        n2 = this.updateHandledState(n2, bosHostListener2.bosDelPermListEntries(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Bos", "got IOException in bosDelPermListEntries " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeAddDenyListEntries(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got bosAddDenyListEntries SNAC");
        BosHostListener bosHostListener = (BosHostListener)listener;
        try {
            block8: {
                int n;
                int n2;
                Vector<SnacNickname> vector2;
                block7: {
                    vector2 = new Vector<SnacNickname>();
                    while (dataInputStream.available() > 0) {
                        vector2.addElement(new SnacNickname(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (bosHostListener != null) {
                        n2 = this.updateHandledState(n2, bosHostListener.bosAddDenyListEntries(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    BosHostListener bosHostListener2;
                    if ((bosHostListener2 = (BosHostListener)vector.elementAt(n)) != bosHostListener) {
                        n2 = this.updateHandledState(n2, bosHostListener2.bosAddDenyListEntries(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Bos", "got IOException in bosAddDenyListEntries " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeDelDenyListEntries(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got bosDelDenyListEntries SNAC");
        BosHostListener bosHostListener = (BosHostListener)listener;
        try {
            block8: {
                int n;
                int n2;
                Vector<SnacNickname> vector2;
                block7: {
                    vector2 = new Vector<SnacNickname>();
                    while (dataInputStream.available() > 0) {
                        vector2.addElement(new SnacNickname(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (bosHostListener != null) {
                        n2 = this.updateHandledState(n2, bosHostListener.bosDelDenyListEntries(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    BosHostListener bosHostListener2;
                    if ((bosHostListener2 = (BosHostListener)vector.elementAt(n)) != bosHostListener) {
                        n2 = this.updateHandledState(n2, bosHostListener2.bosDelDenyListEntries(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Bos", "got IOException in bosDelDenyListEntries " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void err(FLAPSock fLAPSock, BosHostListener bosHostListener, Object object, int n, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing bosErr SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            outputBuffer.d.writeShort(n);
            int n2 = 0;
            while (n2 < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n2)).write(outputBuffer.d);
                ++n2;
            }
            this.dispatcher.queueOutput(fLAPSock, bosHostListener, object, 9, 9, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Bos", "got IOException in bosErr " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void decodeSNAC(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        if (sNACHeader.subtype == 1) {
            this.decodeSnacError(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 2) {
            this.decodeRightsQuery(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 4) {
            this.decodeSetGroupPermitMask(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 5) {
            this.decodeAddPermListEntries(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 6) {
            this.decodeDelPermListEntries(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 7) {
            this.decodeAddDenyListEntries(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 8) {
            this.decodeDelDenyListEntries(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        ErrorMgr.warn("Bos", " got unrecognized SNAC " + sNACHeader + " ignoring");
        fLAPSock.close("server sending bad data", 23);
    }
}

