/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.Color;
import java.util.Vector;
import uiutil.AolRtf;
import uiutil.FontInfo;

class MUI
implements Cloneable {
    public int muiID = muiCount++;
    public String data;
    public FontInfo f;
    public Color fgColor;
    public Color bgColor;
    public String url;
    public String tag;
    public int height;
    public int width;
    public int descent;
    public boolean isHidden = false;
    public int lineNo;
    public int x;
    public int lineTop;
    public int lineBottom;
    public int lineHeight;
    public int lineDescent;
    public MUI next;
    public MUI prev;
    private static int muiCount;

    public MUI startOfChain() {
        MUI mUI = this;
        while (mUI.prev != null) {
            mUI = mUI.prev;
        }
        return mUI;
    }

    public MUI endOfChain() {
        MUI mUI = this;
        while (mUI.next != null) {
            mUI = mUI.next;
        }
        return mUI;
    }

    public final int posBefore() {
        return -1;
    }

    public final boolean posIsBefore(int n) {
        return n == -1;
    }

    public final int posAfter() {
        if (this.data == null) {
            return 0;
        }
        return this.length() - 1;
    }

    public final boolean posIsAfter(int n) {
        return this.data == null && n == 0 || n >= this.length() - 1;
    }

    MUI(String string, FontInfo fontInfo, Color color, Color color2) {
        this.data = string;
        this.url = null;
        this.tag = null;
        this.f = fontInfo;
        this.fgColor = color;
        this.bgColor = color2;
        this.recalc();
    }

    MUI(String string, String string2) {
        this.data = string;
        this.url = string2;
        this.tag = null;
        this.f = AolRtf.urlFont;
        this.fgColor = Color.blue;
        this.bgColor = AolRtf.defBG;
        this.recalc();
    }

    MUI(String string) {
        this.data = null;
        this.url = null;
        this.tag = string;
        this.f = AolRtf.defFont;
        this.fgColor = AolRtf.defFG;
        this.bgColor = AolRtf.defBG;
        this.recalc();
    }

    public boolean isAllWS() {
        if (this.data == null) {
            return false;
        }
        int n = 0;
        while (n < this.length()) {
            if (this.data.charAt(n) != ' ') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public final boolean isBreak() {
        return this.tag != null && this.tag.equals("<BR>");
    }

    public void recalc() {
        if (this.data == null) {
            this.width = 0;
            this.height = AolRtf.defFont.metrics.getHeight();
            this.descent = AolRtf.defFont.descent;
            return;
        }
        this.width = this.f.metrics.stringWidth(this.data);
        this.height = this.f.metrics.getHeight();
        this.descent = this.f.descent;
    }

    public String name() {
        if (this.isBreak()) {
            return String.valueOf(this.muiID) + " <BR>" + " " + this.lineTop + " " + this.lineBottom + " " + this.x;
        }
        return String.valueOf(this.muiID) + " " + this.data + " " + this.url + " " + this.tag + " " + this.lineNo + " " + this.lineTop + " " + this.x + " " + this.f;
    }

    public String prettyName() {
        if (this.isBreak()) {
            return "\n";
        }
        return this.data;
    }

    public String htmlName() {
        System.out.println("htmlName " + this + " " + this.url);
        if (this.isBreak()) {
            return "<BR>";
        }
        if (this.url != null) {
            return "<A HREF=\"" + this.url + "\">" + this.data + "</A>";
        }
        return this.data;
    }

    public String toString() {
        if (this.isBreak()) {
            return this.name();
        }
        return "'" + this.name() + "'";
    }

    public int length() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length();
    }

    public MUI duplicate() {
        try {
            MUI mUI = (MUI)this.clone();
            mUI.muiID = muiCount++;
            return mUI;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void flush() {
        this.detach();
        this.data = null;
        this.f = null;
        this.fgColor = null;
        this.bgColor = null;
        this.url = null;
        this.tag = null;
    }

    public void detach() {
        this.prev = null;
        this.next = null;
    }

    public final MUI muiAfter(int n) {
        MUI mUI = this.duplicate();
        mUI.detach();
        if (this.isBreak() || this.posIsBefore(n)) {
            return mUI;
        }
        if (n >= mUI.length()) {
            return null;
        }
        mUI.data = mUI.data.substring(n + 1, this.length());
        mUI.recalc();
        return mUI;
    }

    public MUI muiBetween(int n, int n2) {
        MUI mUI = this.duplicate();
        mUI.detach();
        if (!this.isBreak()) {
            mUI.data = mUI.data.substring(n + 1, n2 + 1);
            mUI.recalc();
        }
        return mUI;
    }

    public final MUI muiBefore(int n) {
        if (this.isBreak() || this.posIsBefore(n)) {
            return null;
        }
        MUI mUI = this.duplicate();
        mUI.data = mUI.data.substring(0, n + 1);
        mUI.recalc();
        mUI.detach();
        return mUI;
    }

    public Vector split() {
        char c;
        int n;
        int n2 = 0;
        while (n2 < this.length()) {
            char c2 = this.data.charAt(0);
            n = this.data.charAt(n2);
            if (c2 == ' ' && n != 32 || c2 != ' ' && n == 32) break;
            ++n2;
        }
        if (n2 == this.length()) {
            return null;
        }
        Vector<MUI> vector = new Vector<MUI>();
        n = 0;
        n2 = 0;
        while (n2 < this.length()) {
            c = this.data.charAt(n2);
            if (c != ' ') break;
            ++n2;
        }
        if (n2 > n) {
            MUI mUI = null;
            try {
                mUI = (MUI)this.clone();
                mUI.muiID = muiCount++;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
            mUI.data = this.data.substring(n, n2);
            mUI.recalc();
            vector.addElement(mUI);
        }
        while (n2 < this.length()) {
            c = '\u0000';
            n = n2;
            while (n2 < this.length()) {
                char c3 = this.data.charAt(n2);
                if (c == '\u0000' && c3 == ' ') {
                    c = '\u0001';
                } else if (c != '\u0000' && c3 != ' ') break;
                ++n2;
            }
            if (n2 <= n) continue;
            MUI mUI = null;
            try {
                mUI = (MUI)this.clone();
                ++muiCount;
                mUI.muiID = mUI.muiID;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
            mUI.data = this.data.substring(n, n2);
            mUI.recalc();
            vector.addElement(mUI);
        }
        n2 = 0;
        while (n2 < vector.size() - 1) {
            MUI mUI;
            MUI mUI2 = (MUI)vector.elementAt(n2);
            mUI2.next = mUI = (MUI)vector.elementAt(n2 + 1);
            mUI.prev = mUI2;
            ++n2;
        }
        MUI mUI = (MUI)vector.firstElement();
        mUI.prev = null;
        MUI mUI3 = (MUI)vector.lastElement();
        mUI3.next = null;
        return vector;
    }
}

