/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import uiutil.ErrorMgr;
import uiutil.ImageItem;
import uiutil.ImageList;
import uiutil.Item;
import uiutil.ItemRow;
import uiutil.RowItem;
import uiutil.StringItem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ScrollList
extends Panel
implements ItemSelectable,
MouseListener,
KeyListener,
AdjustmentListener {
    private static final int MINH = 15;
    public static final int INSET = 2;
    private Scrollbar vbar = new Scrollbar(1);
    private Vector rowList;
    private ItemRow selectedRow;
    private int selectedIndex = -1;
    private Image image;
    private int topIndex;
    private int visible;
    private int rowsHeight;
    private Color foreground;
    private Color background;
    private int largestImageAlignPos;
    private Hashtable ht = new Hashtable(15);
    Font font;
    private int rowHeight = ImageList.ICON_HEIGHT;
    private ItemListener itemListener;
    private MouseListener mouseListener;

    public void destroy() {
        this.vbar = null;
        if (this.rowList != null) {
            int n = 0;
            while (n < this.rowList.size()) {
                ItemRow itemRow = (ItemRow)this.rowList.elementAt(n);
                itemRow.destroy();
                ++n;
            }
            this.rowList.removeAllElements();
        }
        this.rowList = null;
        this.selectedRow = null;
        this.image = null;
        this.foreground = null;
        this.background = null;
        this.font = null;
        if (this.ht != null) {
            this.ht.clear();
            this.ht = null;
        }
        this.itemListener = null;
        this.mouseListener = null;
    }

    public void removeNotify() {
        this.destroy();
        super.removeNotify();
    }

    public ScrollList() {
        this(20, 15);
    }

    public ScrollList(int n, int n2) {
        this.rowList = new Vector(10);
        this.setLayout(new BorderLayout());
        this.add("East", this.vbar);
        this.foreground = Color.black;
        this.background = Color.white;
        this.addKeyListener(this);
        super.addMouseListener(this);
        this.vbar.addAdjustmentListener(this);
    }

    public ScrollList(int n) {
        this(n, 15);
    }

    public void addNotify() {
        super.addNotify();
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            this.rowHeight = Math.max(ImageList.ICON_HEIGHT, fontMetrics.getHeight());
        }
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, mouseListener);
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public Object[] getSelectedObjects() {
        return null;
    }

    public void setColors(Color color, Color color2) {
        this.foreground = color;
        this.background = color2;
        int n = 0;
        while (n < this.rowList.size()) {
            ((ItemRow)this.rowList.elementAt(n)).setColors(color, color2);
            ++n;
        }
        this.repaint();
    }

    public void setColors(int n, Color color, Color color2) {
        if (n < 0 || n >= this.rowList.size()) {
            return;
        }
        ((ItemRow)this.rowList.elementAt(n)).setColors(color, color2);
        this.repaint();
    }

    public void setColors(String string, Color color, Color color2) {
        Vector vector = this.getItemIndices(string);
        int n = 0;
        while (n < vector.size()) {
            this.setColors((Integer)vector.elementAt(n), color, color2);
            ++n;
        }
    }

    public void setDimRow(int n, boolean bl, Color color) {
        if (n < 0 || n >= this.rowList.size()) {
            return;
        }
        ((ItemRow)this.rowList.elementAt(n)).setColors(this.foreground, this.background, color, bl);
        this.repaint();
    }

    public void setDimRow(String string, boolean bl, Color color) {
        Vector vector = this.getItemIndices(string);
        int n = 0;
        while (n < vector.size()) {
            this.setDimRow((Integer)vector.elementAt(n), bl, color);
            ++n;
        }
    }

    public void setFont(Font font) {
        Graphics graphics;
        this.font = font;
        if (this.ht != null) {
            this.ht.clear();
        }
        if ((graphics = this.getGraphics()) != null) {
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            this.rowHeight = Math.max(ImageList.ICON_HEIGHT, fontMetrics.getHeight());
            if (this.rowList != null && this.rowList.size() > 0) {
                Vector vector = this.rowList;
                synchronized (vector) {
                    int n = this.rowList.size();
                    int n2 = 0;
                    while (n2 < n) {
                        ((ItemRow)this.rowList.elementAt(n2)).updateHeight(this.rowHeight);
                        ++n2;
                    }
                    this.rowsHeight = this.rowHeight * n;
                    this.adjustValues();
                }
            }
        }
        this.largestImageAlignPos = 0;
    }

    public int getAlignPos() {
        return this.largestImageAlignPos;
    }

    public void setAlignPos(String string, int n) {
        this.ht.put(string, new Integer(n));
        if (n > this.largestImageAlignPos) {
            this.largestImageAlignPos = n;
            this.repaint();
        }
    }

    public void updateAlignPos() {
        this.largestImageAlignPos = 0;
        int n = 0;
        Enumeration enumeration = this.ht.elements();
        while (enumeration.hasMoreElements()) {
            n = (Integer)enumeration.nextElement();
            if (n <= this.largestImageAlignPos) continue;
            this.largestImageAlignPos = n;
        }
        this.repaint();
    }

    private final int getNumberOfVisibleRows() {
        int n = 0;
        int n2 = this.rowList.size();
        int n3 = 0;
        while (n3 < n2) {
            if (((ItemRow)this.rowList.elementAt(n3)).isVisible()) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    private final int firstVisibleRowIndex() {
        int n = this.rowList.size();
        int n2 = 0;
        while (n2 < n) {
            if (((ItemRow)this.rowList.elementAt(n2)).isVisible()) {
                return n2;
            }
            ++n2;
        }
        return 0;
    }

    private void adjustValues() {
        Dimension dimension = this.getSize();
        int n = this.rowList.size();
        int n2 = this.getNumberOfVisibleRows();
        int n3 = this.vbar.getValue();
        if (n == 0) {
            return;
        }
        this.visible = (int)((double)dimension.height / (double)this.rowsHeight * (double)n);
        int n4 = Math.max(0, n2);
        if (this.visible >= n4) {
            this.topIndex = this.firstVisibleRowIndex();
        }
        this.updateAlignPos();
        this.vbar.setValues(n3, this.visible, 0, n4);
        this.repaint();
    }

    public void redrawItems() {
        this.adjustValues();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(100, 80);
        dimension.width += this.vbar.getPreferredSize().width;
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void addItem(String string, Vector vector) {
        this.addItem(string, vector, vector, -1);
    }

    public void addItem(String string, Vector vector, Vector vector2) {
        this.addItem(string, vector, vector2, -1);
    }

    public void addItem(String string, Vector vector, int n) {
        this.addItem(string, vector, vector, n);
    }

    public void addItem(String string, String string2, Vector vector, Vector vector2) {
        this.addItem(string, vector, vector2, this.getItemIndex(string2));
    }

    public void addItem(String string, Vector vector, Vector vector2, int n) {
        RowItem rowItem = null;
        int n2 = vector.size();
        Vector<RowItem> vector3 = new Vector<RowItem>(n2);
        int n3 = 0;
        while (n3 < n2) {
            Object e = vector.elementAt(n3);
            Object e2 = vector2.elementAt(n3);
            Item item = e instanceof String ? new StringItem((String)e, this.rowHeight) : new ImageItem((Image)e);
            Item item2 = e2 instanceof String ? new StringItem((String)e2, this.rowHeight) : new ImageItem((Image)e2);
            rowItem = new RowItem(item, item2);
            vector3.addElement(rowItem);
            ++n3;
        }
        ItemRow itemRow = new ItemRow(string, vector3, this.background, this.foreground);
        itemRow.setWidth(this.getSize().width);
        itemRow.setSLRef(this);
        if (n >= 0 && n < this.rowList.size()) {
            this.rowList.insertElementAt(itemRow, n);
        } else {
            this.rowList.addElement(itemRow);
        }
        this.rowsHeight += itemRow.getHeight();
        this.adjustValues();
    }

    public void invalidate() {
        super.invalidate();
        this.image = null;
        this.adjustValues();
    }

    public void clear() {
        this.rowList.removeAllElements();
        this.selectedIndex = -1;
        this.rowsHeight = 0;
        this.adjustValues();
    }

    public int count() {
        return this.rowList.size();
    }

    public void delItem(int n) {
        ScrollList.assert(n >= 0 && n < this.rowList.size());
        ItemRow itemRow = (ItemRow)this.rowList.elementAt(n);
        this.rowList.removeElementAt(n);
        this.rowsHeight -= itemRow.getHeight();
        if (n < this.selectedIndex) {
            --this.selectedIndex;
        } else if (n == this.selectedIndex) {
            this.selectedIndex = -1;
            if (this.selectedRow != null) {
                this.selectedRow.deselect();
            }
        }
        if (itemRow != null) {
            itemRow.destroy();
            itemRow = null;
        }
        this.adjustValues();
    }

    public void delItem() {
        if (!this.rowList.isEmpty()) {
            this.delItem(this.rowList.size() - 1);
            return;
        }
        ErrorMgr.diag("ScrollList:", "There's no element left to delete.");
    }

    public void delItem(String string) {
        int n = this.getItemIndex(string);
        this.delItem(n);
    }

    public void delItem(String string, String string2) {
        int n = this.getItemIndex(string2);
        if (n < 0) {
            return;
        }
        int n2 = n;
        int n3 = n + 1;
        while (n3 < this.rowList.size()) {
            ItemRow itemRow = (ItemRow)this.rowList.elementAt(n3);
            if (string.equals(itemRow.getName())) {
                n2 = this.rowList.indexOf(itemRow);
                break;
            }
            ++n3;
        }
        this.delItem(n2);
    }

    public void deselect(int n) {
        ScrollList.assert(n >= 0 && n < this.rowList.size());
        ((ItemRow)this.rowList.elementAt(n)).deselect();
        if (this.selectedIndex == n) {
            this.selectedIndex = -1;
        }
    }

    public Vector getItem(int n) {
        ScrollList.assert(n >= 0 && n < this.rowList.size());
        return ((ItemRow)this.rowList.elementAt(n)).getNormalList();
    }

    public Vector getSelectedItem(int n) {
        ScrollList.assert(n >= 0 && n < this.rowList.size());
        return ((ItemRow)this.rowList.elementAt(n)).getSelectedList();
    }

    public Vector getItem(String string) {
        return this.getItem(this.getItemIndex(string));
    }

    public Vector getItem(String string, String string2) {
        int n = this.getItemIndex(string2);
        if (n < 0) {
            return null;
        }
        int n2 = n;
        int n3 = n + 1;
        while (n3 < this.rowList.size()) {
            ItemRow itemRow = (ItemRow)this.rowList.elementAt(n3);
            if (string.equals(itemRow.getName())) {
                n2 = this.rowList.indexOf(itemRow);
                break;
            }
            ++n3;
        }
        return this.getItem(n2);
    }

    public Vector getSelectedItem(String string) {
        return this.getSelectedItem(this.getItemIndex(string));
    }

    public int getItemIndex(String string) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.rowList.size()) {
            ItemRow itemRow = (ItemRow)this.rowList.elementAt(n2);
            if (string.equals(itemRow.getName())) {
                n = this.rowList.indexOf(itemRow);
                break;
            }
            ++n2;
        }
        return n;
    }

    public Vector getItemIndices(String string) {
        Vector<Integer> vector = new Vector<Integer>(5);
        int n = 0;
        while (n < this.rowList.size()) {
            ItemRow itemRow = (ItemRow)this.rowList.elementAt(n);
            if (string.equals(itemRow.getName())) {
                vector.addElement(new Integer(this.rowList.indexOf(itemRow)));
            }
            ++n;
        }
        return vector;
    }

    public String getItemName(int n) {
        ScrollList.assert(n >= 0 && n < this.rowList.size());
        return ((ItemRow)this.rowList.elementAt(n)).getName();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public String getSelectedName() {
        if (this.selectedIndex >= 0) {
            return this.selectedRow.getName();
        }
        return null;
    }

    private final int getNumberOfInvisibleRows(int n, int n2) {
        this.rowList.size();
        int n3 = 0;
        int n4 = n + 1;
        while (n4 < n2) {
            ItemRow itemRow = (ItemRow)this.rowList.elementAt(n4);
            if (!itemRow.isVisible()) {
                ++n3;
            }
            ++n4;
        }
        return n3;
    }

    public void makeVisible(int n) {
        int n2 = this.rowList.size();
        ScrollList.assert(n >= 0 && n < this.rowList.size());
        int n3 = this.getNumberOfInvisibleRows(this.topIndex, n);
        if (n < this.topIndex) {
            this.topIndex = n;
        } else if (n - n3 >= this.topIndex + this.visible) {
            this.topIndex = n - this.visible + 1;
            if (this.topIndex >= n2) {
                this.topIndex = 0;
            }
        }
        this.vbar.setValues(this.topIndex, this.visible, 0, this.getNumberOfVisibleRows());
        this.repaint();
    }

    public void replaceItem(String string, Vector vector, int n) {
        this.replaceItem(string, vector, vector, n);
    }

    public void replaceItem(String string, Vector vector, Vector vector2, int n) {
        ScrollList.assert(n >= 0 && n < this.rowList.size());
        RowItem rowItem = null;
        int n2 = vector.size();
        Vector<RowItem> vector3 = new Vector<RowItem>(n2);
        int n3 = 0;
        while (n3 < n2) {
            Object e = vector.elementAt(n3);
            Object e2 = vector2.elementAt(n3);
            Item item = e instanceof String ? new StringItem((String)e, this.rowHeight) : new ImageItem((Image)e);
            Item item2 = e2 instanceof String ? new StringItem((String)e2, this.rowHeight) : new ImageItem((Image)e2);
            rowItem = new RowItem(item, item2);
            vector3.addElement(rowItem);
            ++n3;
        }
        ((ItemRow)this.rowList.elementAt(n)).updateRowItems(string, vector3, this.background, this.foreground);
        this.repaint();
    }

    public void setVisible(String string, boolean bl) {
        int n = this.rowList.size();
        int n2 = 0;
        while (n2 < n) {
            ItemRow itemRow = (ItemRow)this.rowList.elementAt(n2);
            if (itemRow.getName().equals(string)) {
                itemRow.setVisible(bl);
                return;
            }
            ++n2;
        }
    }

    public void setVisible(int n, boolean bl) {
        ScrollList.assert(n >= 0 && n < this.rowList.size());
        ((ItemRow)this.rowList.elementAt(n)).setVisible(bl);
    }

    public void select(int n) {
        ScrollList.assert(n >= 0 && n < this.rowList.size());
        ItemRow itemRow = (ItemRow)this.rowList.elementAt(n);
        if (itemRow != null) {
            this.selectedRow = itemRow;
            this.selectedRow.select();
            this.selectedIndex = n;
        }
    }

    public boolean isWithinTuple(int n, int n2) {
        return n2 <= this.rowsHeight;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = -1;
        int n2 = keyEvent.getKeyCode();
        if (keyEvent.isActionKey()) {
            if (n2 == 37 || n2 == 38) {
                if (this.selectedIndex < 0) {
                    this.vbar.setValue(Math.max(0, this.vbar.getValue() - 1));
                    this.adjustmentValueChanged(new AdjustmentEvent(this.vbar, 0, 2, this.vbar.getValue()));
                    return;
                }
                n = this.selectedIndex;
                while (n > 0) {
                    if (!((ItemRow)this.rowList.elementAt(--n)).isVisible()) continue;
                    this.selectedRow.deselect();
                    this.selectedIndex = n;
                    this.select(this.selectedIndex);
                    this.makeVisible(this.selectedIndex);
                    return;
                }
                return;
            }
            if (n2 == 39 || n2 == 40) {
                if (this.selectedIndex < 0) {
                    this.vbar.setValue(Math.min(this.vbar.getMaximum(), this.vbar.getValue() + 1));
                    this.adjustmentValueChanged(new AdjustmentEvent(this.vbar, 0, 1, this.vbar.getValue()));
                    return;
                }
                n = this.selectedIndex;
                while (n + 1 < this.rowList.size()) {
                    if (!((ItemRow)this.rowList.elementAt(++n)).isVisible()) continue;
                    this.selectedRow.deselect();
                    this.selectedIndex = n;
                    this.select(this.selectedIndex);
                    this.makeVisible(this.selectedIndex);
                    return;
                }
                return;
            }
            if (n2 == 36) {
                if (this.selectedIndex < 0) {
                    this.vbar.setValue(0);
                    this.adjustmentValueChanged(new AdjustmentEvent(this.vbar, 0, 601, 0));
                    return;
                }
                n = 0;
                while (n < this.rowList.size()) {
                    if (((ItemRow)this.rowList.elementAt(n)).isVisible()) {
                        this.selectedRow.deselect();
                        this.selectedIndex = n;
                        this.select(this.selectedIndex);
                        this.makeVisible(this.selectedIndex);
                        return;
                    }
                    ++n;
                }
                return;
            }
            if (n2 == 35) {
                if (this.selectedIndex < 0) {
                    this.vbar.setValue(this.vbar.getMaximum());
                    this.adjustmentValueChanged(new AdjustmentEvent(this.vbar, 0, 601, this.vbar.getMaximum()));
                    return;
                }
                n = this.rowList.size() - 1;
                while (n > 0) {
                    if (((ItemRow)this.rowList.elementAt(n)).isVisible()) {
                        this.selectedRow.deselect();
                        this.selectedIndex = n;
                        this.select(this.selectedIndex);
                        this.makeVisible(this.selectedIndex);
                        return;
                    }
                    --n;
                }
                return;
            }
        } else if ((n2 == 32 || n2 == 10) && this.itemListener != null) {
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, this.selectedRow, 1));
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = -1;
        int n2 = 0;
        int n3 = this.rowList.size();
        int n4 = this.topIndex;
        while (n2 < this.visible && n4 < n3) {
            ItemRow itemRow = (ItemRow)this.rowList.elementAt(n4);
            if (itemRow.isVisible()) {
                if (itemRow.within(mouseEvent.getX(), mouseEvent.getY())) {
                    n = n4;
                    break;
                }
                ++n2;
            }
            ++n4;
        }
        if (n >= 0 && n < n3) {
            if (n != this.selectedIndex) {
                if (this.selectedRow != null) {
                    this.selectedRow.deselect();
                }
                this.selectedRow = (ItemRow)this.rowList.elementAt(n);
                this.selectedIndex = n;
            }
            if (mouseEvent.getClickCount() > 1) {
                this.selectedRow.select();
                if (this.itemListener != null) {
                    this.itemListener.itemStateChanged(new ItemEvent(this, 701, this.selectedRow, 1));
                }
            } else if (mouseEvent.getModifiers() == 4) {
                this.selectedRow.select();
            } else {
                this.selectedRow.toggle();
            }
            if (!this.selectedRow.selected) {
                this.selectedIndex = -1;
            }
            this.repaint();
            if (mouseEvent.getModifiers() == 4 && this.mouseListener != null) {
                this.mouseListener.mousePressed(mouseEvent);
            }
        }
        this.requestFocus();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mouseListener != null) {
            this.mouseListener.mouseReleased(mouseEvent);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.topIndex = this.vbar.getValue();
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        ItemRow itemRow;
        Dimension dimension = this.getSize();
        int n = this.rowList.size();
        int n2 = 0;
        if (this.image == null) {
            this.image = this.createImage(dimension.width, dimension.height);
            int n3 = 0;
            while (n3 < n) {
                itemRow = (ItemRow)this.rowList.elementAt(n3);
                if (itemRow.isVisible()) {
                    itemRow.setWidth(dimension.width);
                }
                ++n3;
            }
        }
        Graphics graphics2 = this.image.getGraphics();
        graphics2.setColor(this.background);
        if (this.font != null) {
            graphics2.setFont(this.font);
        }
        graphics2.fillRect(0, 0, dimension.width, dimension.height);
        Vector vector = this.rowList;
        synchronized (vector) {
            n = this.rowList.size();
            int n4 = this.topIndex;
            while (n2 < this.visible && n4 < n) {
                itemRow = (ItemRow)this.rowList.elementAt(n4);
                if (itemRow.isVisible()) {
                    itemRow.paint(this, graphics2, n2++);
                }
                ++n4;
            }
        }
        graphics.drawImage(this.image, 0, 0, this);
        graphics2.dispose();
    }

    static void assert(boolean bl) throws IllegalArgumentException {
        if (!bl) {
            throw new IllegalArgumentException("Assertion failed ");
        }
    }
}

