/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import uiutil.TreeNode;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ScrollTree
extends Container
implements ItemSelectable,
MouseListener,
KeyListener,
AdjustmentListener,
FocusListener {
    public static final byte HGAP = 2;
    public static final byte VGAP = 0;
    public static final String cmark = "+";
    private Scrollbar vbar = new Scrollbar(1);
    private final int PAGE_SIZE = 7;
    private Image image;
    private int topIndex;
    private int rowsHeight;
    private int visible;
    private int selectedIndex = -1;
    private TreeNode selectedNode;
    public static Color foreground = Color.black;
    public static Color background = Color.white;
    public static Color fgDimColor = Color.lightGray;
    Font font;
    private int MIN_HEIGHT;
    private int rowHeight = this.MIN_HEIGHT = 12;
    private Vector nodeList = new Vector(10);
    public static final int ALIGNCOLUMN = 2;
    private int largestAlignPos;
    private ItemListener itemListener;
    private MouseListener mouseListener;

    public ScrollTree() {
        this.setLayout(new BorderLayout());
        this.add("East", this.vbar);
        this.addKeyListener(this);
        super.addMouseListener(this);
        this.vbar.addAdjustmentListener(this);
        this.addFocusListener(this);
    }

    public void add(TreeNode treeNode) {
        this.nodeList.addElement(treeNode);
        this.finalizeAdd(treeNode);
    }

    public void add(TreeNode treeNode, int n) {
        if (n < 0 || n >= this.nodeList.size()) {
            return;
        }
        if (n == 0) {
            this.nodeList.insertElementAt(treeNode, 0);
        } else {
            int n2 = 0;
            int n3 = 0;
            int n4 = 1;
            while (n4 < this.nodeList.size()) {
                TreeNode treeNode2 = (TreeNode)this.nodeList.elementAt(n4);
                if (treeNode2.getLevel() == 0 && ++n2 == n) {
                    n3 = n4;
                    break;
                }
                ++n4;
            }
            if (n2 == n) {
                this.nodeList.insertElementAt(treeNode, n3);
            } else {
                this.nodeList.addElement(treeNode);
            }
        }
        this.finalizeAdd(treeNode);
    }

    public void add(TreeNode treeNode, TreeNode treeNode2) {
        int n = this.getInsertionIndex(treeNode);
        if (n < 0) {
            return;
        }
        if (n < this.nodeList.size()) {
            this.nodeList.insertElementAt(treeNode2, n);
        } else {
            this.nodeList.addElement(treeNode2);
        }
        treeNode2.setLevel(treeNode.getLevel() + 1);
        if (treeNode.isCollapsed() || !treeNode.isVisible()) {
            treeNode2.setVisible(false);
        }
        this.finalizeAdd(treeNode2);
    }

    public void add(TreeNode treeNode, TreeNode treeNode2, int n) {
        int n2 = this.nodeList.indexOf(treeNode);
        int n3 = n2 + n + 1;
        if (n2 < 0 || n3 >= this.nodeList.size()) {
            return;
        }
        int n4 = treeNode.getLevel();
        TreeNode treeNode3 = (TreeNode)this.nodeList.elementAt(n3);
        if (treeNode3 == null || treeNode3.getLevel() != n4 + 1) {
            return;
        }
        if (n < this.nodeList.size()) {
            this.nodeList.insertElementAt(treeNode2, n3);
        } else {
            this.nodeList.addElement(treeNode2);
        }
        treeNode2.setLevel(n4 + 1);
        if (treeNode.isCollapsed()) {
            treeNode2.setVisible(false);
        }
        this.finalizeAdd(treeNode2);
    }

    private final void finalizeAdd(TreeNode treeNode) {
        Math.max(this.rowHeight, treeNode.getHeight());
        int n = this.nodeList.size();
        int n2 = 0;
        while (n2 < n) {
            ((TreeNode)this.nodeList.elementAt(n2)).setHeight(this.rowHeight);
            ++n2;
        }
        treeNode.setWidth(this.getSize().width);
        this.rowsHeight = n * this.rowHeight;
        treeNode.setRef(this);
        this.adjustValues();
    }

    public void delete(TreeNode treeNode) {
        int n = this.deleteSubtree(treeNode);
        if (n > 0) {
            this.finalizeDelete(treeNode, n);
        }
    }

    public void delete(String string) {
        int n = 0;
        while (n < this.nodeList.size()) {
            TreeNode treeNode = (TreeNode)this.nodeList.elementAt(n);
            String string2 = treeNode.getName();
            if (string2 != null && string2.equals(string)) {
                this.delete(treeNode);
            }
            ++n;
        }
    }

    public void delete(int n) {
        if (n < 0 || n >= this.nodeList.size()) {
            return;
        }
        TreeNode treeNode = (TreeNode)this.nodeList.elementAt(n);
        int n2 = this.deleteSubtree(treeNode);
        if (n2 > 0) {
            this.finalizeDelete(treeNode, n2);
        }
    }

    public void delete(TreeNode treeNode, int n) {
        int n2;
        TreeNode treeNode2;
        int n3 = this.nodeList.indexOf(treeNode);
        if (n3 < 0) {
            return;
        }
        int n4 = treeNode.getLevel() + 1;
        int n5 = -1;
        int n6 = 0;
        int n7 = n3 + 1;
        while (n7 < this.nodeList.size()) {
            treeNode2 = (TreeNode)this.nodeList.elementAt(n7);
            if (treeNode2.getLevel() == n4 && ++n5 == n) {
                n6 = n7;
                break;
            }
            ++n7;
        }
        if (n5 == n && (n2 = this.deleteSubtree(treeNode2 = (TreeNode)this.nodeList.elementAt(n6))) > 0) {
            this.finalizeDelete(treeNode2, n2);
        }
    }

    public void delete(String string, String string2) {
        String string3;
        TreeNode treeNode = null;
        int n = this.nodeList == null ? 0 : this.nodeList.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            treeNode = (TreeNode)this.nodeList.elementAt(n3);
            string3 = treeNode.getName();
            if (string3 != null && string3.equals(string)) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        int n4 = 0;
        if (n3 < n && treeNode != null) {
            n4 = treeNode.getLevel() + 1;
        }
        treeNode = null;
        n3 = n2 + 1;
        while (n3 < n) {
            treeNode = (TreeNode)this.nodeList.elementAt(n3);
            string3 = treeNode.getName();
            if (string3 != null && treeNode.getLevel() == n4 && string3.equals(string2)) break;
            if (treeNode.getLevel() < n4) {
                treeNode = null;
                break;
            }
            ++n3;
        }
        if (n3 >= n || treeNode == null) {
            return;
        }
        this.finalizeDelete(treeNode, this.deleteSubtree(treeNode));
    }

    private synchronized int deleteSubtree(TreeNode treeNode) {
        int n = this.nodeList.indexOf(treeNode);
        if (n < 0) {
            return 0;
        }
        int n2 = 1;
        int n3 = treeNode.getLevel();
        this.nodeList.removeElement(treeNode);
        while (!this.nodeList.isEmpty()) {
            TreeNode treeNode2;
            if (n >= this.nodeList.size() || (treeNode2 = (TreeNode)this.nodeList.elementAt(n)).getLevel() <= n3) break;
            ++n2;
            this.nodeList.removeElement(treeNode2);
        }
        return n2;
    }

    public synchronized void deleteAll() {
        this.nodeList.removeAllElements();
        this.selectedIndex = -1;
        this.selectedNode = null;
        this.rowsHeight = 0;
        this.adjustValues();
    }

    private final void finalizeDelete(TreeNode treeNode, int n) {
        if (treeNode == this.selectedNode) {
            this.selectedNode = null;
            this.selectedIndex = -1;
        }
        this.rowsHeight -= n * this.rowHeight;
        this.adjustValues();
    }

    public void replace(TreeNode treeNode, TreeNode treeNode2) {
        int n = this.nodeList.indexOf(treeNode);
        if (n < 0) {
            return;
        }
        this.copyStateVars(treeNode, treeNode2);
        this.nodeList.setElementAt(treeNode2, n);
        this.repaint();
    }

    public void replace(TreeNode treeNode, int n) {
        if (n < 0 || n >= this.nodeList.size()) {
            return;
        }
        TreeNode treeNode2 = (TreeNode)this.nodeList.elementAt(n);
        this.copyStateVars(treeNode2, treeNode);
        this.nodeList.setElementAt(treeNode, n);
        this.repaint();
    }

    public void replace(TreeNode treeNode, TreeNode treeNode2, int n) {
        int n2 = this.nodeList.indexOf(treeNode);
        if (n2 < 0) {
            return;
        }
        int n3 = treeNode.getLevel() + 1;
        int n4 = -1;
        int n5 = 0;
        TreeNode treeNode3 = null;
        int n6 = n2 + 1;
        while (n6 < this.nodeList.size()) {
            treeNode3 = (TreeNode)this.nodeList.elementAt(n6);
            if (treeNode3.getLevel() == n3 && ++n4 == n) {
                n5 = n6;
                break;
            }
            ++n6;
        }
        if (n4 == n) {
            this.copyStateVars(treeNode3, treeNode2);
            this.nodeList.setElementAt(treeNode2, n5);
        }
        this.repaint();
    }

    private final void copyStateVars(TreeNode treeNode, TreeNode treeNode2) {
        treeNode2.setCollapsed(treeNode.isCollapsed());
        treeNode2.setSelected(treeNode.isSelected());
        treeNode2.setVisible(treeNode.isVisible());
        treeNode2.setDim(treeNode.isDim());
        treeNode2.setLevel(treeNode.getLevel());
        treeNode2.setRef(treeNode.getRef());
    }

    public TreeNode getSelectedNode() {
        return this.selectedNode;
    }

    public TreeNode get(String string) {
        int n = this.nodeList.size();
        int n2 = 0;
        while (n2 < n) {
            TreeNode treeNode = (TreeNode)this.nodeList.elementAt(n2);
            String string2 = treeNode.getName();
            if (string2 != null && string2.equals(string)) {
                return treeNode;
            }
            ++n2;
        }
        return null;
    }

    public Vector getNodes(String string) {
        Vector<TreeNode> vector = new Vector<TreeNode>(1);
        int n = 0;
        while (n < this.nodeList.size()) {
            TreeNode treeNode = (TreeNode)this.nodeList.elementAt(n);
            String string2 = treeNode.getName();
            if (string2 != null && string2.equals(string)) {
                vector.addElement(treeNode);
            }
            ++n;
        }
        if (vector.size() > 0) {
            return vector;
        }
        return null;
    }

    public TreeNode get(TreeNode treeNode, String string) {
        if (treeNode == null) {
            return this.get(string);
        }
        int n = this.nodeList.indexOf(treeNode);
        if (n < 0) {
            return null;
        }
        int n2 = treeNode.getLevel() + 1;
        int n3 = n + 1;
        while (n3 < this.nodeList.size()) {
            TreeNode treeNode2 = (TreeNode)this.nodeList.elementAt(n3);
            if (treeNode2.getLevel() != n2) break;
            String string2 = treeNode2.getName();
            if (string2 != null && string2.equals(string)) {
                return treeNode2;
            }
            ++n3;
        }
        return null;
    }

    public TreeNode get(int n) {
        return (TreeNode)this.nodeList.elementAt(n);
    }

    public int getIndex(TreeNode treeNode) {
        return this.nodeList.indexOf(treeNode);
    }

    public TreeNode get(TreeNode treeNode, int n) {
        int n2 = this.nodeList.indexOf(treeNode);
        if (n2 < 0) {
            return null;
        }
        int n3 = treeNode.getLevel() + 1;
        int n4 = -1;
        int n5 = 0;
        int n6 = n2 + 1;
        while (n6 < this.nodeList.size()) {
            TreeNode treeNode2 = (TreeNode)this.nodeList.elementAt(n6);
            if (treeNode2.getLevel() == n3 && ++n4 == n) {
                n5 = n6;
                break;
            }
            ++n6;
        }
        if (n4 == n) {
            return (TreeNode)this.nodeList.elementAt(n5);
        }
        return null;
    }

    public int getCount() {
        return this.nodeList.size();
    }

    public Vector getAllChildren(TreeNode treeNode) {
        Vector<TreeNode> vector = new Vector<TreeNode>(3);
        int n = this.nodeList.indexOf(treeNode);
        int n2 = treeNode.getLevel();
        int n3 = n + 1;
        while (n3 < this.nodeList.size()) {
            TreeNode treeNode2 = (TreeNode)this.nodeList.elementAt(n3);
            if (treeNode2.getLevel() <= n2) break;
            vector.addElement(treeNode2);
            ++n3;
        }
        return vector;
    }

    public void destroy() {
        this.vbar = null;
        if (this.nodeList != null) {
            int n = 0;
            while (n < this.nodeList.size()) {
                TreeNode treeNode = (TreeNode)this.nodeList.elementAt(n);
                treeNode.destroy();
                ++n;
            }
            this.nodeList.removeAllElements();
            this.nodeList = null;
        }
        this.image = null;
        foreground = null;
        background = null;
        fgDimColor = null;
        this.font = null;
        this.mouseListener = null;
        this.itemListener = null;
    }

    public void addNotify() {
        super.addNotify();
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            this.rowHeight = Math.max(this.MIN_HEIGHT, fontMetrics.getHeight());
        }
    }

    public void removeNotify() {
        this.destroy();
        super.removeNotify();
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, mouseListener);
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public Object[] getSelectedObjects() {
        return new Object[]{this.selectedNode};
    }

    public void setColors(Color color, Color color2) {
        foreground = color;
        background = color2;
        this.repaint();
    }

    public void setFont(Font font) {
        this.font = font;
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            this.rowHeight = Math.max(this.MIN_HEIGHT, fontMetrics.getHeight());
            if (this.nodeList != null && this.nodeList.size() > 0) {
                Vector vector = this.nodeList;
                synchronized (vector) {
                    int n = this.nodeList.size();
                    int n2 = 0;
                    while (n2 < n) {
                        ((TreeNode)this.nodeList.elementAt(n2)).setHeight(this.rowHeight);
                        ++n2;
                    }
                    this.rowsHeight = this.rowHeight * n;
                    this.adjustValues();
                }
            }
        }
        this.largestAlignPos = 0;
    }

    private void updateAlignPos() {
        this.largestAlignPos = 0;
        int n = 0;
        int n2 = 0;
        while (n2 < this.nodeList.size()) {
            n = ((TreeNode)this.nodeList.elementAt(n2)).getAlignPos();
            if (this.largestAlignPos < n) {
                this.largestAlignPos = n;
            }
            ++n2;
        }
        this.repaint();
    }

    void setAlignPos(int n) {
        if (n > this.largestAlignPos) {
            this.largestAlignPos = n;
            this.repaint();
        }
    }

    int getAlignPos() {
        return this.largestAlignPos;
    }

    public void setMinHeight(int n) {
        this.MIN_HEIGHT = n;
    }

    public int getMinHeight() {
        return this.MIN_HEIGHT;
    }

    public void setGroupCollapsed(TreeNode treeNode, boolean bl) {
        if (treeNode == null) {
            return;
        }
        int n = this.nodeList.size();
        treeNode.setCollapsed(bl);
        int n2 = this.nodeList.indexOf(treeNode);
        int n3 = treeNode.getLevel();
        int n4 = n2 + 1;
        while (n4 < n) {
            TreeNode treeNode2 = (TreeNode)this.nodeList.elementAt(n4);
            if (treeNode2.getLevel() <= n3) break;
            treeNode2.setVisible(!bl);
            if (!bl && treeNode2.isCollapsed()) {
                ++n4;
                int n5 = treeNode2.getLevel();
                while (n4 < n) {
                    treeNode2 = (TreeNode)this.nodeList.elementAt(n4);
                    if (treeNode2.getLevel() <= n5) {
                        --n4;
                        break;
                    }
                    ++n4;
                }
            }
            ++n4;
        }
        this.adjustValues();
    }

    private final boolean hasChildren(TreeNode treeNode) {
        if (treeNode == null) {
            return false;
        }
        int n = this.nodeList.indexOf(treeNode) + 1;
        if (n < 0 || n >= this.nodeList.size()) {
            return false;
        }
        return ((TreeNode)this.nodeList.elementAt(n)).getLevel() == treeNode.getLevel() + 1;
    }

    private final int firstVisibleNodeIndex() {
        int n = this.nodeList.size();
        int n2 = 0;
        while (n2 < n) {
            if (((TreeNode)this.nodeList.elementAt(n2)).isVisible()) {
                return n2;
            }
            ++n2;
        }
        return 0;
    }

    private final int getNumberOfVisibleNodes() {
        int n = 0;
        int n2 = this.nodeList.size();
        int n3 = 0;
        while (n3 < n2) {
            if (((TreeNode)this.nodeList.elementAt(n3)).isVisible()) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    private final int getNumberOfInvisibleNodes(int n, int n2) {
        this.nodeList.size();
        int n3 = 0;
        int n4 = n + 1;
        while (n4 < n2) {
            TreeNode treeNode = (TreeNode)this.nodeList.elementAt(n4);
            if (!treeNode.isVisible()) {
                ++n3;
            }
            ++n4;
        }
        return n3;
    }

    private int getInsertionIndex(TreeNode treeNode) {
        int n = this.nodeList.indexOf(treeNode);
        if (n < 0) {
            return -1;
        }
        int n2 = treeNode.getLevel();
        int n3 = n + 1;
        n3 = n + 1;
        while (n3 < this.nodeList.size()) {
            TreeNode treeNode2 = (TreeNode)this.nodeList.elementAt(n3);
            if (treeNode2.getLevel() <= n2) break;
            ++n3;
        }
        return n3;
    }

    public void makeVisible(int n) {
        int n2 = this.nodeList.size();
        ScrollTree.assert(n >= 0 && n < this.nodeList.size());
        int n3 = this.getNumberOfInvisibleNodes(this.topIndex, n);
        if (n < this.topIndex) {
            this.topIndex = n;
        } else if (n - n3 >= this.topIndex + this.visible) {
            this.topIndex = n - this.visible + 1;
            if (this.topIndex >= n2) {
                this.topIndex = 0;
            }
        }
        this.vbar.setValues(this.topIndex, this.visible, 0, this.getNumberOfVisibleNodes());
        this.repaint();
    }

    public void select(int n) {
        ScrollTree.assert(n >= 0 && n < this.nodeList.size());
        TreeNode treeNode = (TreeNode)this.nodeList.elementAt(n);
        if (treeNode != null) {
            if (this.selectedNode != null) {
                this.selectedNode.deselect();
            }
            this.selectedNode = treeNode;
            this.selectedNode.select();
            this.selectedIndex = n;
        }
    }

    private void adjustValues() {
        Dimension dimension = this.getSize();
        int n = this.nodeList.size();
        int n2 = this.getNumberOfVisibleNodes();
        int n3 = this.vbar.getValue();
        if (n == 0) {
            return;
        }
        this.visible = (int)((double)dimension.height / (double)this.rowsHeight * (double)n);
        int n4 = Math.max(0, n2);
        if (this.visible >= n4) {
            this.topIndex = this.firstVisibleNodeIndex();
        }
        this.updateAlignPos();
        this.vbar.setValues(n3, this.visible, 0, n4);
        this.repaint();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(100, 80);
        dimension.width += this.vbar.getPreferredSize().width;
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void invalidate() {
        super.invalidate();
        this.image = null;
        this.adjustValues();
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = -1;
        int n2 = keyEvent.getKeyCode();
        if (keyEvent.isActionKey()) {
            if (n2 == 37 || n2 == 38) {
                if (this.selectedIndex < 0) {
                    this.vbar.setValue(Math.max(0, this.vbar.getValue() - 1));
                    this.adjustmentValueChanged(new AdjustmentEvent(this.vbar, 0, 2, this.vbar.getValue()));
                    return;
                }
                n = this.selectedIndex;
                while (n > 0) {
                    if (!((TreeNode)this.nodeList.elementAt(--n)).isVisible()) continue;
                    this.selectedIndex = n;
                    this.select(this.selectedIndex);
                    this.makeVisible(this.selectedIndex);
                    return;
                }
                return;
            }
            if (n2 == 39 || n2 == 40) {
                if (this.selectedIndex < 0) {
                    this.vbar.setValue(Math.min(this.vbar.getMaximum(), this.vbar.getValue() + 1));
                    this.adjustmentValueChanged(new AdjustmentEvent(this.vbar, 0, 1, this.vbar.getValue()));
                    return;
                }
                n = this.selectedIndex;
                while (n + 1 < this.nodeList.size()) {
                    if (!((TreeNode)this.nodeList.elementAt(++n)).isVisible()) continue;
                    this.selectedIndex = n;
                    this.select(this.selectedIndex);
                    this.makeVisible(this.selectedIndex);
                    return;
                }
                return;
            }
            if (n2 == 33) {
                if (this.selectedIndex < 0) {
                    this.vbar.setValue(Math.max(0, this.vbar.getValue() - 7));
                    this.adjustmentValueChanged(new AdjustmentEvent(this.vbar, 0, 3, this.vbar.getValue()));
                    return;
                }
                n = this.selectedIndex;
                int n3 = 0;
                int n4 = n;
                while (n > 0 && n3 < 7) {
                    if (!((TreeNode)this.nodeList.elementAt(--n)).isVisible()) continue;
                    ++n3;
                    n4 = n;
                }
                this.selectedIndex = n4;
                this.select(this.selectedIndex);
                this.makeVisible(this.selectedIndex);
                return;
            }
            if (n2 == 34) {
                if (this.selectedIndex < 0) {
                    this.vbar.setValue(Math.min(this.vbar.getMaximum(), this.vbar.getValue() + 7));
                    this.adjustmentValueChanged(new AdjustmentEvent(this.vbar, 0, 1, this.vbar.getValue()));
                    return;
                }
                n = this.selectedIndex;
                int n5 = 0;
                int n6 = n;
                while (n + 1 < this.nodeList.size() && n5 < 7) {
                    if (!((TreeNode)this.nodeList.elementAt(++n)).isVisible()) continue;
                    ++n5;
                    n6 = n;
                }
                this.selectedIndex = n6;
                this.select(this.selectedIndex);
                this.makeVisible(this.selectedIndex);
                return;
            }
            if (n2 == 36) {
                if (this.selectedIndex < 0) {
                    this.vbar.setValue(0);
                    this.adjustmentValueChanged(new AdjustmentEvent(this.vbar, 0, 601, 0));
                    return;
                }
                n = 0;
                while (n < this.nodeList.size()) {
                    if (((TreeNode)this.nodeList.elementAt(n)).isVisible()) {
                        this.selectedIndex = n;
                        this.select(this.selectedIndex);
                        this.makeVisible(this.selectedIndex);
                        return;
                    }
                    ++n;
                }
                return;
            }
            if (n2 == 35) {
                if (this.selectedIndex < 0) {
                    this.vbar.setValue(this.vbar.getMaximum());
                    this.adjustmentValueChanged(new AdjustmentEvent(this.vbar, 0, 601, this.vbar.getMaximum()));
                    return;
                }
                n = this.nodeList.size() - 1;
                while (n > 0) {
                    if (((TreeNode)this.nodeList.elementAt(n)).isVisible()) {
                        this.selectedIndex = n;
                        this.select(this.selectedIndex);
                        this.makeVisible(this.selectedIndex);
                        return;
                    }
                    --n;
                }
                return;
            }
        } else if (n2 == 32 || n2 == 10) {
            if (this.selectedIndex < 0 || this.selectedNode == null) {
                return;
            }
            if (this.hasChildren(this.selectedNode)) {
                this.setGroupCollapsed(this.selectedNode, !this.selectedNode.isCollapsed());
                return;
            }
            if (this.itemListener != null) {
                this.itemListener.itemStateChanged(new ItemEvent(this, 701, this.selectedNode, 1));
                if (this.selectedNode != null) {
                    this.selectedNode.hasChosen();
                }
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = -1;
        int n2 = 0;
        int n3 = this.nodeList.size();
        int n4 = this.topIndex;
        while (n2 < this.visible && n4 < n3) {
            TreeNode treeNode = (TreeNode)this.nodeList.elementAt(n4);
            if (treeNode.isVisible()) {
                if (treeNode.isWithin(mouseEvent.getX(), mouseEvent.getY())) {
                    n = n4;
                    break;
                }
                ++n2;
            }
            ++n4;
        }
        if (n >= 0 && n < n3) {
            if (n != this.selectedIndex) {
                if (this.selectedNode != null) {
                    this.selectedNode.deselect();
                }
                this.selectedNode = (TreeNode)this.nodeList.elementAt(n);
                this.selectedIndex = n;
            }
            if (mouseEvent.getClickCount() > 1) {
                this.selectedNode.select();
                if (this.hasChildren(this.selectedNode)) {
                    this.setGroupCollapsed(this.selectedNode, !this.selectedNode.isCollapsed());
                } else if (this.itemListener != null) {
                    this.itemListener.itemStateChanged(new ItemEvent(this, 701, this.selectedNode, 1));
                    if (this.selectedNode != null) {
                        this.selectedNode.hasChosen();
                    }
                }
            } else if (mouseEvent.getModifiers() == 4) {
                this.selectedNode.select();
            } else {
                this.selectedNode.toggle();
            }
            if (!this.selectedNode.selected) {
                this.selectedIndex = -1;
                this.selectedNode = null;
            }
            this.repaint();
            if (mouseEvent.getModifiers() == 4 && this.mouseListener != null) {
                this.mouseListener.mousePressed(mouseEvent);
            }
        }
        this.requestFocus();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mouseListener != null) {
            this.mouseListener.mouseReleased(mouseEvent);
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.requestFocus();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.topIndex = this.vbar.getValue();
        this.repaint();
    }

    public void redrawItems() {
        this.repaint();
    }

    public boolean contains(int n, int n2) {
        Dimension dimension = this.getSize();
        return n > 0 && n < dimension.width && n2 > 0 && n2 < dimension.height;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        TreeNode treeNode;
        Dimension dimension = this.getSize();
        int n = this.nodeList.size();
        if (this.image == null) {
            this.image = this.createImage(dimension.width, dimension.height);
            int n2 = 0;
            while (n2 < n) {
                treeNode = (TreeNode)this.nodeList.elementAt(n2);
                treeNode.setWidth(dimension.width);
                ++n2;
            }
        }
        Graphics graphics2 = this.image.getGraphics();
        graphics2.setColor(background);
        if (this.font != null) {
            graphics2.setFont(this.font);
        }
        graphics2.fillRect(0, 0, dimension.width, dimension.height);
        Vector vector = this.nodeList;
        synchronized (vector) {
            n = this.nodeList.size();
            int n3 = 0;
            int n4 = this.topIndex;
            while (n3 < this.visible && n4 < n) {
                treeNode = (TreeNode)this.nodeList.elementAt(n4);
                if (treeNode.isVisible()) {
                    treeNode.paint(graphics2, n3++);
                }
                ++n4;
            }
        }
        graphics.drawImage(this.image, 0, 0, this);
        graphics2.dispose();
    }

    static void assert(boolean bl) throws IllegalArgumentException {
        if (!bl) {
            throw new IllegalArgumentException("Assertion failed ");
        }
    }
}

