/*
 * Decompiled with CFR 0.152.
 */
package proxy;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import proxy.SOCKSConnector;
import uiutil.ChangeListener;
import uiutil.PasswordField;
import uiutil.PropertySheet;
import uiutil.Spacer;
import uiutil.TransparentPanel;
import util.JUtil;
import util.KeyBindings;

public class SOCKSProps
extends PropertySheet
implements ItemListener,
KeyListener {
    private KeyBindings keys;
    private ChangeListener changeListener;
    private Label serverLabel;
    private Label hostLabel;
    private Label portLabel;
    private TextField hostField;
    private TextField portField;
    private Label protocolLabel;
    private Checkbox socks4Check;
    private Checkbox socks5Check;
    private CheckboxGroup versionGroup;
    private Label authLabel;
    private Label usernameLabel;
    private Label passwordLabel;
    private TextField usernameField;
    private PasswordField passwordField;
    private Checkbox dnsCheck;
    private boolean changed = false;
    private boolean doFullSocks;

    public SOCKSProps(KeyBindings keyBindings, ChangeListener changeListener) {
        this.keys = keyBindings;
        this.changeListener = changeListener;
        ((Container)((Object)this)).setLayout(new BorderLayout(0, 10));
        ((Container)((Object)this)).add("North", (Component)new Spacer());
        ((Container)((Object)this)).add("West", (Component)new Spacer());
        TransparentPanel transparentPanel = new TransparentPanel();
        ((Container)((Object)this)).add("Center", (Component)transparentPanel);
        transparentPanel.setLayout(new BorderLayout(0, 0));
        TransparentPanel transparentPanel2 = new TransparentPanel();
        transparentPanel.add("Center", (Component)transparentPanel2);
        transparentPanel2.setLayout(new GridLayout(0, 1, 0, 0));
        TransparentPanel transparentPanel3 = new TransparentPanel();
        transparentPanel2.add((Component)transparentPanel3);
        transparentPanel3.setLayout(new FlowLayout(0));
        TransparentPanel transparentPanel4 = new TransparentPanel();
        transparentPanel3.add((Component)transparentPanel4);
        transparentPanel4.setLayout(new BorderLayout());
        this.serverLabel = new Label("Proxy Server", 0);
        transparentPanel4.add("North", this.serverLabel);
        transparentPanel4.add("West", (Component)new Spacer());
        TransparentPanel transparentPanel5 = new TransparentPanel();
        transparentPanel4.add("Center", (Component)transparentPanel5);
        TransparentPanel transparentPanel6 = new TransparentPanel();
        transparentPanel5.add((Component)transparentPanel6);
        transparentPanel6.setLayout(new GridLayout(0, 1, 0, 0));
        this.hostLabel = new Label("Host: ", 0);
        transparentPanel6.add(this.hostLabel);
        this.portLabel = new Label("Port: ", 0);
        transparentPanel6.add(this.portLabel);
        transparentPanel6 = new TransparentPanel();
        transparentPanel5.add((Component)transparentPanel6);
        transparentPanel6.setLayout(new GridLayout(0, 1, 0, 0));
        this.hostField = new TextField("", 14);
        transparentPanel6.add(this.hostField);
        this.hostField.addKeyListener(this);
        this.portField = new TextField("", 14);
        transparentPanel6.add(this.portField);
        this.portField.addKeyListener(this);
        transparentPanel4 = new TransparentPanel();
        transparentPanel3.add((Component)transparentPanel4);
        transparentPanel4.setLayout(new BorderLayout(0, 0));
        this.protocolLabel = new Label("Protocol", 0);
        transparentPanel4.add("North", this.protocolLabel);
        transparentPanel4.add("West", (Component)new Spacer());
        transparentPanel5 = new TransparentPanel();
        transparentPanel4.add("Center", (Component)transparentPanel5);
        transparentPanel5.setLayout(new GridLayout(0, 1, 0, 0));
        this.versionGroup = new CheckboxGroup();
        this.socks4Check = new Checkbox("SOCKS 4", false, this.versionGroup);
        transparentPanel5.add(this.socks4Check);
        this.socks4Check.addItemListener(this);
        this.socks5Check = new Checkbox("SOCKS 5", false, this.versionGroup);
        transparentPanel5.add(this.socks5Check);
        this.socks5Check.addItemListener(this);
        transparentPanel4.add("South", (Component)new Spacer());
        transparentPanel3 = new TransparentPanel();
        transparentPanel2.add((Component)transparentPanel3);
        transparentPanel3.setLayout(new FlowLayout(0, 0, 0));
        transparentPanel4 = new TransparentPanel();
        transparentPanel3.add((Component)transparentPanel4);
        transparentPanel4.setLayout(new BorderLayout());
        this.authLabel = new Label("Authentication", 0);
        transparentPanel4.add("North", this.authLabel);
        transparentPanel4.add("West", (Component)new Spacer());
        transparentPanel5 = new TransparentPanel();
        transparentPanel4.add("Center", (Component)transparentPanel5);
        transparentPanel6 = new TransparentPanel();
        transparentPanel5.add((Component)transparentPanel6);
        transparentPanel6.setLayout(new GridLayout(0, 1, 0, 0));
        this.usernameLabel = new Label("Username:", 0);
        transparentPanel6.add(this.usernameLabel);
        this.passwordLabel = new Label("Password:", 0);
        transparentPanel6.add(this.passwordLabel);
        transparentPanel6 = new TransparentPanel();
        transparentPanel5.add((Component)transparentPanel6);
        transparentPanel6.setLayout(new GridLayout(0, 1, 0, 0));
        this.usernameField = new TextField(24);
        transparentPanel6.add(this.usernameField);
        this.usernameField.addKeyListener(this);
        this.passwordField = new PasswordField(24);
        transparentPanel6.add((Component)this.passwordField);
        this.passwordField.setEchoChar('*');
        this.passwordField.addKeyListener(this);
        transparentPanel3.add((Component)new Spacer());
        this.dnsCheck = new Checkbox("Use SOCKS to resolve host names");
        transparentPanel.add("South", this.dnsCheck);
        this.dnsCheck.addItemListener(this);
        if (!this.doFullSocks) {
            this.socks4Check.setEnabled(false);
            this.socks5Check.setEnabled(false);
            this.dnsCheck.setEnabled(false);
        }
        this.setValues();
    }

    public boolean changed() {
        return this.changed;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        this.setChanged(true);
        if (itemSelectable == this.socks4Check) {
            this.setEnabledAuth(false);
            return;
        }
        if (itemSelectable == this.socks5Check) {
            this.setEnabledAuth(true);
        }
    }

    public boolean help() {
        return false;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n') {
            Component component = keyEvent.getComponent();
            if (component == this.hostField) {
                this.portField.requestFocus();
            } else if (component == this.portField) {
                this.usernameField.requestFocus();
            } else if (component == this.usernameField) {
                this.passwordField.requestFocus();
            } else if (component == this.passwordField) {
                this.hostField.requestFocus();
            }
        }
        this.setChanged(true);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void removeNotify() {
        ((Container)((Object)this)).removeAll();
        this.changeListener = null;
        this.serverLabel = null;
        this.hostLabel = null;
        this.portLabel = null;
        this.hostField = null;
        this.portField = null;
        this.protocolLabel = null;
        this.socks4Check = null;
        this.socks5Check = null;
        this.versionGroup = null;
        this.authLabel = null;
        this.usernameLabel = null;
        this.passwordLabel = null;
        this.usernameField = null;
        this.passwordField = null;
        this.dnsCheck = null;
        ((Container)((Object)this)).setLayout(null);
        super.removeNotify();
    }

    public boolean save() {
        String string = this.hostField.getText();
        if (string != null && string.length() > 0) {
            this.keys.setValue(SOCKSConnector.HOSTNAME_KEY, string);
        } else {
            this.keys.deleteKey(SOCKSConnector.HOSTNAME_KEY);
        }
        string = this.portField.getText();
        if (JUtil.isInteger((String)string)) {
            this.keys.setValue(SOCKSConnector.PORT_KEY, string);
        } else {
            ((TextComponent)this.portField).setText("");
            this.keys.deleteKey(SOCKSConnector.PORT_KEY);
        }
        if (this.socks5Check.getState()) {
            this.keys.setValue(SOCKSConnector.VERSION_KEY, "5");
        } else {
            this.keys.setValue(SOCKSConnector.VERSION_KEY, "4");
        }
        string = this.usernameField.getText();
        if (string != null && string.length() > 0) {
            this.keys.setValue("username", string);
        } else {
            this.keys.deleteKey("username");
        }
        string = this.passwordField.getPassword();
        if (string != null && string.length() > 0) {
            JUtil.putPassword((KeyBindings)this.keys, (String)string, (String)"password");
        } else {
            this.keys.deleteKey("password");
        }
        if (this.dnsCheck.getState()) {
            this.keys.setValue(SOCKSConnector.USEDNS_KEY, "true");
        } else {
            this.keys.setValue(SOCKSConnector.USEDNS_KEY, "false");
        }
        this.setChanged(false);
        return true;
    }

    private void setChanged(boolean bl) {
        this.changed = bl;
        if (bl) {
            this.changeListener.setChanged(true);
        }
    }

    private void setEnabledAuth(boolean bl) {
        this.authLabel.setEnabled(bl);
        this.authLabel.setAlignment(0);
        this.usernameLabel.setEnabled(bl);
        this.usernameLabel.setAlignment(0);
        this.passwordLabel.setEnabled(bl);
        this.passwordLabel.setAlignment(0);
        this.usernameField.setEnabled(bl);
        this.usernameField.setEditable(bl);
        this.passwordField.setEnabled(bl);
        this.passwordField.setEditable(bl);
    }

    public void setValues() {
        String string = this.keys.getValue(SOCKSConnector.HOSTNAME_KEY);
        if (string != null && string.length() > 0) {
            ((TextComponent)this.hostField).setText(string);
        }
        if (JUtil.isInteger((String)(string = this.keys.getValue(SOCKSConnector.PORT_KEY)))) {
            ((TextComponent)this.portField).setText(string);
        }
        if ((string = this.keys.getValueDefault(SOCKSConnector.VERSION_KEY, "4")).equals("5")) {
            this.socks5Check.setState(true);
            this.setEnabledAuth(true);
        } else {
            this.socks4Check.setState(true);
            this.setEnabledAuth(false);
        }
        string = this.keys.getValue("username");
        if (string != null && string.length() > 0) {
            ((TextComponent)this.usernameField).setText(string);
        }
        if ((string = JUtil.getPassword((KeyBindings)this.keys, (String)"password")) != null && string.length() > 0) {
            this.passwordField.setPassword(string);
        }
        if ((string = this.keys.getValue(SOCKSConnector.USEDNS_KEY)) != null && string.length() > 0) {
            this.dnsCheck.setState(string.equalsIgnoreCase("true"));
        }
        this.setChanged(false);
    }
}

