/*
 * Decompiled with CFR 0.152.
 */
package rath.jmsn;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import rath.jmsn.ActionGroup;
import rath.jmsn.BuddyTree;
import rath.jmsn.EventViewer;
import rath.jmsn.LoginSplash;
import rath.jmsn.MSNMenuBar;
import rath.jmsn.NativeToolkit;
import rath.jmsn.ui.AddConfirmDialog;
import rath.jmsn.util.GlobalProp;
import rath.jmsn.util.Msg;
import rath.jmsn.util.MusicBox;
import rath.jmsn.util.UserStatusBox;
import rath.msnm.LocalCopy;
import rath.msnm.MSNMessenger;
import rath.msnm.entity.MsnFriend;
import rath.msnm.event.MsnAdapter;
import rath.msnm.event.MsnListener;
import rath.msnm.ftp.FileMessageProcessor;
import rath.tools.tray.NativeIcon;
import rath.tools.tray.TrayIcon;

public class MainFrame
extends JFrame {
    public static final String DOWNLOAD_PROP = "download.dir";
    public static final String CHATLOG_PROP = "chatlog.dir";
    public static final String BACKIMAGE_PROP = "background.image";
    public static final String SOUND_LOGIN_PROP = "Sound.login";
    public static final String SOUND_MESSAGE_PROP = "Sound.message";
    public static final String AUTO_ACCEPT_FILE_PROP = "File.auto.accept";
    public static final String SOUND_MESSAGE_1_PROP = "Sound.message.1";
    public static final String SOUND_MESSAGE_2_PROP = "Sound.message.2";
    public static final String TIMESTAMP_DISPLAY = "timestamp.display";
    public static final String EMOTICON_DISPLAY = "emoticon.display";
    public static final String BUDDYLIST_FONT_COLOR = "buddylist.font.color";
    public static final String USE_FIXED_CHAT_FONT = "font.fixed.on.chat";
    public static LocalCopy LOCALCOPY;
    public static MainFrame INSTANCE;
    public BuddyTree buddies = null;
    private static GlobalProp global;
    MSNMenuBar menuBar = null;
    LoginSplash splash = null;
    private ActionGroup actions = null;
    private MSNMessenger msnm = null;
    private JScrollPane buddyPane = null;
    private EventViewer eventView = null;
    private Image frameIcon = null;
    private MouseAdapter loginTrigger = new LoginTrigger();
    private NativeToolkit nt = NativeToolkit.getInstance();

    public MainFrame(String title) {
        super(title);
        int i0;
        INSTANCE = this;
        this.frameIcon = new ImageIcon(this.getClass().getResource("/resources/icon/icon.jpg")).getImage();
        global.load();
        this.setIconImage(this.frameIcon);
        this.initialize();
        this.menuBar = new MSNMenuBar(this, this.actions);
        this.setJMenuBar(this.menuBar);
        FileMessageProcessor.setAutoReceive((boolean)false);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                Point p = MainFrame.this.getLocation();
                Dimension size = MainFrame.this.getSize();
                global.set("application.x", p.x);
                global.set("application.y", p.y);
                global.set("application.width", size.width);
                global.set("application.height", size.height);
                global.store();
            }
        }));
        String logstr = global.get("last.login");
        if (logstr != null && (i0 = logstr.indexOf(58)) != -1) {
            this.showLogging();
            this.msnm.login(logstr.substring(0, i0), logstr.substring(i0 + 1));
        }
    }

    private void initialize() {
        this.pack();
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        int x = global.getInt("application.x", 100);
        int y = global.getInt("application.y", 100);
        int w = global.getInt("application.width", 280);
        int h = global.getInt("application.height", 420);
        if (x + w > size.width) {
            x = size.width - w - 15;
        }
        if (y + h > size.height) {
            y = size.height - h - 15;
        }
        this.setSize(w, h);
        this.setLocation(x, y);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (((MainFrame)MainFrame.this).nt.isWindows) {
                    MainFrame.this.setVisible(false);
                } else {
                    if (MainFrame.this.msnm.isLoggedIn() && JOptionPane.showConfirmDialog((Component)e.getSource(), "JMSN will be terminated with all opened dialog.\nDo you really want to continue?", "Quit", 0) == 1) {
                        return;
                    }
                    System.exit(0);
                }
            }

            public void windowDeiconified(WindowEvent e) {
                MainFrame.this.actions.actionRefresh();
            }
        });
        if (this.nt.isWindows) {
            this.setTrayIcon();
        }
        this.msnm = new MSNMessenger("", "");
        this.msnm.setInitialStatus("NLN");
        this.msnm.addMsnListener((MsnListener)new MsnAdapter(){

            public void loginComplete(MsnFriend friend) {
                MainFrame.this.processInit(friend.getLoginName());
                MainFrame.this.showBuddyList();
            }

            public void loginError(String header) {
                if (header.equals("911")) {
                    JOptionPane.showMessageDialog(MainFrame.this, Msg.get("err.911"), Msg.get("title.loginfail"), 0);
                } else if (header.equals("921")) {
                    JOptionPane.showMessageDialog(MainFrame.this, Msg.get("err.921"), Msg.get("title.loginfail"), 0);
                }
                MainFrame.this.msnm.logout();
                MainFrame.this.showLogin();
            }

            public void whoAddedMe(MsnFriend friend) {
                AddConfirmDialog cd = new AddConfirmDialog(MainFrame.this, friend);
                cd.show();
            }
        });
        this.splash = new LoginSplash();
        this.buddies = new BuddyTree(this);
        this.actions = new ActionGroup(this, this.buddies);
        this.splash.addMouseListener(this.loginTrigger);
        JPanel panel = new JPanel(new BorderLayout()){

            public void updateUI() {
                UserStatusBox.collectAll();
                super.updateUI();
            }
        };
        this.setContentPane(panel);
        this.buddyPane = new JScrollPane(this.buddies);
        this.buddyPane.setBackground(Color.white);
        this.buddyPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.eventView = new EventViewer();
        this.eventView.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EventViewer.Event ex = (EventViewer.Event)MainFrame.this.eventView.getSelectedItem();
                if (ex == null) {
                    return;
                }
                MsnFriend f = ex.getFriend();
                if (f != null) {
                    MainFrame.this.buddies.createNewSession(f);
                }
            }
        });
        panel.add((Component)this.splash, "Center");
        panel.add((Component)this.eventView, "South");
        System.setProperty("jmsn.transparency", "-1");
    }

    public void show() {
        this.nt.makeTransparency(this, Integer.getInteger("jmsn.transparency", 255));
        super.show();
    }

    public static GlobalProp getGlobalProp() {
        return global;
    }

    private void processInit(String loginName) {
        String logdir;
        LocalCopy local = LOCALCOPY = this.msnm.getLocalCopy();
        File root = local.getHomeDirectory();
        root = new File(root, loginName);
        String downdir = local.getProperty(DOWNLOAD_PROP);
        if (downdir == null) {
            File dir = new File(root, "files");
            dir.mkdirs();
            downdir = dir.getAbsolutePath();
            local.setProperty(DOWNLOAD_PROP, downdir);
        }
        if ((logdir = local.getProperty(CHATLOG_PROP)) == null) {
            File dir = new File(root, "logs");
            dir.mkdirs();
            logdir = dir.getAbsolutePath();
            local.setProperty(CHATLOG_PROP, logdir);
        }
        new File(downdir).mkdirs();
        new File(logdir).mkdirs();
        boolean isEnableLoginSound = local.getPropertyBoolean("Sound.login.enable", true);
        boolean isEnableMessageSound = local.getPropertyBoolean("Sound.message.enable", true);
        boolean isEnableAutoAccept = local.getPropertyBoolean(AUTO_ACCEPT_FILE_PROP, false);
        boolean isEnableTimestamp = local.getPropertyBoolean(TIMESTAMP_DISPLAY, false);
        boolean isEnableEmoticon = local.getPropertyBoolean(EMOTICON_DISPLAY, true);
        String buddyFontColor = local.getProperty(BUDDYLIST_FONT_COLOR, "000000");
        try {
            Color c0 = new Color(Integer.parseInt(buddyFontColor));
            this.buddies.renderer.setForeColor(c0);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        local.setProperty("Sound.login.enable", String.valueOf(isEnableLoginSound));
        local.setProperty("Sound.message.enable", String.valueOf(isEnableMessageSound));
        local.setProperty(AUTO_ACCEPT_FILE_PROP, String.valueOf(isEnableAutoAccept));
        local.setProperty(TIMESTAMP_DISPLAY, String.valueOf(isEnableTimestamp));
        local.setProperty(EMOTICON_DISPLAY, String.valueOf(isEnableEmoticon));
        local.setProperty(BUDDYLIST_FONT_COLOR, buddyFontColor);
        MusicBox.setEnabled("Login", isEnableLoginSound);
        MusicBox.setEnabled("Message.1", isEnableMessageSound);
        MusicBox.setEnabled("Message.2", isEnableMessageSound);
        System.setProperty("jmsn.file.auto.accept", String.valueOf(isEnableAutoAccept));
        boolean offView = local.getPropertyBoolean("View.buddy.offline", true);
        this.buddies.setOfflineView(offView);
        this.menuBar.menuOffView.setSelected(!offView);
        String backImage = local.getProperty(BACKIMAGE_PROP);
        if (backImage != null && new File(backImage).exists()) {
            ImageIcon icon = new ImageIcon(backImage);
            this.buddies.setBackgroundImage(icon.getImage());
        } else {
            this.buddies.setBackgroundImage(null);
        }
        local.storeInformation();
        MusicBox.init();
    }

    public void addEvent(String msg, MsnFriend friend) {
        this.eventView.addEvent(msg, friend);
    }

    public void showLogin() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainFrame.this.menuBar.disableLogin();
                MainFrame.this.splash.setInitialText();
                MainFrame.this.splash.removeMouseListener(MainFrame.this.loginTrigger);
                MainFrame.this.splash.addMouseListener(MainFrame.this.loginTrigger);
                MainFrame.this.splash.repaint();
                JPanel panel = (JPanel)MainFrame.this.getContentPane();
                panel.doLayout();
                panel.validate();
            }
        });
    }

    public void showLogging() {
        this.splash.removeMouseListener(this.loginTrigger);
        this.menuBar.setLoginEnabled(false);
        this.splash.setText(Msg.get("label.splash.onlogin"));
    }

    public void showBuddyList() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JPanel panel = (JPanel)MainFrame.this.getContentPane();
                panel.remove(MainFrame.this.splash);
                panel.add((Component)MainFrame.this.buddyPane, "Center");
                panel.doLayout();
                panel.validate();
            }
        });
    }

    public void logout() {
        JPanel panel = (JPanel)this.getContentPane();
        panel.remove(this.buddyPane);
        panel.add((Component)this.splash, "Center");
        panel.doLayout();
        panel.validate();
        this.splash.setText(Msg.get("label.splash.onlogout"));
        this.msnm.logout();
        this.showLogin();
    }

    public MSNMessenger getMessenger() {
        return this.msnm;
    }

    public void setMyStatus(String mode) {
        this.buddies.setMyStatus(mode);
    }

    public void updateUIAll() {
        SwingUtilities.updateComponentTreeUI(this);
        this.buddies.updateAllDialogs();
    }

    public void setTrayIcon() {
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/resources/icon/icon.jpg"));
        TrayIcon tray = new TrayIcon(new NativeIcon(icon.getImage()), "JMSN");
        this.nt.addTrayIcon(tray);
    }

    static {
        global = new GlobalProp();
    }

    private class LoginTrigger
    extends MouseAdapter {
        private LoginTrigger() {
        }

        public void mouseClicked(MouseEvent e) {
            MainFrame.this.actions.actionLogin();
        }
    }
}

