/*
 * Decompiled with CFR 0.152.
 */
package rath.jmsn.ui;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import rath.jmsn.MainFrame;
import rath.jmsn.ToolBox;
import rath.jmsn.ui.DefaultDialog;
import rath.jmsn.util.Msg;
import rath.msnm.MSNMessenger;
import rath.msnm.entity.MsnFriend;

public class AddConfirmDialog
extends DefaultDialog
implements ToolBox {
    private MainFrame main = null;
    private MsnFriend friend = null;
    private JRadioButton approveButton = null;
    private JRadioButton rejectButton = null;

    public AddConfirmDialog(MainFrame main, MsnFriend friend) {
        super(main);
        this.main = main;
        this.friend = friend;
        this.setModal(false);
        this.createUI();
    }

    private void createUI() {
        this.setSize(400, 140);
        JPanel panel = (JPanel)this.getContentPane();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        BoxLayout bl = new BoxLayout(panel, 1);
        panel.setLayout(bl);
        JLabel label = new JLabel(Msg.get("who.added.me", this.friend.getLoginName()));
        label.setFont(ToolBox.FONT);
        panel.add(label);
        this.approveButton = new JRadioButton(Msg.get("add.approve"));
        this.approveButton.setFont(ToolBox.FONT);
        this.approveButton.setSelected(true);
        this.rejectButton = new JRadioButton(Msg.get("add.reject"));
        this.rejectButton.setFont(ToolBox.FONT);
        this.rejectButton.setEnabled(false);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.approveButton);
        bg.add(this.rejectButton);
        panel.add(this.approveButton);
        panel.add(this.rejectButton);
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 5, 5));
        JButton confirmButton = new JButton(Msg.get("button.ok"));
        confirmButton.setFont(ToolBox.FONT);
        confirmButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddConfirmDialog.this.processConfirm();
            }
        });
        JButton cancelButton = new JButton(Msg.get("button.cancel"));
        cancelButton.setFont(ToolBox.FONT);
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddConfirmDialog.this.dispose();
            }
        });
        buttonPanel.add(confirmButton);
        buttonPanel.add(cancelButton);
        buttonPanel.setAlignmentX(0.0f);
        buttonPanel.setPreferredSize(new Dimension(Short.MAX_VALUE, 30));
        panel.add(buttonPanel);
    }

    protected void processConfirm() {
        boolean isApprove = this.approveButton.isSelected();
        MSNMessenger msnm = this.main.getMessenger();
        if (isApprove) {
            try {
                msnm.addFriend(this.friend.getLoginName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.dispose();
    }
}

