/*
 * Decompiled with CFR 0.152.
 */
package rath.jmsn.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import rath.jmsn.ToolBox;
import rath.jmsn.ui.DefaultDialog;
import rath.jmsn.util.Msg;
import rath.msnm.MSNMessenger;
import rath.msnm.event.MsnAdapter;
import rath.msnm.event.MsnListener;

public class AddFriendDialog
extends DefaultDialog
implements ToolBox,
ActionListener {
    private MSNMessenger msnm = null;
    private JTextField emailField = null;
    private JButton addButton;
    private JButton cancelButton;
    private JLabel commentLabel = null;
    private JProgressBar progress = null;
    private Timer timer = null;
    private MsnAdapter baseAdapter = new Adapter();

    public AddFriendDialog(Frame owner, MSNMessenger msnm) {
        super(owner);
        this.setTitle(Msg.get("title.adduser"));
        this.msnm = msnm;
        this.msnm.addMsnListener((MsnListener)this.baseAdapter);
        this.createComponents();
    }

    private void createComponents() {
        this.setSize(420, 160);
        JPanel panel = (JPanel)this.getContentPane();
        JPanel mainPanel = new JPanel();
        JLabel label = new JLabel(Msg.get("add.email"));
        label.setFont(ToolBox.FONT);
        this.emailField = new JTextField(20);
        this.emailField.setFont(ToolBox.FONT);
        this.emailField.addActionListener(this);
        mainPanel.add((Component)label, "West");
        mainPanel.add((Component)this.emailField, "Center");
        FlowLayout fl = new FlowLayout();
        JPanel centerPanel = new JPanel(fl);
        centerPanel.add(mainPanel);
        this.commentLabel = new JLabel(Msg.get("add.email.detail"));
        this.commentLabel.setBorder(BorderFactory.createEtchedBorder());
        this.commentLabel.setPreferredSize(new Dimension(this.getSize().width - 20, 24));
        this.commentLabel.setFont(ToolBox.FONT);
        this.progress = new JProgressBar(1, 15);
        this.progress.setPreferredSize(new Dimension(this.getSize().width - 20, 16));
        this.timer = new Timer(50, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddFriendDialog.this.progress.setValue(AddFriendDialog.this.progress.getValue() + 1);
            }
        });
        fl.setAlignment(3);
        centerPanel.add(this.progress);
        centerPanel.add(this.commentLabel);
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 15, 5));
        this.addButton = new JButton(Msg.get("button.add"));
        this.addButton.setFont(ToolBox.FONT);
        this.addButton.setMnemonic('A');
        this.addButton.addActionListener(this);
        this.cancelButton = new JButton(Msg.get("button.cancel"));
        this.cancelButton.setFont(ToolBox.FONT);
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.cancelButton);
        panel.add((Component)centerPanel, "Center");
        panel.add((Component)buttonPanel, "South");
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.cancelButton) {
            this.dispose();
        } else if (src == this.emailField || src == this.addButton) {
            String email = this.emailField.getText().trim();
            if (email.length() == 0) {
                this.emailField.requestFocus();
                return;
            }
            this.processAdd(email);
        }
    }

    protected void disableAll() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AddFriendDialog.this.emailField.setEnabled(false);
                AddFriendDialog.this.addButton.setEnabled(false);
                AddFriendDialog.this.cancelButton.setEnabled(false);
                AddFriendDialog.this.progress.setValue(0);
                AddFriendDialog.this.timer.start();
            }
        });
    }

    protected void enableAll(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AddFriendDialog.this.commentLabel.setText(msg);
                AddFriendDialog.this.emailField.setEnabled(true);
                AddFriendDialog.this.addButton.setEnabled(true);
                AddFriendDialog.this.cancelButton.setEnabled(true);
                AddFriendDialog.this.timer.stop();
                AddFriendDialog.this.progress.setValue(100);
            }
        });
    }

    protected void processAdd(String email) {
        try {
            this.disableAll();
            this.msnm.addFriend(email);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dispose() {
        this.msnm.removeMsnListener((MsnListener)this.baseAdapter);
        super.dispose();
    }

    private class Adapter
    extends MsnAdapter {
        private Adapter() {
        }

        public void addFailed(int err) {
            String msg = null;
            switch (err) {
                case 210: {
                    msg = Msg.get("add.fail.overflow");
                    break;
                }
                case 215: {
                    msg = Msg.get("add.fail.exist");
                    break;
                }
                case 205: 
                case 208: {
                    msg = Msg.get("add.fail.unknown-user");
                }
            }
            AddFriendDialog.this.enableAll(msg);
        }

        public void buddyListModified() {
            String email = AddFriendDialog.this.emailField.getText().trim();
            AddFriendDialog.this.enableAll(Msg.get("add.ok", email));
        }
    }
}

