/*
 * Decompiled with CFR 0.152.
 */
package rath.jmsn.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.rtf.RTFEditorKit;
import rath.jmsn.MainFrame;
import rath.jmsn.util.Emoticon;

public abstract class ChatArea
extends JTextPane
implements ActionListener,
MouseListener,
MouseMotionListener {
    private static Emoticon emoticon = new Emoticon();
    private SimpleAttributeSet style;
    private Vector startIndex = new Vector();
    private Vector endIndex = new Vector();
    private Vector linkURL = new Vector();
    private JTextArea tempArea = new JTextArea();
    private boolean isViewEmoticon = MainFrame.LOCALCOPY.getPropertyBoolean("emoticon.display", true);
    private boolean useFixedFont = MainFrame.LOCALCOPY.getPropertyBoolean("font.fixed.on.chat", false);

    public ChatArea() {
        this.style = new SimpleAttributeSet();
        StyleConstants.setForeground(this.style, Color.black);
        StyleConstants.setFontSize(this.style, 12);
        StyleConstants.setBold(this.style, false);
        StyleConstants.setItalic(this.style, false);
        this.registerKeyboardAction(this, KeyStroke.getKeyStroke(67, 2), 0);
        this.setContentType("text/rtf");
        this.setEditorKit(new RTFEditorKit());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setEditable(false);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        new DropTarget(this, new DropListener());
    }

    public abstract void acceptFiles(List var1);

    public abstract void inviteFriend(String var1);

    public void append(String msg) {
        this.append(msg, new Color(0, 0, 0), "", "\uad74\ub9bc\uccb4");
    }

    public void append(String msg, Color co, String ef, String fn) {
        Color a3 = StyleConstants.getForeground(this.style);
        StyleConstants.setForeground(this.style, co);
        String a2 = StyleConstants.getFontFamily(this.style);
        StyleConstants.setFontFamily(this.style, this.useFixedFont ? "Dialog" : fn);
        boolean fi = false;
        boolean fu = false;
        boolean fb = false;
        boolean fs = false;
        if (ef.indexOf(66) != -1) {
            fb = StyleConstants.isBold(this.style);
            StyleConstants.setBold(this.style, true);
        }
        if (ef.indexOf(73) != -1) {
            fi = StyleConstants.isItalic(this.style);
            StyleConstants.setItalic(this.style, true);
        }
        if (ef.indexOf(83) != -1) {
            fs = StyleConstants.isStrikeThrough(this.style);
            StyleConstants.setStrikeThrough(this.style, true);
        }
        if (ef.indexOf(85) != -1) {
            fu = StyleConstants.isUnderline(this.style);
            StyleConstants.setUnderline(this.style, true);
        }
        try {
            String s = this.getDocument().getText(0, this.getDocument().getLength());
            int d1 = s.length();
            this.getDocument().insertString(this.getDocument().getLength(), msg, this.style);
            this.setEditable(true);
            if (this.isViewEmoticon) {
                this.replaceEmoticon(msg, d1);
            }
            this.replaceURL(msg, d1);
            this.setEditable(false);
            this.getDocument().insertString(this.getDocument().getLength(), "", this.style);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        StyleConstants.setFontFamily(this.style, a2);
        StyleConstants.setForeground(this.style, a3);
        StyleConstants.setBold(this.style, fb);
        StyleConstants.setItalic(this.style, fi);
        StyleConstants.setStrikeThrough(this.style, fs);
        StyleConstants.setUnderline(this.style, fu);
    }

    protected void replaceEmoticon(String msg, int d1) {
        try {
            boolean hasMoreEmoticons = true;
            int lid = -1;
            while (hasMoreEmoticons) {
                Enumeration e = emoticon.getEmoticons();
                boolean a = false;
                while (e.hasMoreElements()) {
                    String key = e.nextElement().toString();
                    int index = -1;
                    index = msg.indexOf(key.toUpperCase(), lid);
                    if (index == -1 && (index = msg.indexOf(key.toLowerCase(), lid)) == -1) continue;
                    lid = index;
                    this.getDocument().remove(d1 + index, key.length());
                    this.setCaretPosition(d1 + index);
                    this.insertIcon(emoticon.get(key));
                    msg = this.getDocument().getText(d1, this.getDocument().getLength() - d1);
                    a = true;
                    break;
                }
                hasMoreEmoticons = a;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    protected void replaceURL(String msg, int d1) {
        try {
            Document doc = this.getDocument();
            int lid = -1;
            boolean a1 = StyleConstants.isUnderline(this.style);
            boolean a2 = StyleConstants.isItalic(this.style);
            Color a3 = StyleConstants.getForeground(this.style);
            StyleConstants.setUnderline(this.style, true);
            StyleConstants.setForeground(this.style, Color.blue);
            while (true) {
                int index = -1;
                msg = doc.getText(d1, doc.getLength() - d1);
                index = msg.indexOf("http://", lid + 1);
                if (index == -1) break;
                lid = index;
                int endPoint = msg.indexOf(" ", lid + 1);
                int te1 = msg.indexOf("http://", lid + 1);
                int te2 = msg.indexOf("\n", lid + 1);
                if (te1 != -1 && (endPoint = Math.min(te1, endPoint)) == -1) {
                    endPoint = te1;
                }
                if (te2 != -1 && (endPoint = Math.min(te2, endPoint)) == -1) {
                    endPoint = te2;
                }
                if (endPoint == -1) {
                    endPoint = msg.length() - 1;
                }
                String anchor = doc.getText(d1 + lid, endPoint - lid);
                doc.remove(d1 + lid, endPoint - lid);
                doc.insertString(d1 + lid, anchor, this.style);
                doc.insertString(d1 + lid + anchor.length(), " ", new SimpleAttributeSet());
                this.startIndex.add(new Integer(d1 + lid));
                this.endIndex.add(new Integer(d1 + endPoint));
                this.linkURL.add(anchor);
            }
            StyleConstants.setUnderline(this.style, a1);
            StyleConstants.setForeground(this.style, a3);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.tempArea.setText(this.getSelectedText());
        this.tempArea.selectAll();
        this.tempArea.copy();
    }

    public void mouseClicked(MouseEvent e) {
        int idx = this.viewToModel(e.getPoint());
        int i = 0;
        while (i < this.startIndex.size()) {
            int ep;
            int sp = (Integer)this.startIndex.elementAt(i);
            if (idx >= sp & idx <= (ep = ((Integer)this.endIndex.elementAt(i)).intValue())) {
                String url = (String)this.linkURL.elementAt(i);
                this.showURL(url);
                break;
            }
            ++i;
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    private void showURL(String urls) {
        try {
            String[] cmd = new String[]{System.getProperty("os.name").startsWith("Windows") ? "explorer" : "netscape", "\"" + urls + "\""};
            Runtime.getRuntime().exec(cmd);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void mouseMoved(MouseEvent e) {
        int idx = this.viewToModel(e.getPoint());
        int a = 0;
        int i = 0;
        while (i < this.startIndex.size()) {
            int ep;
            int sp = (Integer)this.startIndex.elementAt(i);
            if (idx >= sp & idx <= (ep = ((Integer)this.endIndex.elementAt(i)).intValue())) {
                this.setCursor(new Cursor(12));
                ++a;
                break;
            }
            ++i;
        }
        if (a == 0) {
            this.setCursor(new Cursor(0));
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void dispose() {
        this.setText("");
        this.startIndex.removeAllElements();
        this.endIndex.removeAllElements();
        this.linkURL.removeAllElements();
        this.tempArea.setText("");
        this.startIndex = null;
        this.endIndex = null;
        this.linkURL = null;
        this.tempArea = null;
    }

    private class DropListener
    implements DropTargetListener {
        private DropListener() {
        }

        public void dragEnter(DropTargetDragEvent e) {
        }

        public void dragExit(DropTargetEvent e) {
        }

        public void dragOver(DropTargetDragEvent e) {
        }

        public void dropActionChanged(DropTargetDragEvent e) {
        }

        public void drop(DropTargetDropEvent event) {
            block5: {
                try {
                    Transferable t = event.getTransferable();
                    if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        event.acceptDrop(2);
                        List filelist = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                        event.getDropTargetContext().dropComplete(true);
                        ChatArea.this.acceptFiles(filelist);
                        break block5;
                    }
                    if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        event.acceptDrop(2);
                        String loginName = (String)t.getTransferData(DataFlavor.stringFlavor);
                        event.getDropTargetContext().dropComplete(true);
                        ChatArea.this.inviteFriend(loginName);
                        break block5;
                    }
                    event.rejectDrop();
                }
                catch (IOException e) {
                    event.rejectDrop();
                }
                catch (UnsupportedFlavorException e) {
                    event.rejectDrop();
                }
            }
        }
    }
}

