/*
 * Decompiled with CFR 0.152.
 */
package rath.jmsn.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileView;
import rath.jmsn.MainFrame;
import rath.jmsn.NativeToolkit;
import rath.jmsn.ToolBox;
import rath.jmsn.entity.FileItem;
import rath.jmsn.file.ChatLogWriter;
import rath.jmsn.file.FileProgress;
import rath.jmsn.ui.ChatArea;
import rath.jmsn.ui.DialogAppender;
import rath.jmsn.ui.FontDialog;
import rath.jmsn.ui.ZippedDirectoryDialog;
import rath.jmsn.util.Msg;
import rath.jmsn.util.MusicBox;
import rath.msnm.LocalCopy;
import rath.msnm.MSNMessenger;
import rath.msnm.SwitchboardSession;
import rath.msnm.entity.MsnFriend;
import rath.msnm.event.MsnAdapter;
import rath.msnm.event.MsnListener;
import rath.msnm.ftp.VolatileDownloader;
import rath.msnm.ftp.VolatileTransfer;
import rath.msnm.ftp.VolatileTransferServer;
import rath.msnm.msg.MimeMessage;
import rath.msnm.msg.MimeUtility;
import rath.util.HangulJamoUtil;

public class ChatDialog
extends JFrame
implements ToolBox,
DialogAppender {
    private static final SimpleDateFormat ts = new SimpleDateFormat("[HH:mm]");
    private static final SimpleDateFormat sdf = new SimpleDateFormat("mm:ss");
    private MSNMessenger msnm = null;
    private MsnFriend me = null;
    private JScrollPane chatPane = null;
    private JScrollPane inputPane = null;
    private JButton filesendButton = null;
    private ChatArea chatArea = null;
    private JTextArea inputArea = null;
    private JLabel statusLabel = null;
    private SwitchboardSession session = null;
    private boolean isSessionClose = false;
    private WindowListener wl = null;
    private JPanel topPanel = null;
    private MsnFriend you = null;
    private ArrayList queue = new ArrayList();
    private ChatLogWriter log = null;
    private Vector fileQueue = new Vector();
    private Hashtable fileCookieMap = new Hashtable();
    private MsnAdapter fileAdapter = new FileAdapter();
    private long lastMessagingTime = 0L;
    private boolean isViewTimestamp = MainFrame.LOCALCOPY.getPropertyBoolean("timestamp.display", false);

    public ChatDialog(Frame owner, MSNMessenger msnm, String targetName, MsnFriend i) {
        this.setTitle(targetName);
        this.me = i;
        this.msnm = msnm;
        this.init();
    }

    public ChatDialog(Frame owner, MSNMessenger msnm, SwitchboardSession session, MsnFriend i) {
        this.setTitle(session.getMsnFriend().getLoginName());
        this.me = i;
        this.you = session.getMsnFriend();
        this.msnm = msnm;
        this.session = session;
        MusicBox.play("Message.2");
        this.prepareLogWriter(this.you.getLoginName());
        this.init();
    }

    private void init() {
        this.createComponents();
        this.createKeyMap();
        this.addComponentListener(new DialogStatus());
        super.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                ChatDialog.this.chatArea.requestFocus();
                ChatDialog.this.inputArea.requestFocus();
            }
        });
        this.msnm.addMsnListener((MsnListener)this.fileAdapter);
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (int)(Math.random() * (double)(size.height - this.getSize().width));
        int y = (int)(Math.random() * (double)(size.height - this.getSize().height));
        this.setLocation(x, y);
        this.setDefaultCloseOperation(2);
    }

    private void prepareLogWriter(String targetName) {
        if (this.log != null) {
            return;
        }
        String logdir = this.msnm.getLocalCopy().getProperty("chatlog.dir");
        File file = new File(logdir, targetName + ".txt");
        try {
            this.log = new ChatLogWriter(file);
        }
        catch (IOException e) {
            System.err.println("can't write log file.");
        }
    }

    public void addFileItem(FileItem item) {
        this.fileQueue.add(item);
        MimeMessage msg = new MimeMessage();
        msg.setMessage(Msg.get("chatdlg.filerecv.notify", this.you.getFormattedFriendlyName(), item.getName() + "(" + item.getKBSize() + ")"));
        this.appendMessage(msg);
        if (Boolean.getBoolean("jmsn.file.auto.accept")) {
            this.acceptFileRequest();
        }
    }

    private void createKeyMap() {
        JPanel panel = (JPanel)this.getContentPane();
        ComponentInputMap im = new ComponentInputMap(panel);
        im.put(KeyStroke.getKeyStroke(84, 8), "FileAccept");
        im.put(KeyStroke.getKeyStroke(84, 2), "FileAccept");
        im.put(KeyStroke.getKeyStroke(68, 8), "FileReject");
        im.put(KeyStroke.getKeyStroke(68, 2), "FileReject");
        ActionMap am = panel.getActionMap();
        am.put("FileAccept", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ChatDialog.this.acceptFileRequest();
            }
        });
        am.put("FileReject", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (ChatDialog.this.fileQueue.size() == 0) {
                    return;
                }
                FileItem item = (FileItem)ChatDialog.this.fileQueue.remove(0);
                SwitchboardSession ss = item.getSession();
                try {
                    ss.rejectFileReceive(item.getCookie());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                MimeMessage msg = new MimeMessage();
                msg.setMessage(Msg.get("chatdlg.filerecv.reject"));
                ChatDialog.this.appendMessage(msg);
            }
        });
        panel.setInputMap(2, im);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ChatDialog.this.dispose();
                }
            }
        });
    }

    private void acceptFileRequest() {
        if (this.fileQueue.size() == 0) {
            return;
        }
        FileItem item = (FileItem)this.fileQueue.remove(0);
        SwitchboardSession ss = item.getSession();
        LocalCopy local = this.msnm.getLocalCopy();
        FileProgress prog = new FileProgress(this);
        try {
            File file = new File(local.getProperty("download.dir"), item.getName());
            this.fileCookieMap.put(String.valueOf(item.getCookie()), prog);
            ss.acceptFileReceive(item.getCookie(), file);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.topPanel.add(prog);
        this.topPanel.doLayout();
        this.topPanel.validate();
    }

    public void sessionClosed() {
        this.session = null;
        this.isSessionClose = true;
    }

    public void userOffline() {
        if (this.you == null) {
            return;
        }
        MimeMessage msg = new MimeMessage();
        msg.setMessage(Msg.get("chatdlg.msg.offline", this.you.getLoginName()));
        this.appendMessage(msg);
        this.filesendButton.setEnabled(false);
        this.inputArea.setEnabled(false);
    }

    private void createComponents() {
        this.setSize(350, 350);
        JPanel panel = (JPanel)this.getContentPane();
        this.chatArea = new ChatArea(){

            public void acceptFiles(List list) {
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    ChatDialog.this.sendFileImpl((File)i.next());
                }
            }

            public void inviteFriend(String loginName) {
                block2: {
                    if (ChatDialog.this.session == null) break block2;
                    try {
                        ChatDialog.this.session.inviteFriend(loginName);
                        MimeMessage msg = new MimeMessage();
                        msg.setMessage(Msg.get("chatdlg.msg.invite", loginName));
                        ChatDialog.this.appendMessage(msg);
                    }
                    catch (IOException e) {}
                }
            }
        };
        this.chatArea.setFont(ToolBox.FONT_10);
        this.chatArea.append(Msg.get("chatdlg.msg.top"));
        JPanel propertyPane = new JPanel();
        propertyPane.setLayout(new BorderLayout());
        JPanel propertyArea = new JPanel();
        propertyArea.setPreferredSize(new Dimension(Short.MAX_VALUE, 32));
        propertyArea.setLayout(new FlowLayout(0, 5, 2));
        JButton fontButton = new JButton(Msg.get("label.font"));
        fontButton.setFont(ToolBox.FONT);
        fontButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChatDialog.this.showFontDialog();
            }
        });
        fontButton.setToolTipText(Msg.get("label.font"));
        propertyArea.add(fontButton);
        JButton emoticonButton = new JButton(Msg.get("label.emoticon"));
        emoticonButton.setFont(ToolBox.FONT);
        emoticonButton.setToolTipText(Msg.get("label.emoticon"));
        propertyPane.add((Component)propertyArea, "West");
        this.inputArea = new JTextArea();
        this.inputArea.setFont(ToolBox.FONT_10);
        this.inputArea.setLineWrap(true);
        this.statusLabel = new JLabel("");
        this.statusLabel.setFont(ToolBox.FONT_10);
        this.statusLabel.setPreferredSize(new Dimension(100, 24));
        this.chatPane = new JScrollPane(this.chatArea);
        this.inputPane = new JScrollPane(this.inputArea);
        this.inputPane.setPreferredSize(new Dimension(100, 50));
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)propertyPane, "North");
        bottomPanel.add((Component)this.inputPane, "Center");
        bottomPanel.add((Component)this.statusLabel, "South");
        this.topPanel = new JPanel(new FlowLayout(0, 4, 4));
        this.topPanel.setPreferredSize(new Dimension(100, 38));
        this.topPanel.setBorder(BorderFactory.createEtchedBorder());
        this.filesendButton = new JButton(Msg.get("button.file.send"));
        this.filesendButton.setFont(ToolBox.FONT);
        this.filesendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChatDialog.this.prepareSendFile();
            }
        });
        this.topPanel.add(this.filesendButton);
        panel.add((Component)this.topPanel, "North");
        panel.add((Component)this.chatPane, "Center");
        panel.add((Component)bottomPanel, "South");
        InputMap im = this.inputArea.getInputMap();
        ActionMap am = this.inputArea.getActionMap();
        AbstractAction newlineAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ChatDialog.this.inputArea.append("\n");
            }
        };
        im.put(KeyStroke.getKeyStroke(10, 2), "newline");
        im.put(KeyStroke.getKeyStroke(10, 1), "newline");
        im.put(KeyStroke.getKeyStroke(10, 0), "send");
        im.put(KeyStroke.getKeyStroke(27, 0), "dispose");
        im.put(KeyStroke.getKeyStroke(65, 8), "TopMost");
        am.put("newline", newlineAction);
        am.put("send", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ChatDialog.this.sendMessage();
            }
        });
        am.put("dispose", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ChatDialog.this.dispose();
            }
        });
        am.put("TopMost", new AbstractAction(){
            boolean isTopMost = false;

            public void actionPerformed(ActionEvent e) {
                NativeToolkit tk = NativeToolkit.getInstance();
                tk.makeTopMost(ChatDialog.this, !this.isTopMost);
                this.isTopMost = !this.isTopMost;
            }
        });
    }

    public void appendMessage(MimeMessage msg) {
        Appender appender = new Appender();
        appender.setAlert(true);
        appender.setMessage(msg);
        if (this.log != null) {
            this.log.println(msg.getMessage());
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(appender);
        } else {
            appender.run();
        }
    }

    public void appendMessage(MsnFriend friend, MimeMessage msg) {
        Appender appender = new Appender();
        appender.setAlert(false);
        appender.setFriend(friend);
        appender.setMessage(msg);
        if (friend != this.me) {
            this.lastMessagingTime = System.currentTimeMillis();
        }
        if (this.log != null) {
            this.log.println(friend, msg.getMessage());
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(appender);
        } else {
            appender.run();
        }
    }

    protected void showFontDialog() {
        FontDialog fd = new FontDialog(this);
        fd.setVisible(true);
    }

    protected void prepareSendFile() {
        if (this.isSessionClose) {
            this.isSessionClose = false;
            try {
                if (this.msnm.findSwitchboardSession(this.you.getLoginName()) == null) {
                    this.msnm.doCall(this.you.getLoginName());
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        String downdir = this.msnm.getLocalCopy().getProperty("download.dir");
        JFileChooser file = new JFileChooser(downdir);
        if (System.getProperty("os.name").equals("Mac OS X")) {
            FileView fv = new FileView(){

                public String getName(File f) {
                    return HangulJamoUtil.getString(f.getName());
                }
            };
            file.setFileView(fv);
        }
        file.setMultiSelectionEnabled(true);
        file.setFileSelectionMode(2);
        if (file.showOpenDialog(this) == 0) {
            File[] fs = file.getSelectedFiles();
            int i = 0;
            while (i < fs.length) {
                this.sendFileImpl(fs[i]);
                ++i;
            }
        }
    }

    protected void sendFileImpl(File f) {
        if (f.isDirectory()) {
            if (JOptionPane.showConfirmDialog(this, Msg.get("chatdlg.query.dirsend.content", f.getName()), Msg.get("chatdlg.query.dirsend.title"), 0, 3) == 1) {
                return;
            }
            ZippedDirectoryDialog zd = new ZippedDirectoryDialog((Frame)this, f);
            zd.show();
            f = zd.getZippedFile();
            f.deleteOnExit();
        }
        if (System.getProperty("os.name").equals("Mac OS X")) {
            final String orgName = f.getName();
            f = new File(f.getAbsolutePath()){

                public String getName() {
                    return HangulJamoUtil.getString(orgName);
                }
            };
        }
        MimeMessage msg = new MimeMessage();
        if (this.session != null) {
            try {
                this.msnm.sendFileRequest(this.you.getLoginName(), f, this.session);
                msg.setMessage(Msg.get("chatdlg.filesend.request.ok", this.you.getLoginName(), f.getName()));
            }
            catch (IOException e) {
                msg.setMessage(Msg.get("chatdlg.filesend.request.fail"));
            }
            this.appendMessage(msg);
        } else {
            msg.setMessage(Msg.get("chatdlg.filesend.request.fail"));
            this.appendMessage(msg);
        }
    }

    protected void sendMessage() {
        String input = this.inputArea.getText();
        if (input.trim().length() == 0) {
            return;
        }
        this.inputArea.setText("");
        if (this.me.getStatus().equals("HDN")) {
            this.inputArea.setText(Msg.get("chatdlg.msg.notsend.offline"));
            this.filesendButton.setEnabled(false);
            this.inputArea.setEnabled(false);
            return;
        }
        MimeMessage msg = new MimeMessage(input);
        msg.setKind(2);
        LocalCopy local = MainFrame.LOCALCOPY;
        String fn = local.getProperty("font.name");
        if (fn == null) {
            fn = "\uad74\ub9bc\uccb4";
        }
        int red = 0;
        int green = 0;
        int blue = 0;
        try {
            red = Integer.parseInt(local.getProperty("font.red"));
            green = Integer.parseInt(local.getProperty("font.green"));
            blue = Integer.parseInt(local.getProperty("font.blue"));
        }
        catch (NumberFormatException e) {
            blue = 0;
            green = 0;
            red = 0;
        }
        StringBuffer ef = new StringBuffer();
        boolean b = local.getPropertyBoolean("font.isBold", false);
        boolean i = local.getPropertyBoolean("font.isItalic", false);
        boolean s = local.getPropertyBoolean("font.isStrikeThrough", false);
        boolean u = local.getPropertyBoolean("font.isUnderline", false);
        boolean ir = local.getPropertyBoolean("font.israndomcolor", true);
        if (b) {
            ef.append("B");
        }
        if (i) {
            ef.append("I");
        }
        if (s) {
            ef.append("S");
        }
        if (u) {
            ef.append("U");
        }
        msg.setFontName(fn);
        if (!ir) {
            msg.setFontColor(new Color(red, green, blue));
        }
        msg.setEffectCode(ef.toString());
        try {
            msg.parse(new String(msg.getBytes(), "UTF-8"));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.appendMessage(this.me, msg);
        try {
            if (this.session != null) {
                this.session.sendInstantMessage(msg);
            } else {
                this.queue.add(msg);
                if (this.isSessionClose) {
                    this.isSessionClose = false;
                    this.msnm.doCall(this.you.getLoginName());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addWindowListener(WindowListener wl) {
        super.addWindowListener(wl);
        this.wl = wl;
    }

    public void dispose() {
        this.chatArea.dispose();
        this.chatArea = null;
        if (this.topPanel.getComponentCount() > 1) {
            JOptionPane.showMessageDialog(this, Msg.get("chatdlg.msg.transfer.4eva"), Msg.get("title.alarm"), 1);
        }
        if (this.log != null) {
            this.log.close();
        }
        this.wl.windowClosing(new WindowEvent(this, 201));
        this.msnm.removeMsnListener((MsnListener)this.fileAdapter);
        super.dispose();
        System.gc();
    }

    public void close() {
        try {
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSession(SwitchboardSession session) {
        if (this.session != null && !this.session.getSessionId().equals(session.getSessionId())) {
            try {
                this.session.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.session = session;
        this.you = session.getMsnFriend();
        this.lastMessagingTime = System.currentTimeMillis();
        this.prepareLogWriter(this.you.getLoginName());
        MimeMessage mm = new MimeMessage();
        mm.setMessage(Msg.get("chatdlg.chat.opened"));
        this.appendMessage(mm);
        ArrayList arrayList = this.queue;
        synchronized (arrayList) {
            if (this.queue.size() != 0) {
                Iterator i = this.queue.iterator();
                while (i.hasNext()) {
                    Object var8_8;
                    MimeMessage msg = (MimeMessage)i.next();
                    try {
                        try {
                            session.sendInstantMessage(msg);
                        }
                        catch (IOException e) {
                            msg.setMessage(Msg.get("chatdlg.chat.error", msg.getMessage()));
                            this.appendMessage(msg);
                            var8_8 = null;
                            i.remove();
                            continue;
                        }
                        var8_8 = null;
                        i.remove();
                    }
                    catch (Throwable throwable) {
                        var8_8 = null;
                        i.remove();
                        throw throwable;
                    }
                }
            }
        }
    }

    public SwitchboardSession getSession() {
        return this.session;
    }

    public long getLastMessagingTime() {
        return this.lastMessagingTime;
    }

    public void whoTyping(final String userview) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ChatDialog.this.statusLabel.setText(Msg.get("chatdlg.msg.typing", userview, sdf.format(new Date())));
            }
        });
    }

    public void show() {
        NativeToolkit.getInstance().makeTransparency(this, Integer.getInteger("jmsn.transparency", -1));
        super.show();
        NativeToolkit.getInstance().makeTransparency(this, Integer.getInteger("jmsn.transparency", -1));
    }

    static /* synthetic */ JPanel access$700(ChatDialog x0) {
        return x0.topPanel;
    }

    private class Appender
    implements Runnable {
        boolean alert = false;
        MsnFriend friend;
        MimeMessage msg;
        JViewport view;
        Rectangle rect = new Rectangle();

        public Appender() {
            this.view = ChatDialog.this.chatPane.getViewport();
            this.rect.x = 0;
            this.rect.width = 1;
            this.rect.height = 300;
        }

        public void setAlert(boolean isAlert) {
            this.alert = isAlert;
        }

        public void setFriend(MsnFriend friend) {
            this.friend = friend;
        }

        public void setMessage(MimeMessage msg) {
            this.msg = msg;
        }

        public void run() {
            Color co;
            String ef = "";
            String fn = "\uad74\ub9bc\uccb4";
            try {
                Properties p = this.msg.getProperties();
                String fm = p.getProperty("X-MMS-IM-Format");
                if (fm != null) {
                    int ei;
                    int si = fm.indexOf("CO");
                    String c = fm.substring(si + 3, ei = fm.indexOf(";", si));
                    if (c.length() < 6) {
                        StringBuffer sb = new StringBuffer(6);
                        int i = 0;
                        int len = 6 - c.length();
                        while (i < len) {
                            sb.append('0');
                            ++i;
                        }
                        c = sb.toString() + c;
                    }
                    int r = Integer.parseInt(c.substring(4, 6), 16);
                    int g = Integer.parseInt(c.substring(2, 4), 16);
                    int b = Integer.parseInt(c.substring(0, 2), 16);
                    co = new Color(r, g, b);
                    si = fm.indexOf("EF");
                    ei = fm.indexOf(";", si);
                    ef = fm.substring(si + 3, ei);
                    si = fm.indexOf("FN");
                    ei = fm.indexOf(";", si);
                    fn = MimeUtility.getURLDecodedString((String)fm.substring(si + 3, ei), (String)"UTF-8");
                } else {
                    co = this.msg.getFontColor();
                    ef = this.msg.getEffectCode();
                    fn = this.msg.getFontName();
                }
            }
            catch (Exception eex) {
                co = this.msg.getFontColor();
                ef = this.msg.getEffectCode();
                fn = this.msg.getFontName();
            }
            StringBuffer sb = new StringBuffer(50);
            if (ChatDialog.this.isViewTimestamp) {
                sb.append(ts.format(new Date()));
                sb.append(' ');
            }
            if (this.alert) {
                sb.append(this.msg.getMessage());
                sb.append('\n');
                ChatDialog.this.chatArea.append(sb.toString());
                if (ChatDialog.this.getFocusOwner() == null) {
                    MusicBox.play("Message.1");
                }
            } else {
                sb.append(Msg.get("chatdlg.chat", this.friend.getFormattedFriendlyName()));
                ChatDialog.this.chatArea.append(sb.toString());
                ChatDialog.this.chatArea.append(this.msg.getMessage() + "\n", co, ef, fn);
                if (ChatDialog.this.getFocusOwner() == null && this.friend != ChatDialog.this.me) {
                    MusicBox.play("Message.2");
                }
            }
            this.rect.y = ((ChatDialog)ChatDialog.this).chatArea.getSize().height;
            this.view.scrollRectToVisible(this.rect);
            ChatDialog.this.statusLabel.setText("");
        }
    }

    private class DialogStatus
    extends ComponentAdapter {
        private DialogStatus() {
        }

        public void componentResized(ComponentEvent e) {
            ChatDialog.this.chatPane.getViewport().scrollRectToVisible(new Rectangle(0, ((ChatDialog)ChatDialog.this).chatArea.getSize().height, 100, 100));
        }
    }

    private class FileAdapter
    extends MsnAdapter {
        private FileAdapter() {
        }

        public void fileReceiveStarted(VolatileDownloader down) {
            String cookie = down.getCookie();
            FileProgress prog = null;
            prog = (FileProgress)ChatDialog.this.fileCookieMap.remove(cookie);
            if (prog != null) {
                prog.setTransfer((VolatileTransfer)down);
            }
        }

        public void fileSendStarted(VolatileTransferServer vts) {
            String cookie = vts.getCookie();
            FileProgress prog = null;
            prog = (FileProgress)ChatDialog.this.fileCookieMap.remove(cookie);
            if (prog != null) {
                prog.setTransfer((VolatileTransfer)vts);
            }
        }

        public void fileSendError(VolatileTransferServer server, Throwable e) {
            e.printStackTrace();
        }

        public void fileSendAccepted(SwitchboardSession ss, int cookie) {
            if (ChatDialog.this.session == null) {
                return;
            }
            if (ss.getSessionId().equals(ChatDialog.this.session.getSessionId())) {
                FileProgress prog = new FileProgress(ChatDialog.this);
                ChatDialog.this.fileCookieMap.put(String.valueOf(cookie), prog);
                SwingUtilities.invokeLater(new Runnable(this, prog){
                    private final /* synthetic */ FileProgress val$prog;
                    private final /* synthetic */ FileAdapter this$1;
                    {
                        this.this$1 = this$1;
                        this.val$prog = val$prog;
                    }

                    public void run() {
                        ChatDialog.access$700(FileAdapter.access$600(this.this$1)).add(this.val$prog);
                        ChatDialog.access$700(FileAdapter.access$600(this.this$1)).doLayout();
                        ChatDialog.access$700(FileAdapter.access$600(this.this$1)).validate();
                    }
                });
                MimeMessage msg = new MimeMessage();
                msg.setMessage(Msg.get("chatdlg.filesend.accept", ChatDialog.this.you.getLoginName()));
                ChatDialog.this.appendMessage(msg);
            }
        }

        public void fileSendRejected(SwitchboardSession ss, int cookie, String reason) {
            if (ChatDialog.this.session == null) {
                return;
            }
            if (ss.getSessionId().equals(ChatDialog.this.session.getSessionId())) {
                MimeMessage msg = new MimeMessage();
                msg.setMessage(Msg.get("chatdlg.filesend.reject", ChatDialog.this.you.getLoginName()));
                ChatDialog.this.appendMessage(msg);
            }
        }

        static /* synthetic */ ChatDialog access$600(FileAdapter x0) {
            return x0.ChatDialog.this;
        }
    }
}

