/*
 * Decompiled with CFR 0.152.
 */
package rath.jmsn.ui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import rath.jmsn.MainFrame;
import rath.jmsn.ToolBox;
import rath.jmsn.ui.DefaultDialog;
import rath.jmsn.util.GlobalProp;
import rath.jmsn.util.Msg;
import rath.jmsn.util.UserStatusBox;
import rath.msnm.LocalCopy;
import rath.msnm.util.StringList;

public class LoginDialog
extends DefaultDialog
implements ToolBox {
    private boolean isConfirm = false;
    private Frame owner = null;
    private JComboBox loginBox = null;
    private JPasswordField passField = null;
    private JComboBox statusBox = null;
    private JCheckBox rememberPassBox = null;

    public LoginDialog(Frame owner) {
        super(owner);
        this.setTitle(Msg.get("title.login"));
        this.owner = owner;
        this.createComponents();
        GlobalProp prop = MainFrame.getGlobalProp();
        String loginName = prop.get("last.login");
        String password = "";
        if (loginName != null) {
            int i0 = loginName.indexOf(":");
            if (i0 != -1) {
                password = loginName.substring(i0 + 1);
                loginName = loginName.substring(0, i0);
                this.passField.setText(password);
            }
            this.loginBox.setSelectedItem(loginName);
        }
    }

    private void createComponents() {
        this.setSize(350, 215);
        JPanel panel = (JPanel)this.getContentPane();
        JPanel mainPanel = new JPanel();
        BoxLayout box = new BoxLayout(mainPanel, 1);
        mainPanel.setLayout(box);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel loginLabel = new JLabel(Msg.get("label.loginname"));
        JLabel passLabel = new JLabel(Msg.get("label.password"));
        loginLabel.setFont(ToolBox.FONT);
        passLabel.setFont(ToolBox.FONT);
        ActionListener actionLogin = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.doConfirm();
            }
        };
        String[] users = this.getLoggedUsers();
        this.loginBox = new JComboBox<String>(users);
        this.loginBox.setFont(ToolBox.FONT);
        this.loginBox.setEditable(true);
        this.passField = new JPasswordField(18);
        this.passField.setFont(ToolBox.FONT);
        this.passField.setEchoChar('*');
        this.passField.addActionListener(actionLogin);
        this.rememberPassBox = new JCheckBox(Msg.get("label.remember.password"));
        this.rememberPassBox.setFont(ToolBox.FONT);
        JPanel loginPanel = new JPanel();
        loginPanel.add(loginLabel);
        loginPanel.add(this.loginBox);
        JPanel passPanel = new JPanel();
        passPanel.add(passLabel);
        passPanel.add(this.passField);
        passPanel.add(this.rememberPassBox);
        JPanel statusPanel = this.createStatusPanel();
        mainPanel.add(loginPanel);
        mainPanel.add(passPanel);
        mainPanel.add(this.rememberPassBox);
        mainPanel.add(statusPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton confirmButton = new JButton(Msg.get("button.ok"));
        confirmButton.setFont(ToolBox.FONT);
        confirmButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.doConfirm();
            }
        });
        JButton cancelButton = new JButton(Msg.get("button.cancel"));
        cancelButton.setFont(ToolBox.FONT);
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.doCancel();
            }
        });
        buttonPanel.add(confirmButton);
        buttonPanel.add(cancelButton);
        panel.add((Component)mainPanel, "Center");
        panel.add((Component)buttonPanel, "South");
    }

    private JPanel createStatusPanel() {
        JPanel panel = new JPanel();
        JLabel label = new JLabel(Msg.get("label.initstatus"));
        label.setFont(ToolBox.FONT);
        this.statusBox = new JComboBox();
        this.statusBox.setFont(ToolBox.FONT);
        Properties prop = UserStatusBox.getStatusSet();
        Enumeration<?> e = prop.propertyNames();
        while (e.hasMoreElements()) {
            String code = (String)e.nextElement();
            if (code.equals("FLN")) continue;
            this.statusBox.addItem(prop.getProperty(code));
        }
        this.statusBox.setSelectedItem(prop.getProperty("NLN"));
        panel.add((Component)label, "West");
        panel.add((Component)this.statusBox, "Center");
        return panel;
    }

    public String[] getLoggedUsers() {
        LocalCopy local = new LocalCopy();
        File homedir = local.getHomeDirectory();
        File[] file = homedir.listFiles();
        StringList users = new StringList();
        int i = 0;
        while (i < file.length) {
            if (file[i].isDirectory() && this.isValidEmail(file[i].getName())) {
                users.add(file[i].getName());
            }
            ++i;
        }
        return users.toArray();
    }

    public boolean isValidEmail(String email) {
        int at1 = email.indexOf(64);
        int at2 = email.indexOf(64, at1 + 1);
        if (at1 == -1 || at2 != -1) {
            return false;
        }
        String id = email.substring(0, at1);
        String dns = email.substring(at1 + 1, email.length());
        if (id.indexOf(46) != -1) {
            return false;
        }
        return dns.indexOf(46) != -1;
    }

    public boolean isConfirm() {
        return this.isConfirm;
    }

    protected boolean checkValidate() {
        if (this.loginBox.getSelectedItem().toString().trim().length() == 0) {
            return false;
        }
        return this.passField.getPassword().length != 0;
    }

    public String getLoginName() {
        return this.loginBox.getSelectedItem().toString();
    }

    public String getPassword() {
        return new String(this.passField.getPassword());
    }

    public boolean isRememberPassword() {
        return this.rememberPassBox.isSelected();
    }

    public String getInitialStatus() {
        String format = (String)this.statusBox.getSelectedItem();
        String code = UserStatusBox.getStatusAtFormattedValue(format);
        return code;
    }

    public void doConfirm() {
        if (this.checkValidate()) {
            this.isConfirm = true;
        }
        this.dispose();
    }

    public void doCancel() {
        this.dispose();
    }
}

