/*
 * Decompiled with CFR 0.152.
 */
package rath.tools;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import rath.NotSupportedPlatformException;

public class Win32Toolkit {
    private static boolean isLoaded = false;

    public static synchronized Win32Toolkit getInstance() throws NotSupportedPlatformException {
        if (!isLoaded) {
            String os = System.getProperty("os.name");
            if (!os.startsWith("Windows")) {
                throw new NotSupportedPlatformException(os);
            }
            System.loadLibrary("rath_awt");
            isLoaded = true;
        }
        return new Win32Toolkit();
    }

    private Win32Toolkit() {
    }

    public void makeTransparency(Window comp, int transparency) {
        this.makeTransparency(comp, Color.black, transparency);
    }

    public void makeTransparency(Window comp, Color blendColor, int transparency) {
        if (comp == null) {
            throw new IllegalArgumentException("comp is null");
        }
        if (blendColor == null) {
            blendColor = Color.black;
        }
        if (transparency < -1 || transparency > 255) {
            throw new IllegalArgumentException("transparency must be between -1 and 255");
        }
        this.makeTransparency0(comp, blendColor.getRed(), blendColor.getGreen(), blendColor.getBlue(), transparency);
    }

    private native void makeTransparency0(Window var1, int var2, int var3, int var4, int var5);

    public void makePolygonRegion(Window window, Polygon p) {
        if (window == null) {
            throw new IllegalArgumentException("window is null");
        }
        if (p == null) {
            throw new IllegalArgumentException("polygon is null");
        }
        this.makePolygonRegion0(window, p, true);
    }

    private native void makePolygonRegion0(Window var1, Polygon var2, boolean var3);

    public void makeTopMost(Window window, boolean enable) {
        this.makeTopMost0(window, enable);
    }

    private native void makeTopMost0(Window var1, boolean var2);

    public long createIconFromImage(Image icon) {
        if (icon == null) {
            return 0L;
        }
        int w = 16;
        int h = 16;
        BufferedImage bi = new BufferedImage(w, h, 2);
        Graphics g = bi.getGraphics();
        g.drawImage(icon, 0, 0, w, h, null);
        g.dispose();
        WritableRaster raster = bi.getRaster();
        DataBuffer dataBuffer = raster.getDataBuffer();
        ColorModel alphaCheck = bi.getColorModel();
        byte[] iconmask = new byte[w * h + 0];
        int bufIdx = 0;
        int maskIdx = 0;
        boolean isTransparent = false;
        int bufferSize = dataBuffer.getSize();
        bufIdx = 0;
        maskIdx = 0;
        while (bufIdx < bufferSize && maskIdx < iconmask.length) {
            byte tempAND = 0;
            int bitIdx = 0;
            while (bitIdx < 8 && bufIdx < bufferSize) {
                if (alphaCheck.getAlpha(dataBuffer.getElem(bufIdx++)) == 0) {
                    isTransparent = true;
                    tempAND = (byte)(tempAND | 1);
                } else {
                    tempAND = (byte)(tempAND & 0xFFFFFFFE);
                }
                if (bitIdx < 7) {
                    tempAND = (byte)(tempAND << 1);
                }
                ++bitIdx;
            }
            iconmask[maskIdx] = tempAND;
            ++maskIdx;
        }
        if (!isTransparent) {
            iconmask = null;
        }
        return this.createIconFromRaster0(((DataBufferInt)dataBuffer).getData(), iconmask, raster.getWidth(), raster.getWidth(), raster.getHeight());
    }

    private native long createIconFromRaster0(int[] var1, byte[] var2, int var3, int var4, int var5);

    public native void destroyIcon(long var1);
}

