/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.dataset;

import borland.jbcl.dataset.AggDescriptor;
import borland.jbcl.dataset.Aggregator;
import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.DataRow;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.InternalRow;
import borland.jbcl.dataset.ReadRow;
import borland.jbcl.dataset.ReadWriteRow;
import borland.jbcl.dataset.StorageDataSet;
import borland.jbcl.util.Variant;

public class AggManager {
    private boolean loading;
    private InternalRow internalReadRow;
    private Aggregator[] aggregatorMap;
    private Aggregator[] aggregators;
    private StorageDataSet dataSet;
    private DataRow customRow;

    static AggManager init(StorageDataSet storageDataSet) throws DataSetException {
        Column[] columnArray = storageDataSet.columnList.columns;
        Aggregator[] aggregatorArray = null;
        int n = 0;
        for (int i = 0; i < columnArray.length; ++i) {
            if (!AggManager.isAggregator(storageDataSet, columnArray[i], i)) continue;
            if (aggregatorArray == null) {
                aggregatorArray = new Aggregator[columnArray.length];
            }
            if (!AggManager.addAggregator(aggregatorArray, storageDataSet, columnArray[i], i)) continue;
            ++n;
        }
        if (aggregatorArray != null) {
            return new AggManager(storageDataSet, aggregatorArray, n);
        }
        return null;
    }

    private static boolean isAggregator(StorageDataSet storageDataSet, Column column, int n) throws DataSetException {
        if (column.getCalcType() == 2) {
            AggDescriptor aggDescriptor = storageDataSet.getColumn(n).getAgg();
            if (aggDescriptor == null) {
                return false;
            }
            String[] stringArray = aggDescriptor.getGroupColumnNames();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (storageDataSet.hasColumn(stringArray[i]) != null) continue;
                    DataSetException.throwInvalidAggDescriptor();
                }
            }
            return true;
        }
        return false;
    }

    private static boolean addAggregator(Aggregator[] aggregatorArray, StorageDataSet storageDataSet, Column column, int n) throws DataSetException {
        for (int i = 0; i < aggregatorArray.length; ++i) {
            Aggregator aggregator = aggregatorArray[i];
            if (aggregator == null || !column.getAgg().groupEquals(aggregator.getGroupColumnNames())) continue;
            aggregator.addColumn(storageDataSet, n);
            aggregatorArray[n] = aggregator;
            return false;
        }
        aggregatorArray[n] = new Aggregator(storageDataSet, n);
        return true;
    }

    private boolean findAggregator(Aggregator aggregator) {
        for (int i = 0; i < this.aggregators.length; ++i) {
            if (this.aggregators[i] != aggregator) continue;
            return true;
        }
        return false;
    }

    AggManager(StorageDataSet storageDataSet, Aggregator[] aggregatorArray, int n) throws DataSetException {
        this.aggregators = new Aggregator[n];
        this.aggregatorMap = aggregatorArray;
        this.dataSet = storageDataSet;
        this.internalReadRow = storageDataSet.getInternalReadRow();
        if (storageDataSet.calcAggFieldsListener != null) {
            this.customRow = new DataRow(storageDataSet, null, false);
        }
        int n2 = -1;
        for (int i = 0; i < aggregatorArray.length; ++i) {
            if (aggregatorArray[i] == null || this.findAggregator(aggregatorArray[i])) continue;
            this.aggregators[++n2] = aggregatorArray[i];
            this.aggregators[n2].open();
        }
    }

    public void add(ReadRow readRow, int n) throws DataSetException {
        for (int i = 0; i < this.aggregators.length; ++i) {
            this.aggregators[i].add(readRow, n);
        }
        if (this.dataSet.calcAggFieldsListener != null) {
            this.initCustomAgg(readRow);
            this.dataSet.calcAggFieldsListener.calcAggAdd(this.customRow, this.dataSet.calcFieldsRow);
            this.updateCustomAggs(readRow);
        }
    }

    public void delete(ReadRow readRow, int n) throws DataSetException {
        for (int i = 0; i < this.aggregators.length; ++i) {
            this.aggregators[i].delete(readRow, n);
        }
        if (this.dataSet.calcAggFieldsListener != null) {
            this.initCustomAgg(readRow);
            this.dataSet.calcAggFieldsListener.calcAggDelete(this.customRow, this.dataSet.calcFieldsRow);
            this.updateCustomAggs(readRow);
        }
    }

    public void update(ReadRow readRow, ReadRow readRow2, int n) throws DataSetException {
        if (this.loading) {
            this.add(readRow2, n);
        } else {
            for (int i = 0; i < this.aggregators.length; ++i) {
                this.aggregators[i].update(readRow, readRow2, n);
            }
            if (this.dataSet.calcAggFieldsListener != null) {
                this.initCustomAgg(readRow);
                this.dataSet.calcAggFieldsListener.calcAggAdd(this.customRow, this.dataSet.calcFieldsRow);
                this.updateCustomAggs(readRow);
                this.initCustomAgg(readRow2);
                this.dataSet.calcAggFieldsListener.calcAggDelete(this.customRow, this.dataSet.calcFieldsRow);
                this.updateCustomAggs(readRow2);
            }
        }
    }

    private final void initCustomAgg(ReadRow readRow) throws DataSetException {
        this.dataSet.calcFieldsRow._clearValues();
        readRow.copyTo(this.customRow);
        this.getRowData(this.customRow, (ReadWriteRow)this.customRow);
    }

    private final void updateCustomAggs(ReadRow readRow) throws DataSetException {
        for (int i = 0; i < this.aggregators.length; ++i) {
            this.aggregators[i].updateCustomAggs(readRow, this.dataSet.calcFieldsRow);
        }
    }

    public void getVariant(ReadRow readRow, int n, Variant variant) throws DataSetException {
        this.aggregatorMap[n].getVariant(readRow, n, variant);
    }

    public void getVariant(int n, int n2, Variant variant) throws DataSetException {
        this.internalReadRow.setInternalRow(n);
        this.aggregatorMap[n2].getVariant(this.internalReadRow, n2, variant);
    }

    public void getRowData(int n, ReadWriteRow readWriteRow) throws DataSetException {
        this.internalReadRow.setInternalRow(n);
        for (int i = 0; i < this.aggregators.length; ++i) {
            this.aggregators[i].getRowData(this.internalReadRow, readWriteRow);
        }
    }

    public void getRowData(ReadRow readRow, ReadWriteRow readWriteRow) throws DataSetException {
        for (int i = 0; i < this.aggregators.length; ++i) {
            this.aggregators[i].getRowData(readRow, readWriteRow);
        }
    }

    public boolean isCalc(int n) {
        return this.aggregatorMap[n] != null;
    }

    public void setLoading(boolean bl) {
        this.loading = bl;
    }
}

