/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.dataset;

import borland.jbcl.dataset.AggManager;
import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.DataSet;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.DataSetView;
import borland.jbcl.dataset.DirectIndex;
import borland.jbcl.dataset.InternalRow;
import borland.jbcl.dataset.RowFilterListener;
import borland.jbcl.dataset.SortDescriptor;
import borland.jbcl.dataset.StorageDataSet;
import borland.jbcl.util.Variant;

public abstract class MatrixData {
    DirectIndex insertIndex;
    DirectIndex updateIndex;
    DirectIndex deleteIndex;
    private InternalRow internalReadRow;
    private DirectIndex[] indexes;
    private int indexesLength;

    public abstract int getRowCount();

    public abstract void openData(StorageDataSet var1) throws DataSetException;

    public abstract DirectIndex createIndex(StorageDataSet var1, SortDescriptor var2, RowFilterListener var3, int var4, int var5) throws DataSetException;

    public abstract void addColumn(Column var1) throws DataSetException;

    public abstract void dropColumn(int var1) throws DataSetException;

    public abstract void changeColumn(int var1, Column var2, Column var3) throws DataSetException;

    public abstract void moveColumn(int var1, int var2) throws DataSetException;

    public void prepareRestructure(StorageDataSet storageDataSet) throws DataSetException {
    }

    public void commitRestructure(StorageDataSet storageDataSet) throws DataSetException {
    }

    public abstract void restructure(StorageDataSet var1, boolean var2, Column[] var3, Variant[] var4, AggManager var5) throws DataSetException;

    public abstract boolean getNeedsRestructure();

    public abstract void setNeedsRecalc(boolean var1);

    public abstract boolean getNeedsRecalc();

    public abstract boolean copyStreams();

    public abstract boolean validColumnType(int var1);

    public abstract int addStoreRow(Variant[] var1, int var2) throws DataSetException;

    public abstract void deleteStoreRow(int var1) throws DataSetException;

    public abstract void updateStoreRow(int var1, Variant[] var2, Column[] var3) throws DataSetException;

    public abstract void saveStoreRow(int var1, int var2) throws DataSetException;

    public abstract void getVariant(int var1, int var2, Variant var3) throws DataSetException;

    public abstract void getRowData(int var1, Variant[] var2) throws DataSetException;

    public abstract void getOriginalRow(int var1, Variant[] var2) throws DataSetException;

    public abstract int getStatus(int var1);

    public abstract void setStatus(int var1, int var2);

    public final DirectIndex openIndex(DataSet dataSet) throws DataSetException {
        RowFilterListener rowFilterListener = dataSet.getRowFilterListener();
        DirectIndex directIndex = this.openIndex(dataSet.getStorageDataSet(), dataSet.getSort(), rowFilterListener, dataSet.visibleMask, dataSet.invisibleMask);
        return directIndex;
    }

    final DirectIndex openIndex(StorageDataSet storageDataSet, SortDescriptor sortDescriptor, RowFilterListener rowFilterListener, int n, int n2) throws DataSetException {
        if (n == 2 && this.updateIndex != null) {
            return this.updateIndex;
        }
        if (n == 1 && this.deleteIndex != null) {
            return this.deleteIndex;
        }
        if (n == 4 && this.insertIndex != null) {
            return this.insertIndex;
        }
        DirectIndex directIndex = this.findIndex(sortDescriptor, rowFilterListener, n, n2);
        if (directIndex == null && (directIndex = this.createIndex(storageDataSet, sortDescriptor, rowFilterListener, n, n2)).isMaintained()) {
            int n3;
            if (n == 2) {
                this.updateIndex = directIndex;
            } else if (n == 1) {
                this.deleteIndex = directIndex;
            } else if (n == 4) {
                this.insertIndex = directIndex;
            } else {
                n3 = this.indexes == null ? 0 : this.indexesLength;
                DirectIndex[] directIndexArray = new DirectIndex[n3 + 1];
                if (n3 > 0) {
                    System.arraycopy(this.indexes, 0, directIndexArray, 0, n3);
                }
                this.indexes = directIndexArray;
                this.indexes[n3] = directIndex;
                this.indexesLength = this.indexes.length;
            }
            n3 = this.getRowCount();
            for (int i = 0; i < n3; ++i) {
                directIndex.load(i);
            }
            directIndex.sort();
        }
        return directIndex;
    }

    public void freeAllIndexes() {
        this.indexesLength = 0;
        this.indexes = null;
        this.insertIndex = null;
        this.deleteIndex = null;
        this.updateIndex = null;
    }

    public void freeIndex(DataSet dataSet) {
        DirectIndex directIndex = this.findIndex(dataSet.getSort(), dataSet.getRowFilterListener(), dataSet.visibleMask, dataSet.invisibleMask);
        for (int i = 0; i < this.indexesLength; ++i) {
            if (this.indexes[i] != directIndex) continue;
            --this.indexesLength;
            if (this.indexesLength > i) {
                System.arraycopy(this.indexes, i + 1, this.indexes, i, this.indexesLength - i);
            }
            DirectIndex[] directIndexArray = new DirectIndex[this.indexesLength];
            System.arraycopy(this.indexes, 0, directIndexArray, 0, this.indexesLength);
            break;
        }
    }

    private final boolean sortEquals(SortDescriptor sortDescriptor, SortDescriptor sortDescriptor2) {
        if (sortDescriptor == sortDescriptor2) {
            return true;
        }
        if (sortDescriptor == null || sortDescriptor2 == null) {
            return false;
        }
        return sortDescriptor.equals(sortDescriptor2);
    }

    private final DirectIndex findIndex(SortDescriptor sortDescriptor, RowFilterListener rowFilterListener, int n, int n2) {
        for (int i = 0; i < this.indexesLength; ++i) {
            if (!this.sortEquals(sortDescriptor, this.indexes[i].descriptor) || this.indexes[i].visibleMask != n || this.indexes[i].invisibleMask != n2 || this.indexes[i].rowFilterListener != rowFilterListener) continue;
            return this.indexes[i];
        }
        return null;
    }

    public final int addRow(Variant[] variantArray, int n) throws DataSetException {
        int n2 = this.addStoreRow(variantArray, n);
        if (this.insertIndex != null && (n & 4) != 0) {
            this.insertIndex.add(n2);
        }
        this.indexAdd(n2);
        return n2;
    }

    public final void deleteRow(int n) throws DataSetException {
        this.deleteStoreRow(n);
        if (this.deleteIndex != null) {
            this.deleteIndex.add(n);
        }
        this.indexDelete(n);
    }

    public final void updateRow(int n, Variant[] variantArray, Column[] columnArray) throws DataSetException {
        this.saveRow(n);
        this.indexPrepareReplace(n);
        this.updateStoreRow(n, variantArray, columnArray);
        this.indexReplace(n);
    }

    private final void saveRow(int n, int n2) throws DataSetException {
        this.setStatus(n, 2 | n2);
        this.saveStoreRow(n, n2);
    }

    private final void saveRow(int n) throws DataSetException {
        if (this.updateIndex != null) {
            int n2 = this.getStatus(n);
            if ((n2 & 0x100) != 0) {
                this.saveRow(n, n2 & 0xFFFFFEFF);
            } else if ((n2 & 2) == 0 && ((n2 & 4) == 0 || (n2 & 0x40) != 0)) {
                this.saveRow(n, n2);
                this.updateIndex.add(n);
            }
        }
    }

    public final void resolvePending(boolean bl) throws DataSetException {
        this.updateIndex.resolvePending(bl, 256);
        this.insertIndex.resolvePending(bl, 64);
        this.deleteIndex.resolvePending(bl, 128);
    }

    private final void indexAdd(int n) throws DataSetException {
        for (int i = 0; i < this.indexesLength; ++i) {
            this.indexes[i].add(n);
        }
    }

    private final void indexDelete(int n) throws DataSetException {
        for (int i = 0; i < this.indexesLength; ++i) {
            this.indexes[i].delete(n);
        }
    }

    private final void indexPrepareReplace(int n) {
        for (int i = 0; i < this.indexesLength; ++i) {
            this.indexes[i].prepareReplace(n);
        }
    }

    private final void indexReplace(int n) throws DataSetException {
        for (int i = 0; i < this.indexesLength; ++i) {
            this.indexes[i].replace(n);
        }
    }

    final InternalRow getInternalReadRow(StorageDataSet storageDataSet) {
        if (this.internalReadRow == null) {
            this.internalReadRow = new InternalRow(storageDataSet, this);
        }
        return this.internalReadRow;
    }

    void recalc(StorageDataSet storageDataSet, AggManager aggManager) throws DataSetException {
        DataSetView dataSetView = new DataSetView();
        dataSetView.setStorageDataSet(storageDataSet);
        dataSetView.open();
        while (dataSetView.inBounds()) {
            dataSetView.rowEdited();
            dataSetView.next();
        }
        dataSetView.post();
        dataSetView.close();
    }
}

