/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.dataset;

import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.ReadRow;
import borland.jbcl.dataset.RowVariant;
import borland.jbcl.dataset.ValidationException;
import borland.jbcl.util.Variant;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public abstract class ReadWriteRow
extends ReadRow {
    private RowVariant[] setValues;
    boolean hasRequiredColumns;
    boolean notifyColumnPost;

    abstract void rowEdited() throws DataSetException;

    abstract void processColumnPost(RowVariant var1) throws DataSetException;

    void notifyColumnPost(RowVariant rowVariant) throws DataSetException {
    }

    private final RowVariant getSetStorage(String string) throws DataSetException {
        this.rowEdited();
        return this.setValues[this.columnList.getOrdinal(string)];
    }

    private final RowVariant getSetStorage(int n) throws DataSetException {
        this.rowEdited();
        return this.setValues[this.columnList.getScopedColumns()[n].ordinal];
    }

    final void initRowValues(boolean bl) {
        int n = this.columnList.columnCount();
        this.rowValues = new RowVariant[n];
        this.setValues = new RowVariant[n];
        this.hasRequiredColumns = false;
        for (int i = 0; i < n; ++i) {
            int n2 = this.columnList.getSetType(i);
            Column column = this.columnList.columns[i];
            if (column.isRequired()) {
                this.hasRequiredColumns = true;
            }
            this.rowValues[i] = new RowVariant(n2, column, null, bl);
            this.setValues[i] = this.rowValues[i].hasValidations ? new RowVariant(n2, column, this.rowValues[i], true) : this.rowValues[i];
        }
    }

    public final void clearValues() throws DataSetException {
        this.rowEdited();
        for (int i = 0; i < this.rowValues.length; ++i) {
            RowVariant rowVariant = this.setValues[i];
            if (this.notifyColumnPost || rowVariant.hasValidations) {
                rowVariant.setUnassignedNull();
                this.processColumnPost(rowVariant);
                continue;
            }
            this.rowValues[i].setUnassignedNull();
        }
    }

    final void _clearValues() {
        for (int i = 0; i < this.rowValues.length; ++i) {
            this.rowValues[i].setUnassignedNull();
        }
    }

    public final void setByte(String string, int n) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(string);
        rowVariant.setByte(n);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setShort(String string, short s) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(string);
        rowVariant.setShort(s);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setInt(String string, int n) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(string);
        rowVariant.setInt(n);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setLong(String string, long l) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(string);
        rowVariant.setLong(l);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setBoolean(String string, boolean bl) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(string);
        rowVariant.setBoolean(bl);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setDouble(String string, double d) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(string);
        rowVariant.setDouble(d);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setFloat(String string, float f) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(string);
        rowVariant.setFloat(f);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setString(String string, String string2) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(string);
        rowVariant.setString(string2);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setBigDecimal(String string, BigDecimal bigDecimal) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(string);
        rowVariant.setBigDecimal(bigDecimal);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setDate(String string, Date date) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(string);
        rowVariant.setDate(date);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setDate(String string, long l) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(string);
        rowVariant.setDate(l);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setTime(String string, Time time) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(string);
        rowVariant.setTime(time);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setTime(String string, long l) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(string);
        rowVariant.setTime(l);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setTimestamp(String string, Timestamp timestamp) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(string);
        rowVariant.setTimestamp(timestamp);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setTimestamp(String string, long l) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(string);
        rowVariant.setTimestamp(l);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setBinaryStream(String string, InputStream inputStream) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(string);
        rowVariant.setBinaryStream(inputStream);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setByteArray(String string, byte[] byArray, int n) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(string);
        rowVariant.setByteArray(byArray, n);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setAssignedNull(String string) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(string);
        rowVariant.setAssignedNull();
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setUnassignedNull(String string) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(string);
        rowVariant.setUnassignedNull();
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setVariant(String string, Variant variant) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(string);
        rowVariant.setVariant(variant);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public void setVariant(int n, Variant variant) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(n);
        rowVariant.setVariant(variant);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    void setVariantNoValidate(int n, Variant variant) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(n);
        rowVariant.rowVariant.setVariant(variant);
        if (this.notifyColumnPost) {
            this.notifyColumnPost(rowVariant);
        }
    }

    public final void setByte(int n, int n2) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(n);
        rowVariant.setByte(n2);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setShort(int n, short s) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(n);
        rowVariant.setShort(s);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setInt(int n, int n2) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(n);
        rowVariant.setInt(n2);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setLong(int n, long l) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(n);
        rowVariant.setLong(l);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setBoolean(int n, boolean bl) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(n);
        rowVariant.setBoolean(bl);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setDouble(int n, double d) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(n);
        rowVariant.setDouble(d);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setFloat(int n, float f) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(n);
        rowVariant.setFloat(f);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setString(int n, String string) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(n);
        rowVariant.setString(string);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setBigDecimal(int n, BigDecimal bigDecimal) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(n);
        rowVariant.setBigDecimal(bigDecimal);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setDate(int n, Date date) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(n);
        rowVariant.setDate(date);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setDate(int n, long l) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(n);
        rowVariant.setDate(l);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setTime(int n, Time time) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(n);
        rowVariant.setTime(time);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setTime(int n, long l) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(n);
        rowVariant.setTime(l);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setTimestamp(int n, Timestamp timestamp) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(n);
        rowVariant.setTimestamp(timestamp);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setTimestamp(int n, long l) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(n);
        rowVariant.setTimestamp(l);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setBinaryStream(int n, InputStream inputStream) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(n);
        rowVariant.setBinaryStream(inputStream);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setByteArray(int n, byte[] byArray, int n2) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(n);
        rowVariant.setByteArray(byArray, n2);
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setAssignedNull(int n) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(n);
        rowVariant.setAssignedNull();
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public final void setUnassignedNull(int n) throws DataSetException {
        RowVariant rowVariant = this.getSetStorage(n);
        rowVariant.setUnassignedNull();
        if (this.notifyColumnPost || rowVariant.hasValidations) {
            this.processColumnPost(rowVariant);
        }
    }

    public void setDefaultValues() throws DataSetException {
        this.columnList.setDefaultValues(this.rowValues);
    }

    public void requiredColumnsCheck() throws ValidationException {
        if (this.hasRequiredColumns) {
            for (int i = 0; i < this.rowValues.length; ++i) {
                if (!this.rowValues[i].isNull() || !this.rowValues[i].column.isRequired()) continue;
                ValidationException.throwInvalidRowValues(null);
            }
        }
    }
}

