/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.dataset;

import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.DataSet;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.Res;

public class ValidationException
extends DataSetException {
    private static final int BASE = 1024;
    public static final int READ_ONLY_COLUMN = 1025;
    public static final int READ_ONLY_DATASET = 1026;
    public static final int CANNOT_ORPHAN_DETAILS = 1027;
    public static final int INVALID_COLUMN_VALUE = 1028;
    public static final int INVALID_ROW_VALUES = 1029;
    public static final int LESS_THAN_MIN = 1031;
    public static final int GREATER_THAN_MAX = 1032;
    public static final int INVALID_PRECISION = 1033;
    public static final int CANNOT_DITTO_EXISTING = 1034;
    public static final int INVALID_FORMAT = 1035;
    public static final int APPLICATION_ERROR = 1036;
    public static final int NO_ROWS_TO_DELETE = 1037;
    private Column column;

    static final void throwReadOnlyColumn(Column column) throws ValidationException {
        ValidationException.throwValidationException(1025, Res.getString(6), column);
    }

    static final void throwReadOnlyDataSet() throws ValidationException {
        ValidationException.throwValidationException(1026, Res.getString(7), null);
    }

    static final void throwCannotOrphanDetails() throws ValidationException {
        ValidationException.throwValidationException(1027, Res.getString(38), null);
    }

    static final void throwCannotOrphanDetails(Exception exception) throws DataSetException {
        ValidationException.throwValidationException(1027, Res.getString(38), null, exception);
    }

    static final void throwCannotDittoExisting() throws ValidationException {
        ValidationException.throwValidationException(1034, Res.getString(93), null);
    }

    static final void throwInvalidColumnValue(String string) throws ValidationException {
        if (string == null) {
            string = Res.getString(39);
        }
        ValidationException.throwValidationException(1028, string, null);
    }

    static final void throwInvalidRowValues(String string) throws ValidationException {
        if (string == null) {
            string = Res.getString(40);
        }
        ValidationException.throwValidationException(1029, string, null);
    }

    static final void throwLessThanMin(Column column, String string, String string2) throws ValidationException {
        ValidationException.throwValidationException(1031, Res.format(82, new String[]{column.getColumnName(), string, string2}), column);
    }

    static final void throwGreaterThanMax(Column column, String string, String string2) throws ValidationException {
        ValidationException.throwValidationException(1032, Res.format(83, new String[]{column.getColumnName(), string, string2}), column);
    }

    static final void throwInvalidPrecision(Column column) throws ValidationException {
        ValidationException.throwValidationException(1033, Res.format(86, new String[]{column.getColumnName(), Integer.toString(column.getPrecision())}), column);
    }

    static final void throwApplicationError(Exception exception) throws DataSetException {
        ValidationException.throwValidationException(1036, exception.getMessage(), null, exception);
    }

    static final void throwNoRowsToDelete(DataSet dataSet) throws DataSetException {
        ValidationException.throwValidationException(1037, Res.format(101, dataSet.getTableName()), null);
    }

    public ValidationException(int n, String string, Column column) {
        super(n, string);
        this.column = column;
    }

    public ValidationException(int n, String string, Column column, Exception exception) {
        super(n, string, exception);
        this.column = column;
    }

    static final void throwValidationException(int n, String string, Column column) throws ValidationException {
        throw new ValidationException(n, string, column);
    }

    static final void throwValidationException(int n, String string, Column column, Exception exception) throws DataSetException {
        if (exception instanceof DataSetException) {
            throw (DataSetException)exception;
        }
        throw new ValidationException(n, string, column, exception);
    }

    public final Column getErrorColumn() {
        return this.column;
    }
}

