/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.view;

import COM.objectspace.jgl.Array;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.text.BreakIterator;
import java.util.Enumeration;

public class TextWrapper {
    int alignment;
    FontMetrics fontMetrics;
    BreakIterator textBoundary;
    Font font;
    String[] lines;
    int[] length;
    String text;
    int hintWidth;
    int lineCount;
    int charHeight;
    Dimension size;

    TextWrapper(Font font, String string, int n, int n2) {
        this.alignment = n;
        this.font = font;
        this.fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        this.textBoundary = BreakIterator.getWordInstance();
        this.text = string;
        this.hintWidth = n2;
        this.charHeight = this.fontMetrics.getHeight();
    }

    public Dimension getSize(Graphics graphics) {
        if (this.size == null) {
            this.calcSize(graphics);
        }
        return this.size;
    }

    protected void calcSize(Graphics graphics) {
        Array array = new Array();
        this.textBoundary.setText(this.text);
        int n = this.textBoundary.first();
        int n2 = this.textBoundary.next();
        while (n2 != -1) {
            array.add(this.text.substring(n, n2));
            n = n2;
            n2 = this.textBoundary.next();
        }
        this.lines = new String[array.size()];
        this.length = new int[array.size()];
        this.lineCount = 0;
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Enumeration enumeration = array.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            int n6 = this.fontMetrics.stringWidth(string);
            int n7 = this.length[n3] + n6;
            if (n7 <= this.hintWidth) {
                if (this.lines[n3] == null) {
                    this.lines[n3] = string;
                    this.length[n3] = n6;
                    bl = false;
                    ++this.lineCount;
                    n5 += this.charHeight;
                    if (n7 <= n4) continue;
                    n4 = n7;
                    continue;
                }
                this.lines[n3] = String.valueOf(this.lines[n3]).concat(String.valueOf(string));
                this.length[n3] = n7;
                if (n7 <= n4) continue;
                n4 = n7;
                continue;
            }
            if (n6 > n4) {
                n4 = n6;
            }
            if (this.length[n3] == 0) {
                this.lines[n3] = string;
                this.length[n3] = n6;
                ++this.lineCount;
                ++n3;
            } else {
                ++this.lineCount;
                this.lines[++n3] = string;
                this.length[n3] = n6;
            }
            bl = false;
            n5 += this.charHeight;
        }
        this.size = new Dimension(n4, n5);
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
        n2 += (n4 - this.lineCount * this.charHeight) / 2;
        for (int i = 0; i < this.lineCount; ++i) {
            int n5;
            switch (this.alignment) {
                default: {
                    n5 = (n3 - this.length[i]) / 2;
                    break;
                }
                case 1: {
                    n5 = 0;
                    break;
                }
                case 3: {
                    n5 = n3 - this.length[i];
                }
            }
            graphics.drawString(this.lines[i], n + n5, n2 + this.charHeight);
            n2 += this.charHeight;
        }
    }
}

