/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.util.AbstractUIHandler;
import com.izforge.izpack.util.MultiLineLabel;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.n3.nanoxml.XMLElement;

public class IzPanel
extends JPanel
implements AbstractUIHandler {
    protected boolean gridBagLayoutStarted = false;
    protected Component initialFocus = null;
    protected InstallData idata;
    protected InstallerFrame parent;
    protected GridBagConstraints defaultGridBagConstraints = new GridBagConstraints();
    protected int gridxCounter = -1;
    protected int gridyCounter = -1;

    public IzPanel(InstallerFrame parent, InstallData idata) {
        this.idata = idata;
        this.parent = parent;
    }

    public boolean isValidated() {
        return true;
    }

    public void panelActivate() {
    }

    public void panelDeactivate() {
    }

    public void makeXMLData(XMLElement panelRoot) {
    }

    public int askQuestion(String title, String question, int choices) {
        return this.askQuestion(title, question, choices, -1);
    }

    public int askQuestion(String title, String question, int choices, int default_choice) {
        int jo_choices = 0;
        if (choices == 37) {
            jo_choices = 0;
        } else if (choices == 38) {
            jo_choices = 1;
        }
        int user_choice = JOptionPane.showConfirmDialog(this, question, title, jo_choices, 3);
        if (user_choice == 2) {
            return 45;
        }
        if (user_choice == 0) {
            return 47;
        }
        if (user_choice == 1) {
            return 49;
        }
        return default_choice;
    }

    public void emitNotification(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    public boolean emitWarning(String title, String message) {
        return JOptionPane.showConfirmDialog(this, message, title, 2, 2) == 0;
    }

    public void emitError(String title, String message) {
        JOptionPane.showMessageDialog(this, message, title, 0);
    }

    public Component getInitialFocus() {
        return this.initialFocus;
    }

    public void setInitialFocus(Component component) {
        this.initialFocus = component;
    }

    public String getI18nStringForClass(String subkey, String alternateClass) {
        String curClassName = this.getClass().getName();
        int nameStart = curClassName.lastIndexOf(46) + 1;
        curClassName = curClassName.substring(nameStart, curClassName.length());
        StringBuffer buf = new StringBuffer();
        buf.append(curClassName).append(".").append(subkey);
        String fullkey = buf.toString();
        String retval = this.parent.langpack.getString(fullkey);
        if (retval == null || retval.equals(fullkey)) {
            buf.delete(0, buf.length());
            buf.append(alternateClass).append(".").append(subkey);
            retval = this.parent.langpack.getString(buf.toString());
        }
        return retval;
    }

    public InstallerFrame getInstallerFrame() {
        return this.parent;
    }

    public JLabel createLabel(String textId, String iconId, int pos) {
        ImageIcon ii = iconId != null ? this.parent.icons.getImageIcon(iconId) : null;
        JLabel label = LabelFactory.create(this.parent.langpack.getString(textId), ii, pos);
        if (label != null) {
            label.setFont(this.getControlTextFont());
        }
        return label;
    }

    public MultiLineLabel createMultiLineLabelLang(String textId) {
        return this.createMultiLineLabel(this.parent.langpack.getString(textId));
    }

    public MultiLineLabel createMultiLineLabel(String text) {
        return this.createMultiLineLabel(text, null, 2);
    }

    public MultiLineLabel createMultiLineLabel(String text, String iconId, int pos) {
        MultiLineLabel mll = null;
        mll = new MultiLineLabel(text, 0, 0);
        if (mll != null) {
            mll.setFont(this.getControlTextFont());
        }
        return mll;
    }

    public Font getControlTextFont() {
        return IzPanel.getLAF() != null ? MetalLookAndFeel.getControlTextFont() : this.getFont();
    }

    protected static MetalLookAndFeel getLAF() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf instanceof MetalLookAndFeel) {
            return (MetalLookAndFeel)laf;
        }
        return null;
    }

    public GridBagConstraints getDefaultGridBagConstraints() {
        this.startGridBagLayout();
        return this.defaultGridBagConstraints;
    }

    public void setDefaultGridBagConstraints(GridBagConstraints constraints) {
        this.startGridBagLayout();
        this.defaultGridBagConstraints = constraints;
    }

    public void resetGridCounter() {
        this.gridxCounter = -1;
        this.gridyCounter = -1;
    }

    public GridBagConstraints getNewGridBagConstraints(int gridx, int gridy) {
        GridBagConstraints retval = (GridBagConstraints)this.getDefaultGridBagConstraints().clone();
        retval.gridx = gridx;
        retval.gridy = gridy;
        return retval;
    }

    public GridBagConstraints getNewGridBagConstraints(int gridx, int gridy, int gridwidth, int gridheight) {
        GridBagConstraints retval = this.getNewGridBagConstraints(gridx, gridy);
        retval.gridwidth = gridwidth;
        retval.gridheight = gridheight;
        return retval;
    }

    public GridBagConstraints getNextXGridBagConstraints() {
        ++this.gridxCounter;
        GridBagConstraints retval = this.getNewGridBagConstraints(this.gridxCounter, this.gridyCounter);
        return retval;
    }

    private GridBagConstraints getNextXGridBagConstraints(int gridwidth, int gridheight) {
        GridBagConstraints retval = this.getNextXGridBagConstraints();
        retval.gridwidth = gridwidth;
        retval.gridheight = gridheight;
        return retval;
    }

    public GridBagConstraints getNextYGridBagConstraints() {
        ++this.gridyCounter;
        this.gridxCounter = 0;
        GridBagConstraints retval = this.getNewGridBagConstraints(0, this.gridyCounter);
        return retval;
    }

    public GridBagConstraints getNextYGridBagConstraints(int gridwidth, int gridheight) {
        this.startGridBagLayout();
        GridBagConstraints retval = this.getNextYGridBagConstraints();
        retval.gridwidth = gridwidth;
        retval.gridheight = gridheight;
        return retval;
    }

    public void startGridBagLayout() {
        if (this.gridBagLayoutStarted) {
            return;
        }
        this.gridBagLayoutStarted = true;
        GridBagLayout layout = new GridBagLayout();
        this.defaultGridBagConstraints.insets = new Insets(0, 0, 20, 0);
        this.defaultGridBagConstraints.anchor = 17;
        this.setLayout(layout);
        String todo = this.idata.getVariable("IzPanel.LayoutType");
        if (todo == null) {
            return;
        }
        if (todo.equals("BOTTOM")) {
            Filler dummy = new Filler();
            GridBagConstraints gbConstraint = this.getNextYGridBagConstraints();
            gbConstraint.weighty = 1.0;
            gbConstraint.fill = 1;
            gbConstraint.anchor = 17;
            this.add((Component)dummy, gbConstraint);
        }
    }

    public void completeGridBagLayout() {
        String todo = this.idata.getVariable("IzPanel.LayoutType");
        if (todo == null) {
            return;
        }
        if (todo.equals("TOP")) {
            Filler dummy = new Filler();
            GridBagConstraints gbConstraint = this.getNextYGridBagConstraints();
            gbConstraint.weighty = 1.0;
            gbConstraint.fill = 1;
            gbConstraint.anchor = 17;
            this.add((Component)dummy, gbConstraint);
        }
    }

    public static class Filler
    extends JComponent {
    }
}

