/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.message;

import gov.nist.core.GenericObject;
import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.ContactList;
import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.header.ContentType;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.MaxForwards;
import gov.nist.javax.sip.header.ProxyAuthorization;
import gov.nist.javax.sip.header.ProxyRequireList;
import gov.nist.javax.sip.header.RecordRouteList;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.RequireList;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.TimeStamp;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPDuplicateHeaderException;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPResponse;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.sip.InvalidArgumentException;
import javax.sip.address.URI;
import javax.sip.message.Request;

public final class SIPRequest
extends SIPMessage
implements Request {
    private static final String DEFAULT_USER = "ip";
    private static final int DEFAULT_TTL = 1;
    private static final String DEFAULT_TRANSPORT = "udp";
    private static final String DEFAULT_METHOD = "INVITE";
    private Object transactionPointer;
    protected RequestLine requestLine;

    public static String getCannonicalName(String method) {
        if (method.equalsIgnoreCase(DEFAULT_METHOD)) {
            return DEFAULT_METHOD;
        }
        if (method.equalsIgnoreCase("BYE")) {
            return "BYE";
        }
        if (method.equalsIgnoreCase("ACK")) {
            return "ACK";
        }
        if (method.equalsIgnoreCase("PRACK")) {
            return "PRACK";
        }
        if (method.equalsIgnoreCase("INFO")) {
            return "INFO";
        }
        if (method.equalsIgnoreCase("UPDATE")) {
            return "UPDATE";
        }
        if (method.equalsIgnoreCase("REFER")) {
            return "REFER";
        }
        if (method.equalsIgnoreCase("MESSAGE")) {
            return "MESSAGE";
        }
        if (method.equalsIgnoreCase("SUBSCRIBE")) {
            return "SUBSCRIBE";
        }
        if (method.equalsIgnoreCase("NOTIFY")) {
            return "NOTIFY";
        }
        if (method.equalsIgnoreCase("REGISTER")) {
            return "REGISTER";
        }
        if (method.equalsIgnoreCase("OPTIONS")) {
            return "OPTIONS";
        }
        return method;
    }

    public void replace(String ctext, GenericObject newObject, boolean matchSubstring) {
        if (ctext == null || newObject == null) {
            throw new IllegalArgumentException("Illegal argument null");
        }
        this.requestLine.replace(ctext, newObject, matchSubstring);
        super.replace(ctext, newObject, matchSubstring);
    }

    public RequestLine getRequestLine() {
        return this.requestLine;
    }

    public void setRequestLine(RequestLine requestLine) {
        this.requestLine = requestLine;
    }

    public String debugDump() {
        String superstring = super.debugDump();
        this.stringRepresentation = "";
        this.sprint("gov.nist.javax.sip.message.SIPRequest");
        this.sprint("{");
        if (this.requestLine != null) {
            this.sprint(this.requestLine.debugDump());
        }
        this.sprint(superstring);
        this.sprint("}");
        return this.stringRepresentation;
    }

    protected void checkHeaders() throws ParseException {
        String prefix = "Missing Header ";
        if (this.getCSeq() == null) {
            throw new ParseException(prefix + "CSeq", 0);
        }
        if (this.getTo() == null) {
            throw new ParseException(prefix + "To", 0);
        }
        if (this.getFrom() == null) {
            throw new ParseException(prefix + "From", 0);
        }
        if (this.getViaHeaders() == null) {
            throw new ParseException(prefix + "Via", 0);
        }
        if (this.getMaxForwards() == null) {
            throw new ParseException(prefix + "Max-Forwards", 0);
        }
        if (this.requestLine != null && this.requestLine.getMethod() != null && this.getCSeq().getMethod() != null && this.requestLine.getMethod().compareToIgnoreCase(this.getCSeq().getMethod()) != 0) {
            throw new ParseException("CSEQ method mismatch with  Request-Line ", 0);
        }
    }

    protected void setDefaults() {
        if (this.requestLine == null) {
            return;
        }
        String method = this.requestLine.getMethod();
        if (method == null) {
            return;
        }
        GenericURI u = this.requestLine.getUri();
        if (u == null) {
            return;
        }
        if ((method.compareTo("REGISTER") == 0 || method.compareTo(DEFAULT_METHOD) == 0) && u instanceof SipUri) {
            SipUri sipUri = (SipUri)u;
            sipUri.setUserParam(DEFAULT_USER);
            try {
                sipUri.setTransportParam(DEFAULT_TRANSPORT);
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
    }

    protected void setRequestLineDefaults() {
        CSeq cseq;
        String method = this.requestLine.getMethod();
        if (method == null && (cseq = (CSeq)this.getCSeq()) != null) {
            method = cseq.getMethod();
            this.requestLine.setMethod(method);
        }
    }

    public URI getRequestURI() {
        if (this.requestLine == null) {
            return null;
        }
        return this.requestLine.getUri();
    }

    public void setRequestURI(URI uri) {
        if (this.requestLine == null) {
            this.requestLine = new RequestLine();
        }
        this.requestLine.setUri((GenericURI)uri);
    }

    public void setMethod(String method) {
        if (method == null) {
            throw new IllegalArgumentException("null method");
        }
        if (this.requestLine == null) {
            this.requestLine = new RequestLine();
        }
        String meth = SIPRequest.getCannonicalName(method);
        this.requestLine.setMethod(meth);
        if (this.cSeqHeader != null) {
            try {
                this.cSeqHeader.setMethod(method);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public String getMethod() {
        if (this.requestLine == null) {
            return null;
        }
        return this.requestLine.getMethod();
    }

    public String encode() {
        String retval;
        if (this.requestLine != null) {
            this.setRequestLineDefaults();
            retval = this.requestLine.encode() + super.encode();
        } else {
            retval = super.encode();
        }
        return retval;
    }

    public String encodeMessage() {
        String retval;
        if (this.requestLine != null) {
            this.setRequestLineDefaults();
            retval = this.requestLine.encode() + super.encodeSIPHeaders();
        } else {
            retval = super.encodeSIPHeaders();
        }
        return retval;
    }

    public String toString() {
        return this.encode();
    }

    public Object clone() {
        SIPRequest retval = (SIPRequest)super.clone();
        if (this.requestLine != null) {
            retval.requestLine = (RequestLine)this.requestLine.clone();
            retval.setRequestLineDefaults();
        }
        return retval;
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        SIPRequest that = (SIPRequest)other;
        return this.requestLine.equals(that.requestLine) && super.equals(other);
    }

    public LinkedList getMessageAsEncodedStrings() {
        LinkedList retval = super.getMessageAsEncodedStrings();
        if (this.requestLine != null) {
            this.setRequestLineDefaults();
            retval.addFirst(this.requestLine.encode());
        }
        return retval;
    }

    public boolean match(Object matchObj) {
        if (matchObj == null) {
            return true;
        }
        if (!matchObj.getClass().equals(this.getClass())) {
            return false;
        }
        if (matchObj == this) {
            return true;
        }
        SIPRequest that = (SIPRequest)matchObj;
        RequestLine rline = that.requestLine;
        if (this.requestLine == null && rline != null) {
            return false;
        }
        if (this.requestLine == rline) {
            return super.match(matchObj);
        }
        return this.requestLine.match(that.requestLine) && super.match(matchObj);
    }

    public String getDialogId(boolean isServer) {
        CallID cid = (CallID)this.getCallId();
        StringBuffer retval = new StringBuffer(cid.getCallId());
        From from = (From)this.getFrom();
        To to = (To)this.getTo();
        if (!isServer) {
            retval.append(":").append(from.getUserAtHostPort());
            if (from.getTag() != null) {
                retval.append(":");
                retval.append(from.getTag());
            }
            retval.append(":").append(to.getUserAtHostPort());
            if (to.getTag() != null) {
                retval.append(":");
                retval.append(to.getTag());
            }
        } else {
            retval.append(":").append(to.getUserAtHostPort());
            if (to.getTag() != null) {
                retval.append(":");
                retval.append(to.getTag());
            }
            retval.append(":").append(from.getUserAtHostPort());
            if (from.getTag() != null) {
                retval.append(":");
                retval.append(from.getTag());
            }
        }
        return retval.toString().toLowerCase();
    }

    public String getDialogId(boolean isServer, String toTag) {
        From from = (From)this.getFrom();
        To to = (To)this.getTo();
        CallID cid = (CallID)this.getCallId();
        StringBuffer retval = new StringBuffer(cid.getCallId());
        if (!isServer) {
            retval.append(":").append(from.getUserAtHostPort());
            if (from.getTag() != null) {
                retval.append(":");
                retval.append(from.getTag());
            }
            retval.append(":").append(to.getUserAtHostPort());
            if (toTag != null) {
                retval.append(":");
                retval.append(toTag);
            }
        } else {
            retval.append(":").append(to.getUserAtHostPort());
            if (toTag != null) {
                retval.append(":");
                retval.append(toTag);
            }
            retval.append(":").append(from.getUserAtHostPort());
            if (from.getTag() != null) {
                retval.append(":");
                retval.append(from.getTag());
            }
        }
        return retval.toString().toLowerCase();
    }

    public byte[] encodeAsBytes() {
        byte[] rlbytes = null;
        if (this.requestLine != null) {
            try {
                rlbytes = this.requestLine.encode().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                InternalErrorHandler.handleException(ex);
            }
        }
        byte[] superbytes = super.encodeAsBytes();
        byte[] retval = new byte[rlbytes.length + superbytes.length];
        boolean i = false;
        System.arraycopy(rlbytes, 0, retval, 0, rlbytes.length);
        System.arraycopy(superbytes, 0, retval, rlbytes.length, superbytes.length);
        return retval;
    }

    public SIPResponse createResponse(int statusCode) {
        String reasonPhrase = SIPResponse.getReasonPhrase(statusCode);
        return this.createResponse(statusCode, reasonPhrase);
    }

    public SIPResponse createResponse(int statusCode, String reasonPhrase) {
        SIPResponse newResponse = new SIPResponse();
        try {
            newResponse.setStatusCode(statusCode);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Bad code " + statusCode);
        }
        if (reasonPhrase != null) {
            newResponse.setReasonPhrase(reasonPhrase);
        } else {
            newResponse.setReasonPhrase(SIPResponse.getReasonPhrase(statusCode));
        }
        ListIterator headerIterator = this.getHeaders();
        while (headerIterator.hasNext()) {
            SIPHeader nextHeader = (SIPHeader)headerIterator.next();
            if (!(nextHeader instanceof From) && !(nextHeader instanceof To) && !(nextHeader instanceof ViaList) && !(nextHeader instanceof CallID) && !(nextHeader instanceof RecordRouteList) && !(nextHeader instanceof CSeq) && !(nextHeader instanceof MaxForwards) && !(nextHeader instanceof TimeStamp)) continue;
            try {
                newResponse.attachHeader(nextHeader, false);
            }
            catch (SIPDuplicateHeaderException e) {
                e.printStackTrace();
            }
        }
        return newResponse;
    }

    public SIPRequest createCancelRequest() {
        SIPRequest newRequest = new SIPRequest();
        newRequest.setRequestLine((RequestLine)this.requestLine.clone());
        newRequest.setMethod("CANCEL");
        ListIterator headerIterator = this.getHeaders();
        while (headerIterator.hasNext()) {
            SIPHeader nextHeader = (SIPHeader)headerIterator.next();
            if (nextHeader instanceof RequireList || nextHeader instanceof ProxyRequireList || nextHeader instanceof ContentLength || nextHeader instanceof ContentType) continue;
            if (nextHeader instanceof ViaList) {
                nextHeader = (ViaList)((ViaList)nextHeader).clone();
            }
            if (nextHeader instanceof CSeq) {
                CSeq cseq = (CSeq)nextHeader.clone();
                try {
                    cseq.setMethod("CANCEL");
                }
                catch (ParseException e) {
                    // empty catch block
                }
                nextHeader = cseq;
            }
            try {
                newRequest.attachHeader(nextHeader, false);
            }
            catch (SIPDuplicateHeaderException e) {
                e.printStackTrace();
            }
        }
        return newRequest;
    }

    public SIPRequest createAckRequest(To responseToHeader) {
        SIPRequest newRequest = new SIPRequest();
        newRequest.setRequestLine((RequestLine)this.requestLine.clone());
        newRequest.setMethod("ACK");
        ListIterator headerIterator = this.getHeaders();
        while (headerIterator.hasNext()) {
            SIPHeader nextHeader = (SIPHeader)headerIterator.next();
            if (nextHeader instanceof RouteList || nextHeader instanceof ProxyAuthorization) continue;
            if (nextHeader instanceof ContentLength) {
                nextHeader = (SIPHeader)nextHeader.clone();
                try {
                    ((ContentLength)nextHeader).setContentLength(0);
                }
                catch (InvalidArgumentException e) {}
            } else {
                if (nextHeader instanceof ContentType) continue;
                if (nextHeader instanceof CSeq) {
                    CSeq cseq = (CSeq)nextHeader.clone();
                    try {
                        cseq.setMethod("ACK");
                    }
                    catch (ParseException e) {
                        // empty catch block
                    }
                    nextHeader = cseq;
                } else if (nextHeader instanceof To) {
                    nextHeader = responseToHeader != null ? responseToHeader : (SIPHeader)nextHeader.clone();
                } else {
                    if (nextHeader instanceof ContactList) continue;
                    nextHeader = nextHeader instanceof ViaList ? (SIPHeader)((ViaList)nextHeader).getFirst().clone() : (SIPHeader)nextHeader.clone();
                }
            }
            try {
                newRequest.attachHeader(nextHeader, false);
            }
            catch (SIPDuplicateHeaderException e) {
                e.printStackTrace();
            }
        }
        return newRequest;
    }

    public SIPRequest createSIPRequest(RequestLine requestLine, boolean switchHeaders) {
        SIPRequest newRequest = new SIPRequest();
        newRequest.requestLine = requestLine;
        ListIterator headerIterator = this.getHeaders();
        while (headerIterator.hasNext()) {
            SIPHeader nextHeader = (SIPHeader)headerIterator.next();
            if (nextHeader instanceof CSeq) {
                CSeq newCseq = (CSeq)nextHeader.clone();
                nextHeader = newCseq;
                try {
                    newCseq.setMethod(requestLine.getMethod());
                }
                catch (ParseException e) {}
            } else if (nextHeader instanceof ViaList) {
                Via via = (Via)((ViaList)nextHeader).getFirst().clone();
                via.removeParameter("branch");
                nextHeader = via;
            } else if (nextHeader instanceof To) {
                To to = (To)nextHeader;
                if (switchHeaders) {
                    nextHeader = new From(to);
                    ((From)nextHeader).removeTag();
                } else {
                    nextHeader = (SIPHeader)to.clone();
                    ((To)nextHeader).removeTag();
                }
            } else if (nextHeader instanceof From) {
                From from = (From)nextHeader;
                if (switchHeaders) {
                    nextHeader = new To(from);
                    ((To)nextHeader).removeTag();
                } else {
                    nextHeader = (SIPHeader)from.clone();
                    ((From)nextHeader).removeTag();
                }
            } else if (nextHeader instanceof ContentLength) {
                ContentLength cl = (ContentLength)nextHeader.clone();
                try {
                    cl.setContentLength(0);
                }
                catch (InvalidArgumentException e) {
                    // empty catch block
                }
                nextHeader = cl;
            } else if (!(nextHeader instanceof CallID) && !(nextHeader instanceof MaxForwards)) continue;
            try {
                newRequest.attachHeader(nextHeader, false);
            }
            catch (SIPDuplicateHeaderException e) {
                e.printStackTrace();
            }
        }
        return newRequest;
    }

    public SIPRequest createBYERequest(boolean switchHeaders) {
        RequestLine requestLine = (RequestLine)this.requestLine.clone();
        requestLine.setMethod("BYE");
        return this.createSIPRequest(requestLine, switchHeaders);
    }

    public SIPRequest createACKRequest() {
        RequestLine requestLine = (RequestLine)this.requestLine.clone();
        requestLine.setMethod("ACK");
        return this.createSIPRequest(requestLine, false);
    }

    public String getViaHost() {
        Via via = (Via)this.getViaHeaders().getFirst();
        return via.getHost();
    }

    public int getViaPort() {
        Via via = (Via)this.getViaHeaders().getFirst();
        if (via.hasPort()) {
            return via.getPort();
        }
        return 5060;
    }

    public String getFirstLine() {
        if (this.requestLine == null) {
            return null;
        }
        return this.requestLine.encode();
    }

    public void setSIPVersion(String sipVersion) throws ParseException {
        if (sipVersion == null || !sipVersion.equals("SIP/2.0")) {
            throw new ParseException("sipVersion", 0);
        }
        this.requestLine.setSIPVersion(sipVersion);
    }

    public String getSIPVersion() {
        return this.requestLine.getSipVersion();
    }

    public Object getTransaction() {
        return this.transactionPointer;
    }

    public void setTransaction(Object transaction) {
        this.transactionPointer = transaction;
    }
}

