/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.attribute;

import net.java.stun4j.StunException;
import net.java.stun4j.attribute.Attribute;

public class ErrorCodeAttribute
extends Attribute {
    public static final char BAD_REQUEST = '\u0190';
    public static final char UNAUTHORIZED = '\u0191';
    public static final char UNKNOWN_ATTRIBUTE = '\u01a4';
    public static final char STALE_CREDENTIALS = '\u01ae';
    public static final char INTEGRITY_CHECK_FAILURE = '\u01af';
    public static final char MISSING_USERNAME = '\u01b0';
    public static final char USE_TLS = '\u01b1';
    public static final char SERVER_ERROR = '\u01f4';
    public static final char GLOBAL_FAILURE = '\u0258';
    private byte errorClass = 0;
    private byte errorNumber = 0;
    private String reasonPhrase = null;
    public static final String NAME = "ERROR-CODE";

    ErrorCodeAttribute() {
        super('\t');
    }

    public void setErrorCode(char errorCode) throws StunException {
        this.setErrorClass((byte)(errorCode / 100));
        this.setErrorNumber((byte)(errorCode % 100));
    }

    public char getErrorCode() {
        return (char)(this.getErrorClass() * 100 + this.getErrorNumber());
    }

    public void setErrorNumber(byte errorNumber) throws StunException {
        if (errorNumber < 0 || errorNumber > 99) {
            throw new StunException(2, errorNumber + " is not a valid error number!");
        }
        this.errorNumber = errorNumber;
    }

    public byte getErrorNumber() {
        return this.errorNumber;
    }

    public void setErrorClass(byte errorClass) throws StunException {
        if (errorClass < 0 || errorClass > 99) {
            throw new StunException(2, errorClass + " is not a valid error number!");
        }
        this.errorClass = errorClass;
    }

    public byte getErrorClass() {
        return this.errorClass;
    }

    public static String getDefaultReasonPhrase(char errorCode) {
        switch (errorCode) {
            case '\u0190': {
                return "(Bad Request): The request was malformed.  The client should not retry the request without modification from the previous attempt.";
            }
            case '\u0191': {
                return "(Unauthorized): The Binding Request did not contain a MESSAGE-INTEGRITY attribute.";
            }
            case '\u01a4': {
                return "(Unknown Attribute): The server did not understand a mandatory attribute in the request.";
            }
            case '\u01ae': {
                return "(Stale Credentials): The Binding Request did contain a MESSAGE-INTEGRITY attribute, but it used a shared secret that has expired.  The client should obtain a new shared secret and tryagain";
            }
            case '\u01af': {
                return "(Integrity Check Failure): The Binding Request contained a MESSAGE-INTEGRITY attribute, but the HMAC failed verification. This could be a sign of a potential attack, or client implementation error.";
            }
            case '\u01b0': {
                return "(Missing Username): The Binding Request contained a MESSAGE-INTEGRITY attribute, but not a USERNAME attribute.  Both must bepresent for integrity checks.";
            }
            case '\u01b1': {
                return "(Use TLS): The Shared Secret request has to be sent over TLS, butwas not received over TLS.";
            }
            case '\u01f4': {
                return "(Server Error): The server has suffered a temporary error. Theclient should try again.";
            }
            case '\u0258': {
                return "(Global Failure:) The server is refusing to fulfill the request.The client should not retry.";
            }
        }
        return "Unknown Error";
    }

    public void setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public String getName() {
        return NAME;
    }

    public char getDataLength() {
        char len = (char)(4 + (char)(this.reasonPhrase == null ? 0 : this.reasonPhrase.length() * 2));
        len = (char)(len + (4 - len % 4));
        return len;
    }

    public byte[] encode() {
        byte[] binValue = new byte[4 + this.getDataLength()];
        binValue[0] = (byte)(this.getAttributeType() >> 8);
        binValue[1] = (byte)(this.getAttributeType() & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        binValue[4] = 0;
        binValue[5] = 0;
        binValue[6] = this.getErrorClass();
        binValue[7] = this.getErrorNumber();
        int offset = 8;
        char[] chars = this.reasonPhrase.toCharArray();
        int i = 0;
        while (i < this.reasonPhrase.length()) {
            binValue[offset] = (byte)(chars[i] >> 8);
            binValue[offset + 1] = (byte)(chars[i] & 0xFF);
            ++i;
            offset += 2;
        }
        if (this.reasonPhrase.length() % 4 != 0) {
            binValue[binValue.length - 2] = 0;
            binValue[binValue.length - 1] = 32;
        }
        return binValue;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ErrorCodeAttribute) || obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ErrorCodeAttribute att = (ErrorCodeAttribute)obj;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && att.getErrorClass() == this.getErrorClass() && att.getErrorNumber() == this.getErrorNumber() && (att.getReasonPhrase() == null || att.getReasonPhrase().equals(this.getReasonPhrase()));
    }

    void decodeAttributeBody(byte[] attributeValue, char offset, char length) throws StunException {
        char c = offset = (char)(offset + 2);
        offset = (char)(offset + '\u0001');
        this.setErrorClass(attributeValue[c]);
        char c2 = offset;
        offset = (char)(offset + '\u0001');
        this.setErrorNumber(attributeValue[c2]);
        char[] reasonPhrase = new char[(length - 4) / 2];
        int i = 0;
        while (i < reasonPhrase.length) {
            reasonPhrase[i] = (char)(attributeValue[offset] | attributeValue[offset + '\u0001']);
            ++i;
            offset = (char)(offset + 2);
        }
        this.setReasonPhrase(new String(reasonPhrase).trim());
    }
}

